/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import org.eclipse.birt.report.designer.internal.ui.swt.custom.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.DualRadioButtonPropertyDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.PropertyDescriptor;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DualRadioButtonPropertyDescriptor
extends PropertyDescriptor {
    private Composite composite;
    private Button radio1;
    private Button radio2;
    private String oldValue;
    private String[] items;

    public DualRadioButtonPropertyDescriptor(boolean formStyle) {
        this.setFormStyle(formStyle);
    }

    public Control createControl(Composite parent) {
        this.composite = this.isFormStyle() ? FormWidgetFactory.getInstance().createComposite(parent) : new Composite(parent, 2056);
        this.composite.setLayout((Layout)new GridLayout(2, false));
        if (this.getDescriptorProvider() != null) {
            this.items = ((DualRadioButtonPropertyDescriptorProvider)this.getDescriptorProvider()).getItems();
            this.radio1 = FormWidgetFactory.getInstance().createButton(this.composite, 16, this.isFormStyle());
            this.radio2 = FormWidgetFactory.getInstance().createButton(this.composite, 16, this.isFormStyle());
            this.radio1.setData((Object)this.items[0]);
            this.radio2.setData((Object)this.items[1]);
            this.radio1.setImage(ReportPlatformUIImages.getImageDescriptor((String)"LayoutAuto").createImage());
            this.radio2.setImage(ReportPlatformUIImages.getImageDescriptor((String)"LayoutFixed").createImage());
            this.radio1.setText(Messages.getString((String)"ApplyLayoutPreferenceAction.autoLayout"));
            this.radio2.setText(Messages.getString((String)"ApplyLayoutPreferenceAction.fixedLayout"));
            this.radio1.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    DualRadioButtonPropertyDescriptor.this.handleButtonSelectEvent(DualRadioButtonPropertyDescriptor.this.radio1);
                }
            });
            this.radio2.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    DualRadioButtonPropertyDescriptor.this.handleButtonSelectEvent(DualRadioButtonPropertyDescriptor.this.radio2);
                }
            });
        }
        return this.composite;
    }

    private void handleButtonSelectEvent(Button btn) {
        try {
            this.save(btn.getData());
        }
        catch (SemanticException e) {
            WidgetUtil.processError((Shell)btn.getShell(), (Exception)((Object)e));
        }
    }

    public void save(Object obj) throws SemanticException {
        this.getDescriptorProvider().save(obj);
    }

    public void load() {
        if (this.getDescriptorProvider() instanceof DualRadioButtonPropertyDescriptorProvider) {
            this.oldValue = ((DualRadioButtonPropertyDescriptorProvider)this.getDescriptorProvider()).load().toString();
            if (this.oldValue.equalsIgnoreCase((String)this.radio1.getData())) {
                this.radio1.setSelection(true);
                this.radio2.setSelection(false);
            } else {
                this.radio1.setSelection(false);
                this.radio2.setSelection(true);
            }
        }
    }

    public Control getControl() {
        return this.composite;
    }

    public void setInput(Object input) {
        this.getDescriptorProvider().setInput(input);
    }

    public void setHidden(boolean isHidden) {
        WidgetUtil.setExcludeGridData((Control)this.composite, (boolean)isHidden);
    }

    public void setVisible(boolean isVisible) {
        this.composite.setVisible(isVisible);
    }
}

