/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.section;

import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.Section;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.DescriptorToolkit;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.TextPropertyDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class TextSection
extends Section {
    private String oldValue;
    protected TextPropertyDescriptor textField;
    private int style = -1;
    private boolean fillText = false;
    private int width = -1;
    IDescriptorProvider provider;
    private int height = -1;

    public TextSection(String labelText, Composite parent, boolean formStyle) {
        super(labelText, parent, formStyle);
    }

    public void createSection() {
        this.getLabelControl(this.parent);
        this.getTextControl(this.parent);
        this.getGridPlaceholder(this.parent);
    }

    public void layout() {
        GridData gd = (GridData)this.textField.getControl().getLayoutData();
        gd.horizontalSpan = this.getLayoutNum() > 0 ? this.getLayoutNum() - 1 - this.placeholder : ((GridLayout)this.parent.getLayout()).numColumns - 1 - this.placeholder;
        if (this.width > -1) {
            gd.widthHint = this.width;
            gd.grabExcessHorizontalSpace = false;
        } else {
            gd.grabExcessHorizontalSpace = this.fillText;
        }
        if (this.height > -1) {
            gd.heightHint = this.height;
            gd.grabExcessVerticalSpace = false;
            if (this.displayLabel != null) {
                gd = (GridData)this.displayLabel.getLayoutData();
                gd.verticalAlignment = 16;
            }
        } else {
            gd.grabExcessVerticalSpace = this.fillText;
            if (this.fillText) {
                gd.verticalAlignment = 4;
                if (this.displayLabel != null) {
                    gd = (GridData)this.displayLabel.getLayoutData();
                    gd.verticalAlignment = 16;
                }
            }
        }
        if (this.fillText) {
            gd = (GridData)this.textField.getControl().getLayoutData();
            gd.grabExcessVerticalSpace = true;
            gd.verticalAlignment = 4;
        }
    }

    public String getStringValue() {
        if (this.textField != null) {
            return this.textField.getText();
        }
        return null;
    }

    public TextPropertyDescriptor getTextControl() {
        return this.textField;
    }

    protected TextPropertyDescriptor getTextControl(Composite parent) {
        if (this.textField == null) {
            this.textField = DescriptorToolkit.createTextPropertyDescriptor(this.isFormStyle);
            if (this.getProvider() != null) {
                this.textField.setDescriptorProvider(this.getProvider());
            }
            if (this.style != -1) {
                this.textField.setStyle(this.style);
            }
            this.textField.createControl(parent);
            this.textField.getControl().setLayoutData((Object)new GridData());
            this.textField.getControl().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    TextSection.this.textField = null;
                }
            });
        } else {
            this.checkParent(this.textField.getControl(), parent);
        }
        return this.textField;
    }

    public void setFocus() {
        if (this.textField != null) {
            this.textField.getControl().setFocus();
        }
    }

    public void setStringValue(String value) {
        if (this.textField != null) {
            if (value == null) {
                value = "";
            }
            this.oldValue = this.textField.getText();
            if (!this.oldValue.equals(value)) {
                this.textField.setText(value);
            }
        }
    }

    public void setTextLimit(int limit) {
        if (this.textField != null) {
            this.textField.setTextLimit(limit);
        }
    }

    public void load() {
        if (this.textField != null && !this.textField.getControl().isDisposed()) {
            this.textField.load();
        }
    }

    public void reset() {
        if (this.textField != null && !this.textField.getControl().isDisposed()) {
            this.textField.reset();
        }
    }

    public IDescriptorProvider getProvider() {
        return this.provider;
    }

    public void setProvider(IDescriptorProvider provider) {
        this.provider = provider;
        if (this.textField != null) {
            this.textField.setDescriptorProvider(provider);
        }
    }

    public void setInput(Object input) {
        assert (input != null);
        this.textField.setInput(input);
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public boolean isFillText() {
        return this.fillText;
    }

    public void setFillText(boolean fillText) {
        this.fillText = fillText;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setHidden(boolean isHidden) {
        if (this.displayLabel != null) {
            WidgetUtil.setExcludeGridData((Control)this.displayLabel, (boolean)isHidden);
        }
        if (this.textField != null) {
            this.textField.setHidden(isHidden);
        }
        if (this.placeholderLabel != null) {
            WidgetUtil.setExcludeGridData((Control)this.placeholderLabel, (boolean)isHidden);
        }
    }

    public void setVisible(boolean isVisible) {
        if (this.displayLabel != null) {
            this.displayLabel.setVisible(isVisible);
        }
        if (this.textField != null) {
            this.textField.setVisible(isVisible);
        }
        if (this.placeholderLabel != null) {
            this.placeholderLabel.setVisible(isVisible);
        }
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int style) {
        this.style = style;
    }
}

