/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.section;

import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.Section;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.DescriptorToolkit;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.ResourceKeyDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ResourceKeySection
extends Section {
    protected ResourceKeyDescriptor resource;
    IDescriptorProvider provider;
    private int width = -1;
    private boolean fillResource = false;
    private String oldValue;

    public ResourceKeySection(String labelText, Composite parent, boolean isFormStyle) {
        super(labelText, parent, isFormStyle);
    }

    public void createSection() {
        this.getLabelControl(this.parent);
        this.getResourceKeyControl(this.parent);
        this.getGridPlaceholder(this.parent);
    }

    public void layout() {
        GridData gd = (GridData)this.resource.getControl().getLayoutData();
        gd.horizontalSpan = this.getLayoutNum() > 0 ? this.getLayoutNum() - 1 - this.placeholder : ((GridLayout)this.parent.getLayout()).numColumns - 1 - this.placeholder;
        if (this.width > -1) {
            gd.widthHint = this.width;
            gd.grabExcessHorizontalSpace = false;
        } else {
            gd.grabExcessHorizontalSpace = this.fillResource;
        }
    }

    protected ResourceKeyDescriptor getResourceKeyControl(Composite parent) {
        if (this.resource == null) {
            this.resource = DescriptorToolkit.createResourceKeyDescriptor(this.isFormStyle);
            if (this.getProvider() != null) {
                this.resource.setDescriptorProvider(this.getProvider());
            }
            this.resource.createControl(parent);
            this.resource.getControl().setLayoutData((Object)new GridData());
            this.resource.getControl().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    ResourceKeySection.this.resource = null;
                }
            });
        } else {
            this.checkParent(this.resource.getControl(), parent);
        }
        return this.resource;
    }

    public ResourceKeyDescriptor getResourceKeyControl() {
        return this.resource;
    }

    public IDescriptorProvider getProvider() {
        return this.provider;
    }

    public void setProvider(IDescriptorProvider provider) {
        this.provider = provider;
        if (this.resource != null) {
            this.resource.setDescriptorProvider(provider);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setInput(Object input) {
        assert (input != null);
        this.resource.setInput(input);
    }

    public boolean isFillResource() {
        return this.fillResource;
    }

    public void setFillResource(boolean fillResource) {
        this.fillResource = fillResource;
    }

    public void setStringValue(String value) {
        if (this.resource != null) {
            if (value == null) {
                value = "";
            }
            this.oldValue = this.resource.getStringValue();
            if (!this.oldValue.equals(value)) {
                this.resource.setStringValue(value);
            }
        }
    }

    public void setFocus() {
        if (this.resource != null) {
            this.resource.getControl().setFocus();
        }
    }

    public String getStringValue() {
        if (this.resource != null) {
            return this.resource.getStringValue();
        }
        return null;
    }

    public void load() {
        if (this.resource != null && !this.resource.getControl().isDisposed()) {
            this.resource.load();
        }
    }

    public void setHidden(boolean isHidden) {
        if (this.displayLabel != null) {
            WidgetUtil.setExcludeGridData((Control)this.displayLabel, (boolean)isHidden);
        }
        if (this.resource != null) {
            this.resource.setHidden(isHidden);
        }
        if (this.placeholderLabel != null) {
            WidgetUtil.setExcludeGridData((Control)this.placeholderLabel, (boolean)isHidden);
        }
    }

    public void setVisible(boolean isVisible) {
        if (this.displayLabel != null) {
            this.displayLabel.setVisible(isVisible);
        }
        if (this.resource != null) {
            this.resource.setVisible(isVisible);
        }
        if (this.placeholderLabel != null) {
            this.placeholderLabel.setVisible(isVisible);
        }
    }
}

