/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.page;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.AttributePage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.Section;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;

public abstract class ResetAttributePage
extends AttributePage {
    public void reset() {
        if (!this.canReset()) {
            return;
        }
        CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
        stack.startTrans(Messages.getString((String)"ResetAttributePage.Style.Restore.Transaction.Name"));
        Section[] sectionArray = this.getSections();
        int i = 0;
        while (i < sectionArray.length) {
            Section section = sectionArray[i];
            section.reset();
            ++i;
        }
        stack.commit();
    }

    public boolean canReset() {
        return true;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IAction.class && this.canReset()) {
            return new Action[]{new ResetAction()};
        }
        return null;
    }

    class ResetAction
    extends Action {
        ResetAction() {
            super(null, 1);
            this.setImageDescriptor(ReportPlatformUIImages.getImageDescriptor((String)"StyleRestore"));
            this.setToolTipText(Messages.getString((String)"ResetAttributePage.Style.Restore.TooltipText"));
        }

        public void run() {
            ResetAttributePage.this.reset();
        }
    }
}

