/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.handles;

import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.editors.ReportColorConstants;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.AbstractTableEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.MultipleEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.handles.AbstractGuideHandle;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.handles.NothingLocator;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.providers.SchematicContextMenuProvider;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.ReportElementDragTracker;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.extensions.IReportItemViewProvider;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.birt.report.designer.ui.views.ProviderFactory;
import org.eclipse.birt.report.designer.util.FontManager;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.gef.handles.MoveHandleLocator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class MultipleGuideHandle
extends AbstractGuideHandle {
    private static final String REMOVE = Messages.getString((String)"MultipleGuideHandle.RemoveView");

    public MultipleGuideHandle(GraphicalEditPart owner) {
        super(owner, (Locator)new MutipleLocator(owner));
    }

    public void setSelected(int number) {
        List list = this.getChildren();
        if (number < 0 || number > list.size() - 1) {
            return;
        }
        int i = 0;
        while (i < list.size()) {
            if (!(list.get(i) instanceof ShowSourceFigure)) {
                ChildrenGuideHandle handle = (ChildrenGuideHandle)((Object)list.get(i));
                if (i == number) {
                    handle.setSelected(true);
                } else {
                    handle.setSelected(false);
                }
            }
            ++i;
        }
        this.repaint();
    }

    public void addChildren(List list) {
        List children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            Figure figure = (Figure)children.get(i);
            this.remove((IFigure)figure);
            ++i;
        }
        Font font = this.getFont();
        if (font == null) {
            font = this.getDefaultFont();
            this.setFont(font);
        }
        ChildrenGuideHandle first = new ChildrenGuideHandle(this.getOwner(), 0);
        first.setSelected(true);
        first.setIndicatorLabel(this.getLabel(this.getOwner().getModel()));
        first.setIndicatorIcon(this.getImage(this.getOwner().getModel()));
        Dimension dim = first.calculateIndicatorDimension(font, 1);
        first.setSize(dim);
        this.add((IFigure)first);
        int i2 = 1;
        while (i2 <= list.size()) {
            ChildrenGuideHandle handle = new ChildrenGuideHandle(this.getOwner(), i2);
            handle.setIndicatorLabel(this.getLabel(list.get(i2 - 1)));
            handle.setIndicatorIcon(this.getImage(list.get(i2 - 1)));
            Dimension size = handle.calculateIndicatorDimension(font, 1);
            handle.setSize(size);
            this.add((IFigure)handle);
            ++i2;
        }
    }

    private Font getDefaultFont() {
        return FontManager.getFont((String)"Tahoma", (int)8, (int)0);
    }

    protected Dimension calculateIndicatorDimension() {
        Dimension retValue = new Dimension();
        List children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            Figure figure = (Figure)children.get(i);
            if (!(figure instanceof ShowSourceFigure)) {
                retValue.width += figure.getSize().width;
                retValue.height = Math.max(retValue.height, figure.getSize().height);
            }
            ++i;
        }
        return retValue;
    }

    private Image getImage(Object obj) {
        Object ownerModel = this.getOwner().getModel();
        if (ownerModel == obj) {
            return ProviderFactory.createProvider(obj).getNodeIcon(obj);
        }
        return null;
    }

    private String getLabel(Object obj) {
        Object ownerModel = this.getOwner().getModel();
        if (ownerModel == obj) {
            return ProviderFactory.createProvider(obj).getNodeDisplayName(obj);
        }
        Object[] objs = ElementAdapterManager.getAdapters(this.getOwner().getModel(), IReportItemViewProvider.class);
        if (objs != null) {
            return ((IReportItemViewProvider)objs[0]).getViewName();
        }
        return "";
    }

    private static class ChildrenDragTracker
    extends ReportElementDragTracker {
        private IMenuListener listener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Action action = new Action(REMOVE){

                    public void run() {
                        ((MultipleEditPart)ChildrenDragTracker.this.getSourceEditPart()).removeView(ChildrenDragTracker.this.number);
                    }

                    public boolean isEnabled() {
                        int position = ChildrenDragTracker.this.number - 1;
                        List list = ((ReportItemHandle)ChildrenDragTracker.this.getSourceEditPart().getModel()).getViews();
                        if (position < 0 && position > list.size() - 1) {
                            return false;
                        }
                        return ((DesignElementHandle)list.get(position)).canDrop();
                    }
                };
                ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
                action.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
                manager.add((IAction)action);
            }
        };
        private int number;

        public ChildrenDragTracker(EditPart sourceEditPart, int number) {
            super(sourceEditPart);
            this.number = number;
        }

        protected void performConditionalSelection() {
            super.performConditionalSelection();
            ((MultipleEditPart)this.getSourceEditPart()).setCurrentView(this.number);
        }

        protected void performSelection() {
            if (this.hasSelectionOccurred()) {
                return;
            }
            EditPart real = null;
            List children = this.getSourceEditPart().getChildren();
            int i = 0;
            while (i < children.size()) {
                if (children.get(i) instanceof AbstractTableEditPart) {
                    real = (EditPart)children.get(i);
                    break;
                }
                ++i;
            }
            if (real == null) {
                real = this.getSourceEditPart();
            }
            this.setFlag(64, true);
            EditPartViewer viewer = this.getCurrentViewer();
            List selectedObjects = viewer.getSelectedEditParts();
            if (this.getCurrentInput().isModKeyDown(SWT.MOD1)) {
                if (selectedObjects.contains(this.getSourceEditPart())) {
                    viewer.deselect(this.getSourceEditPart());
                } else if (this.number == 0) {
                    viewer.appendSelection(real);
                } else {
                    viewer.appendSelection(this.getSourceEditPart());
                }
            } else if (this.getCurrentInput().isShiftKeyDown()) {
                if (this.number == 0) {
                    viewer.appendSelection(real);
                } else {
                    viewer.appendSelection(this.getSourceEditPart());
                }
            } else if (this.number == 0) {
                viewer.select(real);
            } else {
                viewer.select(this.getSourceEditPart());
            }
        }

        protected boolean handleButtonDown(int button) {
            if (button == 3 && this.number != 0) {
                ((SchematicContextMenuProvider)this.getSourceEditPart().getViewer().getContextMenu()).setProxy(this.listener);
            }
            return super.handleButtonDown(button);
        }

        protected boolean handleButtonUp(int button) {
            return super.handleButtonUp(button);
        }
    }

    private static class ChildrenGuideHandle
    extends AbstractGuideHandle {
        private boolean isSelected = false;
        private Figure showSource = new ShowSourceFigure();
        private int number;
        protected Image image;
        protected String indicatorLabel = "  ";
        int gap;
        protected Insets gapInsets = new Insets(3, 3, 3, 3);

        public ChildrenGuideHandle(GraphicalEditPart owner, int number) {
            super(owner, new NothingLocator());
            this.number = number;
        }

        protected DragTracker createDragTracker() {
            return new ChildrenDragTracker((EditPart)this.getOwner(), this.number);
        }

        public void setIndicatorLabel(String indicatorLabel) {
            if (indicatorLabel != null) {
                this.indicatorLabel = indicatorLabel;
            }
        }

        public void mouseEntered(MouseEvent me) {
            if (this.showSource.getParent() == null && !this.isSelected()) {
                Rectangle rect = this.getBounds().getCopy();
                this.showSource.setBounds(rect);
                this.getParent().add((IFigure)this.showSource);
            }
            super.mouseEntered(me);
        }

        public void mouseExited(MouseEvent me) {
            if (this.showSource.getParent() != null) {
                this.showSource.getParent().remove((IFigure)this.showSource);
            }
            super.mouseExited(me);
        }

        public void setIndicatorIcon(Image image) {
            this.image = image;
        }

        public void paintFigure(Graphics graphics) {
            int width = 1;
            Rectangle bounds = this.getBounds().getCopy();
            bounds.y += 2;
            if (this.isSelected()) {
                graphics.setBackgroundColor(ReportColorConstants.TableGuideFillColor);
            } else {
                graphics.setBackgroundColor(ReportColorConstants.MultipleSelectionHandleColor);
            }
            graphics.fillRectangle(bounds);
            graphics.setForegroundColor(ReportColorConstants.ShadowLineColor);
            bounds = this.getBounds().getCopy();
            graphics.drawLine(bounds.x, bounds.y, bounds.x, bounds.y + bounds.height);
            graphics.drawLine(bounds.x, bounds.y + bounds.height - 1, bounds.x + bounds.width, bounds.y + bounds.height - 1);
            graphics.drawLine(bounds.x + bounds.width - 1, bounds.y, bounds.x + bounds.width - 1, bounds.y + bounds.height);
            graphics.setForegroundColor(ReportColorConstants.TableGuideFillColor);
            graphics.drawLine(bounds.x, bounds.y, bounds.x + bounds.width - 1, bounds.y);
            int x = this.getBounds().x + this.gapInsets.left;
            if (this.image != null) {
                graphics.drawImage(this.image, x, bounds.y + this.gapInsets.top);
                x += this.image.getBounds().width + this.gap;
            }
            graphics.setForegroundColor(ReportColorConstants.TableGuideTextColor);
            graphics.drawString(this.indicatorLabel, x + 2 * width, bounds.y + 2 + this.gapInsets.top - width);
        }

        protected Dimension calculateIndicatorDimension(Font font, int width) {
            this.gap = 0;
            Dimension iconDimension = new Dimension();
            if (this.image != null) {
                iconDimension = new Dimension(this.image);
                this.gap = 2;
            }
            Dimension d = FigureUtilities.getTextExtents((String)this.indicatorLabel, (Font)font);
            int incheight = 0;
            if (iconDimension.height > d.height) {
                incheight = iconDimension.height - d.height;
            }
            d.expand(iconDimension.width + this.gap + this.gapInsets.left + this.gapInsets.right + 2 * width + 2, incheight + this.gapInsets.top + this.gapInsets.bottom);
            return d;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public void setSelected(boolean isSelected) {
            this.isSelected = isSelected;
            if (isSelected && this.showSource.getParent() != null) {
                this.showSource.getParent().remove((IFigure)this.showSource);
            }
        }
    }

    private static class MutipleLocator
    extends MoveHandleLocator {
        public MutipleLocator(GraphicalEditPart part) {
            super(part.getFigure());
        }

        public void relocate(IFigure target) {
            Rectangle bounds = this.getReference() instanceof HandleBounds ? ((HandleBounds)this.getReference()).getHandleBounds() : this.getReference().getBounds();
            Dimension dim = ((MultipleGuideHandle)target).calculateIndicatorDimension();
            bounds = new PrecisionRectangle(new Rectangle(bounds.x, bounds.y + bounds.height, dim.width, dim.height));
            Rectangle copy = bounds.getCopy();
            this.getReference().translateToAbsolute((Translatable)bounds);
            target.translateToRelative((Translatable)bounds);
            bounds.width = copy.width;
            bounds.height = copy.height;
            target.setBounds(bounds);
            this.relocateChildren(target, this.getReference());
        }

        private void relocateChildren(IFigure parent, IFigure reference) {
            List children = parent.getChildren();
            int size = children.size();
            int width = parent.getBounds().x;
            Dimension pDim = ((MultipleGuideHandle)parent).calculateIndicatorDimension();
            int height = pDim.height;
            int y = parent.getBounds().y;
            int i = 0;
            while (i < size) {
                IFigure f = (IFigure)children.get(i);
                if (!(f instanceof ShowSourceFigure)) {
                    Rectangle bounds = f.getBounds().getCopy();
                    bounds = new PrecisionRectangle(bounds);
                    Dimension dim = bounds.getSize();
                    bounds.width = dim.width;
                    bounds.height = height;
                    bounds.y = y;
                    bounds.x = width;
                    width += dim.width;
                    f.setBounds(bounds);
                }
                ++i;
            }
        }
    }

    private static class ShowSourceFigure
    extends Figure {
        private ShowSourceFigure() {
        }

        protected void paintFigure(Graphics graphics) {
            Rectangle rect = this.getBounds();
            graphics.setLineWidth(2);
            graphics.drawRectangle(rect);
            graphics.drawLine(rect.x, rect.y - 1, rect.x + rect.width, rect.y - 1);
            graphics.drawLine(rect.x, rect.y, rect.x, rect.y + rect.height);
            graphics.setLineWidth(3);
            graphics.drawLine(rect.x + rect.width, rect.y, rect.x + rect.width, rect.y + rect.height);
            graphics.drawLine(rect.x, rect.y + rect.height, rect.x + rect.width, rect.y + rect.height);
        }

        public boolean containsPoint(int x, int y) {
            return false;
        }
    }
}

