/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.ui.login.shell.tabs.licenca;

import java.io.File;
import java.nio.file.CopyOption;
import java.util.Calendar;
import org.dma.eclipse.jface.CustomAction;
import org.dma.eclipse.jface.dialogs.message.ErrorDialog;
import org.dma.eclipse.swt.dialogs.file.FileImport;
import org.dma.eclipse.swt.input.validation.IValidator;
import org.dma.eclipse.swt.input.validation.field.IFieldRules;
import org.dma.eclipse.swt.widgets.CustomCTabItem;
import org.dma.java.input.FieldFormat;
import org.dma.java.io.CustomFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.language.LABELS;
import org.projectocolibri.ui.login.shell.LoginShell;
import org.projectocolibri.ui.login.shell.tabs.licenca.LoginTab2Validator;
import org.projectocolibri.ui.login.widgets.ColibriTextButton;
import org.projectocolibri.xml.beans.StringConverter;
import org.projectocolibri.xml.beans.licencas.ColibriLicenca;
import org.projectocolibri.xml.beans.licencas.LICENCAS;

public class LoginTab2
extends CustomCTabItem
implements IFieldRules {
    private Label label_ficheiro;
    private Text text_ficheiro;
    private Label label_titular;
    private Text text_titular;
    private Label label_tipo;
    private Text text_tipo;
    private Label label_validade;
    private Text text_validade;
    private Label label_modulos;
    private Text text_modulos;
    private Label label_renovacao;
    private Text text_renovacao;
    private final LoginShell shell;
    private ColibriLicenca licenca = ColibriLicenca.load();

    public ColibriLicenca getLicenca() {
        return this.licenca;
    }

    public LoginTab2(CTabFolder tabFolder, LoginShell shell) {
        super(tabFolder, 0);
        this.shell = shell;
        this.setText(LABELS.login_tab_licenca.toString());
        this.setControl((Control)this.createContents());
        this.registerValidator();
    }

    private Composite createContents() {
        Composite composite = new Composite((Composite)this.getParent(), 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        this.label_ficheiro = new Label(composite, 0);
        this.label_ficheiro.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.label_ficheiro.setText(LABELS.login_licenca_ficheiro.toString());
        this.text_ficheiro = new Text(composite, 2048);
        this.text_ficheiro.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new ColibriTextButton(composite, LABELS.botao_carregar.toString()).setSelectionAction((IAction)new CustomAction(){

            public void run() {
                LoginTab2.this.licenca = new ColibriLicenca(LoginTab2.this.shell.getPassword());
                if (LoginTab2.this.licenca.isValid()) {
                    LoginTab2.this.updateTarget(Colibri.VERSION_TYPE.name());
                } else {
                    File file = new FileImport((Shell)LoginTab2.this.shell, new String[]{Colibri.FILES.LICENCA.parameters.wildcards}).filePicker();
                    if (file != null) {
                        LoginTab2.this.licenca = ColibriLicenca.load((File)file, (String)LoginTab2.this.shell.getPassword());
                        if (!LoginTab2.this.licenca.isValid()) {
                            ErrorDialog.open((String)LABELS.erro_licenca_invalida.toString());
                        } else if (!new CustomFile(file).copyTo((File)Colibri.FILES.LICENCA.parameters.toFile(), new CopyOption[0])) {
                            ErrorDialog.open((String)LABELS.erro_interno.toString());
                        } else {
                            LoginTab2.this.updateTarget(file.getName());
                        }
                    }
                }
            }
        });
        this.label_titular = new Label(composite, 0);
        this.label_titular.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.label_titular.setText(LABELS.login_licenca_titular.toString());
        this.text_titular = new Text(composite, 2048);
        this.text_titular.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ColibriTextButton button = new ColibriTextButton(composite, LABELS.botao_registar.toString());
        button.setToolTipText(Colibri.WEBPAGES.REGISTO.name);
        button.setSelectionAction((IAction)new CustomAction(){

            public void run() {
                Colibri.WEBPAGES.REGISTO.browse();
            }
        });
        this.label_tipo = new Label(composite, 0);
        this.label_tipo.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.label_tipo.setText(LABELS.login_licenca_tipo.toString());
        this.text_tipo = new Text(composite, 2048);
        this.text_tipo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.label_validade = new Label(composite, 0);
        this.label_validade.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.label_validade.setText(LABELS.login_licenca_validade.toString());
        this.text_validade = new Text(composite, 2048);
        this.text_validade.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.label_modulos = new Label(composite, 0);
        this.label_modulos.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.label_modulos.setText(LABELS.login_licenca_modulos.toString());
        this.text_modulos = new Text(composite, 2048);
        this.text_modulos.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.label_renovacao = new Label(composite, 0);
        this.label_renovacao.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.label_renovacao.setText(LABELS.login_licenca_renovacao.toString());
        this.text_renovacao = new Text(composite, 2048);
        this.text_renovacao.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        return composite;
    }

    private void registerValidator() {
        LoginTab2Validator validator = new LoginTab2Validator(this);
        validator.register(LABELS.login_licenca_ficheiro.name(), this.label_ficheiro, (Control)this.text_ficheiro, new FieldFormat(FieldFormat.TYPES.STRING, 255, new char[0]), 2);
        validator.register(LABELS.login_licenca_titular.name(), this.label_titular, (Control)this.text_titular, new FieldFormat(FieldFormat.TYPES.STRING, 255, new char[0]), 2);
        validator.register(LABELS.login_licenca_tipo.name(), this.label_tipo, (Control)this.text_tipo, new FieldFormat(FieldFormat.TYPES.STRING, 255, new char[0]), 2);
        validator.register(LABELS.login_licenca_validade.name(), this.label_validade, (Control)this.text_validade, new FieldFormat(FieldFormat.TYPES.STRING, 255, new char[0]), 2);
        validator.register(LABELS.login_licenca_modulos.name(), this.label_modulos, (Control)this.text_modulos, new FieldFormat(FieldFormat.TYPES.STRING, 255, new char[0]), 2);
        validator.register(LABELS.login_licenca_renovacao.name(), this.label_renovacao, (Control)this.text_renovacao, new FieldFormat(FieldFormat.TYPES.STRING, 255, new char[0]), 2);
        this.shell.getValidationManager().register(this.getText(), (IValidator)validator);
    }

    public void updateTarget(String text) {
        if (this.licenca.isValid()) {
            this.text_titular.setText(this.licenca.getNomeTitular());
            this.text_tipo.setText(this.licenca.getTipo().name());
            this.text_validade.setText(this.licenca.getValidade());
            this.text_modulos.setText(this.licenca.xml.getModulos().toString());
            this.text_renovacao.setText(StringConverter.toString((Calendar)this.licenca.xml.getRenovacao()));
        } else {
            this.text_titular.setText("");
            this.text_tipo.setText("");
            this.text_validade.setText("");
            this.text_modulos.setText("");
            this.text_renovacao.setText("");
        }
        this.text_ficheiro.setText(text);
        this.text_ficheiro.setFocus();
        this.shell.getTab_aviso().updateTarget(this.licenca.isTipo(LICENCAS.DEMO) ? Colibri.FILES.MESSAGES.AVISO_VERSAO_DEMO.text : (Colibri.MARKET_TYPE == Colibri.MARKETS.INTERNAL ? Colibri.FILES.MESSAGES.AVISO_CERTIFICACAO.text : ""));
    }
}

