/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.ui.login.shell.tabs.empresas;

import java.io.File;
import org.dma.eclipse.jface.CustomAction;
import org.dma.eclipse.jface.dialogs.message.ErrorDialog;
import org.dma.eclipse.jface.dialogs.message.QuestionDialog;
import org.dma.eclipse.swt.dialogs.file.FileExport;
import org.dma.eclipse.swt.dialogs.file.FileImport;
import org.dma.eclipse.swt.input.validation.IValidator;
import org.dma.eclipse.swt.widgets.CustomCTabItem;
import org.dma.eclipse.swt.widgets.CustomTable;
import org.dma.java.util.MessageList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolBar;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.language.LABELS;
import org.projectocolibri.ui.login.shell.LoginShell;
import org.projectocolibri.ui.login.shell.tabs.empresas.LoginTab1Container;
import org.projectocolibri.ui.login.shell.tabs.empresas.LoginTab1LabelProvider;
import org.projectocolibri.ui.login.shell.tabs.empresas.LoginTab1Validator;
import org.projectocolibri.ui.login.widgets.ColibriToolItem;
import org.projectocolibri.xml.beans.empresas.ColibriEmpresa;

public class LoginTab1
extends CustomCTabItem {
    private final LoginShell shell;
    private LoginTab1Container tableContainer;
    public final CustomAction novoRegistoAction = new CustomAction(){

        public void run() {
            LoginTab1.this.tableContainer.createObject();
        }
    };
    public final CustomAction anularRegistoAction = new CustomAction(){

        public void run() {
            if (QuestionDialog.open((String)LABELS.pergunta_registo_anular.toString())) {
                ErrorDialog.open((MessageList)LoginTab1.this.tableContainer.removeObject());
            }
        }
    };
    public final CustomAction importarRegistoAction = new CustomAction(){

        public void run() {
            File file = new FileImport((Shell)LoginTab1.this.shell, new String[]{Colibri.FILES.DATABASES.EMPRESAS.parameters.wildcards}).filePicker();
            if (file == null) {
                ErrorDialog.open((String)LABELS.erro_database_ligacaofalhada.toString());
            } else if (ColibriEmpresa.getDatabase().copyDatabaseFrom(file)) {
                LoginTab1.this.tableContainer.updateTable();
            }
        }
    };
    public final CustomAction exportarRegistoAction = new CustomAction(){

        public void run() {
            File file = new FileExport((Shell)LoginTab1.this.shell, new String[]{Colibri.FILES.DATABASES.EMPRESAS.parameters.wildcards}).filePicker(Colibri.FILES.DATABASES.EMPRESAS.parameters.filename);
            if (file == null) {
                ErrorDialog.open((String)LABELS.erro_database_criacaofalhada.toString());
            } else if (ColibriEmpresa.getDatabase().copyDatabaseTo(file)) {
                LoginTab1.this.tableContainer.updateTable();
            }
        }
    };

    public LoginTab1Container getTableContainer() {
        return this.tableContainer;
    }

    public LoginTab1(CTabFolder tabFolder, LoginShell shell) {
        super(tabFolder, 0);
        this.shell = shell;
        this.setText(LABELS.login_tab_empresas.toString());
        this.setControl((Control)this.createContents());
        this.registerValidator();
    }

    private Composite createContents() {
        Composite composite = new Composite((Composite)this.getParent(), 0);
        composite.setLayout((Layout)new GridLayout());
        this.createToolBar(composite);
        this.createTableContainer(composite);
        return composite;
    }

    private void createTableContainer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        CustomTable table = new CustomTable(composite, 67588);
        COLUMNS[] cOLUMNSArray = COLUMNS.values();
        int n = cOLUMNSArray.length;
        int n2 = 0;
        while (n2 < n) {
            COLUMNS column = cOLUMNSArray[n2];
            table.createColumn(column.style).setText(column.label);
            ++n2;
        }
        table.addResizeListener(0);
        TableViewer tableViewer = new TableViewer((Table)table);
        tableViewer.setLabelProvider((IBaseLabelProvider)new LoginTab1LabelProvider());
        this.tableContainer = new LoginTab1Container(tableViewer, this.shell);
        table.select(0);
    }

    private void createToolBar(Composite parent) {
        ToolBar toolBar = new ToolBar(parent, 0);
        ColibriToolItem toolItem = new ColibriToolItem(toolBar, LABELS.operacao_registo_novo.toString());
        toolItem.setImage(Colibri.ICONS.ACTION_NOVO);
        toolItem.setSelectionAction((IAction)this.novoRegistoAction);
        toolItem = new ColibriToolItem(toolBar, LABELS.operacao_registo_anular.toString());
        toolItem.setImage(Colibri.ICONS.ACTION_ANULAR);
        toolItem.setSelectionAction((IAction)this.anularRegistoAction);
        toolItem = new ColibriToolItem(toolBar, LABELS.operacao_registo_importar.toString());
        toolItem.setImage(Colibri.ICONS.ACTION_IMPORTAR);
        toolItem.setSelectionAction((IAction)this.importarRegistoAction);
        toolItem = new ColibriToolItem(toolBar, LABELS.operacao_registo_exportar.toString());
        toolItem.setImage(Colibri.ICONS.ACTION_EXPORTAR);
        toolItem.setSelectionAction((IAction)this.exportarRegistoAction);
    }

    private void registerValidator() {
        this.shell.getValidationManager().register(this.getText(), (IValidator)new LoginTab1Validator(this));
    }

    public static enum COLUMNS {
        NOME(LABELS.login_empresas_nome.toString(), 0),
        DRIVER(LABELS.login_empresas_database_driver.toString(), 0),
        HOST(LABELS.login_empresas_database_host.toString(), 0),
        DATABASE(LABELS.login_empresas_database_database.toString(), 0);

        public final String label;
        public final int style;

        private COLUMNS(String label, int style) {
            this.label = label;
            this.style = style;
        }
    }
}

