/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.ui.login.shell;

import org.dma.eclipse.jface.CustomAction;
import org.dma.eclipse.jface.dialogs.message.ErrorDialog;
import org.dma.eclipse.jface.dialogs.message.InformationDialog;
import org.dma.eclipse.swt.graphics.ColorManager;
import org.dma.eclipse.swt.input.support.TraverseSupport;
import org.dma.eclipse.swt.input.validation.IValidationManager;
import org.dma.eclipse.swt.input.validation.IValidator;
import org.dma.eclipse.swt.input.validation.ValidationManager;
import org.dma.eclipse.swt.input.validation.field.IFieldRules;
import org.dma.eclipse.swt.widgets.CustomButton;
import org.dma.eclipse.swt.widgets.CustomShell;
import org.dma.java.input.FieldFormat;
import org.dma.java.util.Debug;
import org.dma.java.util.ErrorList;
import org.dma.java.util.MessageList;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.database.ColibriDatabase;
import org.projectocolibri.api.database.DatabaseParameters;
import org.projectocolibri.api.language.LABELS;
import org.projectocolibri.ui.login.shell.LoginShellValidator;
import org.projectocolibri.ui.login.shell.tabs.acordo.LoginTab4;
import org.projectocolibri.ui.login.shell.tabs.aviso.LoginTab5;
import org.projectocolibri.ui.login.shell.tabs.empresas.LoginTab1;
import org.projectocolibri.ui.login.shell.tabs.licenca.LoginTab2;
import org.projectocolibri.ui.login.shell.tabs.lingua.LoginTab3;
import org.projectocolibri.xml.beans.licencas.ColibriLicenca;
import org.projectocolibri.xml.beans.licencas.ILicencaListener;
import org.projectocolibri.xml.beans.licencas.LicencaListener;
import org.projectocolibri.xml.empresas.EmpresaDocument;

public class LoginShell
extends CustomShell
implements IFieldRules {
    public static final String VERSAO = LABELS.VERSAO + " " + Colibri.PROJECTO_VERSAO;
    public static final String DEPOSITO = LABELS.DEPOSITO_ASSOFT + " n\u00ba" + "1419/D/07";
    public static final String CERTIFICACAO = Colibri.MARKET_TYPE == Colibri.MARKETS.INTERNAL ? LABELS.SOFTWARE_CERTIFICADO + " n\u00ba" + 38 + "/AT" : LABELS.NAO_LICENCIADO_PORTUGAL.toString();
    public final int BUTTON_WIDTH = 150;
    private final IValidationManager validationManager = new ValidationManager(){

        public void postError(String message) {
            Debug.err((String)message);
        }
    };
    private LoginTab1 tab_empresas;
    private LoginTab2 tab_licenca;
    private LoginTab3 tab_lingua;
    private LoginTab4 tab_acordo;
    private LoginTab5 tab_aviso;
    private Label label_user;
    private Text text_user;
    private Label label_password;
    private Text text_password;
    private ColibriDatabase.LOGIN_RESULT result = ColibriDatabase.LOGIN_RESULT.EXIT;
    public final CustomAction loginAction = new CustomAction(){

        public void run() {
            LoginShell.this.setVisible(false);
            String user = LoginShell.this.text_user.getText();
            String password = LoginShell.this.text_password.getText();
            DatabaseParameters parameters = new DatabaseParameters((EmpresaDocument.Empresa)LoginShell.this.getTab_empresas().getTableContainer().getSelectionElement());
            ErrorList error = LoginShell.this.doLogin(LoginShell.this.getLicenca(), parameters, user, password);
            if (ErrorDialog.open((MessageList)error.errors())) {
                LoginShell.this.setVisible(true);
                LoginShell.this.forceActive();
            } else {
                Colibri.PREFERENCES.LOGIN_USER.value.setValue(user);
                InformationDialog.open((MessageList)error.warnings());
                LoginShell.this.dispose(ColibriDatabase.LOGIN_RESULT.LOGIN);
            }
        }
    };

    public LoginTab1 getTab_empresas() {
        return this.tab_empresas;
    }

    public LoginTab2 getTab_licenca() {
        return this.tab_licenca;
    }

    public LoginTab3 getTab_lingua() {
        return this.tab_lingua;
    }

    public LoginTab4 getTab_acordo() {
        return this.tab_acordo;
    }

    public LoginTab5 getTab_aviso() {
        return this.tab_aviso;
    }

    public IValidationManager getValidationManager() {
        return this.validationManager;
    }

    public ColibriLicenca getLicenca() {
        return this.tab_licenca.getLicenca();
    }

    public String getPassword() {
        return this.text_password.getText();
    }

    public ColibriDatabase.LOGIN_RESULT getResult() {
        return this.result;
    }

    public LoginShell(Display display) {
        this(display, true);
    }

    public LoginShell(Display display, boolean openAndSleep) {
        super(display.getActiveShell(), 34032);
        this.setText(String.valueOf(Colibri.PROJECTO_NOME) + " - " + LABELS.login_window.toString());
        this.setImages(new Image[]{Colibri.ICONS.COLIBRI_LOGO_16.getImage(), Colibri.ICONS.COLIBRI_LOGO_32.getImage(), Colibri.ICONS.COLIBRI_LOGO_48.getImage(), Colibri.ICONS.COLIBRI_LOGO_64.getImage(), Colibri.ICONS.COLIBRI_LOGO_128.getImage(), Colibri.ICONS.COLIBRI_LOGO_256.getImage()});
        this.setGridLayout();
        this.createTabs();
        this.createComposite();
        this.registerValidator();
        this.pack();
        this.setCenteredLocation();
        if (openAndSleep) {
            this.openAndSleep();
        }
    }

    public boolean setFocus() {
        return this.text_password.setFocus();
    }

    public void dispose(ColibriDatabase.LOGIN_RESULT result) {
        this.result = result;
        this.dispose();
    }

    public ErrorList doLogin(ColibriLicenca licenca, DatabaseParameters parameters, String user, String password) {
        this.getLicenca().setListener((ILicencaListener)new LicencaListener());
        return ColibriDatabase.login((ColibriLicenca)licenca, (DatabaseParameters)parameters, (String)user, (String)password);
    }

    private void createTabs() {
        CTabFolder tabFolder = new CTabFolder((Composite)this, 0);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 550;
        gridData.heightHint = 168;
        tabFolder.setLayoutData((Object)gridData);
        tabFolder.pack();
        tabFolder.setBorderVisible(true);
        tabFolder.setSimple(false);
        tabFolder.setSelectionBackground(ColorManager.getColor((int)19));
        this.tab_empresas = new LoginTab1(tabFolder, this);
        this.tab_licenca = new LoginTab2(tabFolder, this);
        this.tab_lingua = new LoginTab3(tabFolder, this);
        this.tab_acordo = new LoginTab4(tabFolder, this);
        this.tab_aviso = new LoginTab5(tabFolder, this);
        tabFolder.setSelection((CTabItem)(this.getLicenca().isValid() ? this.tab_empresas : this.tab_licenca));
        this.tab_licenca.updateTarget("");
    }

    private void createComposite() {
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        TraverseSupport traverseSupport = new TraverseSupport(true);
        new Label(composite, 0).setText(DEPOSITO);
        this.label_user = new Label(composite, 0);
        this.label_user.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        this.label_user.setText(LABELS.login_utilizador.toString());
        this.text_user = new Text(composite, 2048);
        this.text_user.setLayoutData((Object)new GridData(150, -1));
        this.text_user.setText(Colibri.PREFERENCES.LOGIN_USER.value.getString());
        traverseSupport.add((Control)this.text_user);
        new Label(composite, 0).setText(CERTIFICACAO);
        this.label_password = new Label(composite, 0);
        this.label_password.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        this.label_password.setText(LABELS.login_password.toString());
        this.text_password = new Text(composite, 0x400800);
        this.text_password.setLayoutData((Object)new GridData(150, -1));
        this.text_password.setText(Colibri.ACCESS_PASSWORD.toString());
        traverseSupport.add((Control)this.text_password);
        new Label(composite, 0).setText(VERSAO);
        new Label(composite, 0);
        CustomButton button = new CustomButton(composite, 0);
        GridData gridData = new GridData(0x1000000, 0x1000000, false, false);
        gridData.widthHint = 150;
        button.setLayoutData((Object)gridData);
        button.setText(LABELS.botao_login.toString());
        button.setSelectionAction((IAction)this.loginAction);
        traverseSupport.add((Control)button);
    }

    private void registerValidator() {
        LoginShellValidator validator = new LoginShellValidator(this);
        validator.register(LABELS.login_utilizador.name(), this.label_user, (Control)this.text_user, new FieldFormat(FieldFormat.TYPES.STRING, 60, new char[]{FieldFormat.KEYBOARD.SPACE.code}), 8);
        validator.register(LABELS.login_password.name(), this.label_password, (Control)this.text_password, new FieldFormat(FieldFormat.TYPES.STRING, 255, new char[0]), 0);
        this.validationManager.register(this.getText(), (IValidator)validator);
    }
}

