/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.ui.login.empresas.tabs.database;

import org.dma.eclipse.swt.input.validation.field.FieldError;
import org.projectocolibri.api.database.DRIVERS;
import org.projectocolibri.api.database.DatabaseParameters;
import org.projectocolibri.api.language.LABELS;
import org.projectocolibri.ui.login.empresas.tabs.database.EmpresasTab2;
import org.projectocolibri.ui.login.widgets.FieldValidator;

public class EmpresasTab2Validator
extends FieldValidator {
    private final EmpresasTab2 tab;

    public EmpresasTab2Validator(EmpresasTab2 tab) {
        this.tab = tab;
    }

    public boolean isEdited() {
        return this.tab.getShell().getEdited();
    }

    public void validateInput() {
        DatabaseParameters parameters = this.tab.getShell().getParameters();
        if (!parameters.isHostValid(this.tab.getShell().getLicenca())) {
            this.getProperty(LABELS.login_empresas_database_host.name()).setError(FieldError.ERRORS.INVALID_VALUE);
        }
        if (!parameters.isH2Embedded() && parameters.database.isEmpty()) {
            this.getProperty(LABELS.login_empresas_database_database.name()).setError(FieldError.ERRORS.INVALID_VALUE);
        }
    }

    public void validateButtons() {
        this.tab.databaseSearchAction.enable();
        DatabaseParameters parameters = this.tab.getShell().getParameters();
        if (parameters.driver != DRIVERS.H2) {
            this.tab.databaseSearchAction.disable();
        }
    }
}

