/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.ui.login.empresas.tabs.backups;

import java.io.File;
import org.dma.eclipse.jface.CustomAction;
import org.dma.eclipse.swt.dialogs.file.FileImport;
import org.dma.eclipse.swt.dialogs.file.FolderDialog;
import org.dma.eclipse.swt.input.support.TraverseSupport;
import org.dma.eclipse.swt.input.validation.IValidator;
import org.dma.eclipse.swt.input.validation.field.IFieldRules;
import org.dma.eclipse.swt.widgets.CustomCTabItem;
import org.dma.java.input.FieldFormat;
import org.dma.java.io.Folder;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.database.DatabaseParameters;
import org.projectocolibri.api.language.LABELS;
import org.projectocolibri.ui.login.empresas.EmpresasShell;
import org.projectocolibri.ui.login.empresas.tabs.backups.EmpresasTab3Validator;
import org.projectocolibri.ui.login.widgets.ColibriTextButton;
import org.projectocolibri.xml.beans.StringConverter;
import org.projectocolibri.xml.empresas.EmpresaDocument;

public class EmpresasTab3
extends CustomCTabItem
implements IFieldRules {
    private Label label_folder;
    private Text text_folder;
    private Label label_command;
    private Text text_command;
    private Label label_arguments;
    private Text text_arguments;
    private final EmpresasShell shell;
    public final CustomAction folderSearchAction = new CustomAction(){

        public void run() {
            Folder folder = new FolderDialog((Shell)EmpresasTab3.this.shell, new String[0]).folderPicker(Colibri.FOLDERS.BACKUPS.folder);
            if (folder != null) {
                EmpresasTab3.this.text_folder.setText(folder.getAbsolutePath());
            }
        }

        public void setEnabled(boolean enabled) {
            EmpresasTab3.this.text_folder.setEnabled(enabled);
            super.setEnabled(enabled);
        }
    };
    public final CustomAction commandSearchAction = new CustomAction(){

        public void run() {
            DatabaseParameters parameters = EmpresasTab3.this.shell.getParameters();
            File file = new FileImport((Shell)EmpresasTab3.this.shell, new String[]{String.valueOf(parameters.driver.backup.command) + ".*"}).filePicker();
            if (file != null) {
                EmpresasTab3.this.text_command.setText(file.getAbsolutePath());
            }
        }

        public void setEnabled(boolean enabled) {
            EmpresasTab3.this.text_command.setEnabled(enabled);
            super.setEnabled(enabled);
        }
    };
    public final CustomAction argumentsLoadAction = new CustomAction(){

        public void run() {
            DatabaseParameters parameters = EmpresasTab3.this.shell.getParameters();
            if (EmpresasTab3.this.text_folder.getText().isEmpty()) {
                EmpresasTab3.this.text_folder.setText(parameters.driver.backup.folder);
            }
            if (EmpresasTab3.this.text_command.getText().isEmpty()) {
                EmpresasTab3.this.text_command.setText(parameters.driver.backup.command);
            }
            EmpresasTab3.this.text_arguments.setText(parameters.driver.backup.arguments.toString());
        }

        public void setEnabled(boolean enabled) {
            EmpresasTab3.this.text_arguments.setEnabled(enabled);
            super.setEnabled(enabled);
        }
    };

    public EmpresasShell getShell() {
        return this.shell;
    }

    public EmpresasTab3(CTabFolder tabFolder, EmpresasShell shell) {
        super(tabFolder, 0);
        this.shell = shell;
        this.setText(LABELS.login_empresas_tab_backups.toString());
        this.setControl((Control)this.createContents());
        this.registerValidator();
        this.updateTarget();
    }

    private Composite createContents() {
        Composite composite = new Composite((Composite)this.getParent(), 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        TraverseSupport traverseSupport = new TraverseSupport(true);
        this.label_folder = new Label(composite, 0);
        this.label_folder.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.label_folder.setText(LABELS.login_empresas_backups_folder.toString());
        this.text_folder = new Text(composite, 2048);
        this.text_folder.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        traverseSupport.add((Control)this.text_folder);
        new ColibriTextButton(composite, LABELS.botao_procurar.toString()).setSelectionAction((IAction)this.folderSearchAction);
        this.label_command = new Label(composite, 0);
        this.label_command.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.label_command.setText(LABELS.login_empresas_backups_command.toString());
        this.text_command = new Text(composite, 2048);
        this.text_command.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        traverseSupport.add((Control)this.text_command);
        new ColibriTextButton(composite, LABELS.botao_procurar.toString()).setSelectionAction((IAction)this.commandSearchAction);
        this.label_arguments = new Label(composite, 0);
        this.label_arguments.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.label_arguments.setText(LABELS.login_empresas_backups_arguments.toString());
        this.text_arguments = new Text(composite, 2048);
        this.text_arguments.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        traverseSupport.add((Control)this.text_arguments);
        new ColibriTextButton(composite, LABELS.botao_carregar.toString()).setSelectionAction((IAction)this.argumentsLoadAction);
        return composite;
    }

    private void registerValidator() {
        EmpresasTab3Validator validator = new EmpresasTab3Validator(this);
        validator.register(LABELS.login_empresas_backups_folder.name(), this.label_folder, (Control)this.text_folder, new FieldFormat(FieldFormat.TYPES.STRING, 255, new char[0]), 0);
        validator.register(LABELS.login_empresas_backups_command.name(), this.label_command, (Control)this.text_command, new FieldFormat(FieldFormat.TYPES.STRING, 255, new char[0]), 0);
        validator.register(LABELS.login_empresas_backups_arguments.name(), this.label_arguments, (Control)this.text_arguments, 0);
        this.shell.getValidationManager().register(this.getText(), (IValidator)validator);
    }

    private void updateTarget() {
        EmpresaDocument.Empresa.Dbcolibri.Backups backup = this.shell.getEmpresa().getDbcolibri().getBackups();
        if (backup != null) {
            try {
                this.text_folder.setText(StringConverter.trim((String)backup.getFolder()));
                this.text_command.setText(StringConverter.trim((String)backup.getCommand()));
                this.text_arguments.setText(StringConverter.trim((String)backup.getArguments()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void updateModel(EmpresaDocument.Empresa.Dbcolibri.Backups backup) {
        try {
            backup.setFolder(StringConverter.trim((String)this.text_folder.getText()));
            backup.setCommand(StringConverter.trim((String)this.text_command.getText()));
            backup.setArguments(StringConverter.trim((String)this.text_arguments.getText()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

