/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.internal.rcp.wizards;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Locale;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.ReportEditorInput;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.wizards.WizardReportSettingPage;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.internal.rcp.wizards.WizardNewReportCreationPage;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class NewReportTemplateWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    private static final String NEW = Messages.getString((String)"NewTemplateWizard.title.New");
    private static final String REPORT = Messages.getString((String)"NewTemplateWizard.title.Template");
    private static final String WIZARDPAGE = Messages.getString((String)"NewTemplateWizard.title.WizardPage");
    private static final String CREATE_A_NEW_REPORT = Messages.getString((String)"NewTemplateWizard.text.CreateReport");
    private static final String CREATING = Messages.getString((String)"NewTemplateWizard.text.Creating");
    private static final String OPENING_FILE_FOR_EDITING = Messages.getString((String)"NewTemplateWizard.text.OpenFileForEditing");
    private static final String NEW_REPORT_FILE_NAME_PREFIX = Messages.getString((String)"NewTemplateWizard.displayName.NewReportFileNamePrefix");
    private String fileExtension = ".rpttemplate";
    private static final String TEMPLATE_FILE = "/templates/blank_report.rpttemplate";
    private static final String SAVE_TEMPLATE_PROPERTIES_MESSAGES = Messages.getString((String)"SaveReportAsWizard.SettingPage.Messages");
    private WizardNewReportCreationPage newReportFileWizardPage;
    private WizardReportSettingPage settingPage;

    public NewReportTemplateWizard() {
        this.setWindowTitle(NEW);
    }

    public Image getDefaultPageImage() {
        return ReportPlugin.getImage((String)"/icons/wizban/create_report_wizard.gif");
    }

    public void addPages() {
        this.newReportFileWizardPage = new WizardNewReportCreationPage(WIZARDPAGE){

            public boolean validatePage() {
                return this.validatePage(NewReportTemplateWizard.this.fileExtension);
            }
        };
        this.addPage((IWizardPage)this.newReportFileWizardPage);
        this.newReportFileWizardPage.setTitle(REPORT);
        this.newReportFileWizardPage.setDescription(CREATE_A_NEW_REPORT);
        this.newReportFileWizardPage.setInitialFileName(this.getNewFileFullName(NEW_REPORT_FILE_NAME_PREFIX));
        this.newReportFileWizardPage.setInitialFileLocation(this.getDefaultLocation());
        this.settingPage = new WizardReportSettingPage(null);
        this.settingPage.setTitle(Messages.getFormattedString((String)"SaveReportAsWizard.SettingPage.title", (Object[])new Object[]{Messages.getString((String)"NewTemplateWizard.WizardPageTitle.Template")}));
        this.settingPage.setPageDesc(SAVE_TEMPLATE_PROPERTIES_MESSAGES);
        this.addPage((IWizardPage)this.settingPage);
    }

    private String getDefaultLocation() {
        IPath defaultPath = Platform.getLocation();
        return defaultPath.toOSString();
    }

    private String getNewFileFullName(String defaultName) {
        String path = this.getDefaultLocation();
        String name = String.valueOf(defaultName) + this.fileExtension;
        int count = 0;
        File file = new File(path, name);
        while (file.exists()) {
            name = String.valueOf(defaultName) + "_" + ++count + this.fileExtension;
            file = null;
            file = new File(path, name);
        }
        file = null;
        return name;
    }

    public boolean performFinish() {
        String templateFileName;
        final IPath locPath = this.newReportFileWizardPage.getFileLocationFullPath();
        String fn = this.newReportFileWizardPage.getFileName();
        final String fileName = !Platform.getOS().equals("win32") ? (!fn.endsWith(this.fileExtension) ? String.valueOf(fn) + this.fileExtension : fn) : (!fn.toLowerCase(Locale.getDefault()).endsWith(this.fileExtension) ? String.valueOf(fn) + this.fileExtension : fn);
        if (Platform.getBundle((String)"org.eclipse.birt.resources") == null) {
            return true;
        }
        URL url = FileLocator.find((Bundle)Platform.getBundle((String)"org.eclipse.birt.resources"), (IPath)new Path(TEMPLATE_FILE), null);
        if (url == null) {
            return true;
        }
        try {
            templateFileName = FileLocator.resolve((URL)url).getPath();
        }
        catch (IOException iOException) {
            return false;
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                try {
                    NewReportTemplateWizard.this.doFinish(locPath, fileName, templateFileName, monitor);
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            ExceptionUtil.handle((Throwable)realException);
            return false;
        }
        return true;
    }

    private void doFinish(IPath locationPath, String fileName, String templateFileName, IProgressMonitor monitor) {
        monitor.beginTask(String.valueOf(CREATING) + fileName, 2);
        final File file = new File(locationPath.toString(), fileName);
        try {
            File container = new File(locationPath.toString());
            boolean conExists = container.exists();
            if (!conExists) {
                conExists = container.mkdirs();
            }
            if (!conExists) {
                ExceptionUtil.openError((String)Messages.getString((String)"PublishTemplateAction.wizard.errorTitle"), (String)Messages.getString((String)"PublishTemplateAction.wizard.msgDirErr"));
                return;
            }
        }
        catch (Exception e) {
            ExceptionUtil.handle((Throwable)e);
        }
        try {
            ReportDesignHandle handle = SessionHandleAdapter.getInstance().getSessionHandle().createDesignFromTemplate(templateFileName);
            if (ReportPlugin.getDefault().getEnableCommentPreference()) {
                handle.setStringProperty("comments", ReportPlugin.getDefault().getCommentPreference());
            }
            this.setReportSettings(handle);
            handle.setBidiOrientation(ReportPlugin.getDefault().getLTRReportDirection() ? "ltr" : "rtl");
            handle.saveAs(file.getAbsolutePath());
            handle.close();
        }
        catch (Exception e) {
            ExceptionUtil.handle((Throwable)e);
        }
        monitor.worked(1);
        monitor.setTaskName(OPENING_FILE_FOR_EDITING);
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                IWorkbenchPage page = window.getActivePage();
                try {
                    if (page == null) {
                        throw new IllegalArgumentException();
                    }
                    page.openEditor((IEditorInput)new ReportEditorInput(file), "org.eclipse.birt.report.designer.ui.editors.TemplateEditor", true);
                }
                catch (Exception e) {
                    ExceptionUtil.handle((Throwable)e);
                }
            }
        });
        monitor.worked(1);
    }

    public boolean canFinish() {
        return this.newReportFileWizardPage.isPageComplete() && this.settingPage.canFinish();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    void setReportSettings(Object model) throws IOException {
        ReportDesignHandle handle = (ReportDesignHandle)model;
        try {
            handle.setDisplayName(this.settingPage.getDisplayName());
            handle.setDescription(this.settingPage.getDescription());
            handle.setIconFile(this.settingPage.getPreviewImagePath());
            UIUtil.addCreateBy((ModuleHandle)handle);
            UIUtil.setDPI((ReportDesignHandle)handle);
        }
        catch (SemanticException semanticException) {}
    }
}

