/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.ForeignKeyMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.IndexMetaData;
import org.datanucleus.metadata.KeyMetaData;
import org.datanucleus.metadata.MapMetaData;
import org.datanucleus.metadata.PrimaryKeyMetaData;
import org.datanucleus.metadata.UniqueMetaData;
import org.datanucleus.metadata.ValueMetaData;
import org.datanucleus.store.exceptions.NoTableManagedException;
import org.datanucleus.store.mapped.ColumnCreator;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.DatastoreMap;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.EmbeddedKeyPCMapping;
import org.datanucleus.store.mapped.mapping.EmbeddedValuePCMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.PersistableMapping;
import org.datanucleus.store.mapped.mapping.ReferenceMapping;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.adapter.RDBMSAdapter;
import org.datanucleus.store.rdbms.key.CandidateKey;
import org.datanucleus.store.rdbms.key.ForeignKey;
import org.datanucleus.store.rdbms.key.Index;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.JoinTable;
import org.datanucleus.store.rdbms.table.TableUtils;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;

public class MapTable
extends JoinTable
implements DatastoreMap {
    private JavaTypeMapping keyMapping;
    private JavaTypeMapping valueMapping;
    private JavaTypeMapping orderMapping;
    protected Map embeddedKeyMappingsMap;
    protected Map embeddedValueMappingsMap;

    public MapTable(DatastoreIdentifier tableName, AbstractMemberMetaData mmd, RDBMSStoreManager storeMgr) {
        super(tableName, mmd, storeMgr);
    }

    public void initialize(ClassLoaderResolver clr) {
        this.assertIsUninitialized();
        MapMetaData mapmd = this.mmd.getMap();
        if (mapmd == null) {
            throw new NucleusUserException(LOCALISER.msg("057017", (Object)this.mmd));
        }
        PrimaryKeyMetaData pkmd = this.mmd.getJoinMetaData() != null ? this.mmd.getJoinMetaData().getPrimaryKeyMetaData() : null;
        boolean pkColsSpecified = pkmd != null && pkmd.getColumnMetaData() != null;
        boolean pkRequired = this.requiresPrimaryKey();
        ColumnMetaData[] ownerColmd = null;
        if (this.mmd.getJoinMetaData() != null && this.mmd.getJoinMetaData().getColumnMetaData() != null && this.mmd.getJoinMetaData().getColumnMetaData().length > 0) {
            ownerColmd = this.mmd.getJoinMetaData().getColumnMetaData();
        }
        this.ownerMapping = ColumnCreator.createColumnsForJoinTables((Class)clr.classForName(this.ownerType), (AbstractMemberMetaData)this.mmd, (ColumnMetaData[])ownerColmd, (MappedStoreManager)this.storeMgr, (DatastoreContainerObject)this, (boolean)pkRequired, (boolean)false, (int)1, (ClassLoaderResolver)clr);
        if (NucleusLogger.DATASTORE.isDebugEnabled()) {
            this.debugMapping(this.ownerMapping);
        }
        boolean keyPC = this.mmd.hasMap() && this.mmd.getMap().keyIsPersistent();
        Class keyCls = clr.classForName(mapmd.getKeyType());
        if (this.isSerialisedKey() || this.isEmbeddedKeyPC() || this.isEmbeddedKey() && !keyPC || ClassUtils.isReferenceType((Class)keyCls)) {
            this.keyMapping = this.storeMgr.getMappingManager().getMapping((DatastoreContainerObject)this, this.mmd, clr, 5);
            if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                this.debugMapping(this.keyMapping);
            }
        } else {
            ColumnMetaData[] keyColmd = null;
            KeyMetaData keymd = this.mmd.getKeyMetaData();
            if (keymd != null && keymd.getColumnMetaData() != null && keymd.getColumnMetaData().length > 0) {
                keyColmd = keymd.getColumnMetaData();
            }
            this.keyMapping = ColumnCreator.createColumnsForJoinTables((Class)keyCls, (AbstractMemberMetaData)this.mmd, (ColumnMetaData[])keyColmd, (MappedStoreManager)this.storeMgr, (DatastoreContainerObject)this, (boolean)false, (boolean)false, (int)5, (ClassLoaderResolver)clr);
            if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                this.debugMapping(this.keyMapping);
            }
        }
        boolean valuePC = this.mmd.hasMap() && this.mmd.getMap().valueIsPersistent();
        Class valueCls = clr.classForName(mapmd.getValueType());
        if (this.isSerialisedValue() || this.isEmbeddedValuePC() || this.isEmbeddedValue() && !valuePC || ClassUtils.isReferenceType((Class)valueCls)) {
            this.valueMapping = this.storeMgr.getMappingManager().getMapping((DatastoreContainerObject)this, this.mmd, clr, 6);
            if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                this.debugMapping(this.valueMapping);
            }
        } else {
            ColumnMetaData[] valueColmd = null;
            ValueMetaData valuemd = this.mmd.getValueMetaData();
            if (valuemd != null && valuemd.getColumnMetaData() != null && valuemd.getColumnMetaData().length > 0) {
                valueColmd = valuemd.getColumnMetaData();
            }
            this.valueMapping = ColumnCreator.createColumnsForJoinTables((Class)clr.classForName(mapmd.getValueType()), (AbstractMemberMetaData)this.mmd, (ColumnMetaData[])valueColmd, (MappedStoreManager)this.storeMgr, (DatastoreContainerObject)this, (boolean)false, (boolean)true, (int)6, (ClassLoaderResolver)clr);
            if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                this.debugMapping(this.valueMapping);
            }
        }
        boolean orderRequired = false;
        if (this.mmd.getOrderMetaData() != null) {
            orderRequired = true;
        } else if (this.requiresPrimaryKey() && !pkColsSpecified) {
            if (this.isEmbeddedKeyPC()) {
                if (this.mmd.getMap().getKeyClassMetaData(clr, this.storeMgr.getMetaDataManager()).getIdentityType() != IdentityType.APPLICATION) {
                    orderRequired = true;
                }
            } else if (this.isSerialisedKey()) {
                orderRequired = true;
            } else if (this.keyMapping instanceof ReferenceMapping) {
                ReferenceMapping refMapping = (ReferenceMapping)this.keyMapping;
                if (refMapping.getJavaTypeMapping().length > 1) {
                    orderRequired = true;
                }
            } else if (!(this.keyMapping instanceof PersistableMapping)) {
                Column elementCol = (Column)this.keyMapping.getDatastoreMapping(0).getDatastoreField();
                if (!((RDBMSAdapter)this.storeMgr.getDatastoreAdapter()).isValidPrimaryKeyType(elementCol.getJdbcType())) {
                    orderRequired = true;
                }
            }
        }
        if (orderRequired) {
            DatastoreIdentifier id;
            ColumnMetaData orderColmd = null;
            if (this.mmd.getOrderMetaData() != null && this.mmd.getOrderMetaData().getColumnMetaData() != null && this.mmd.getOrderMetaData().getColumnMetaData().length > 0) {
                orderColmd = this.mmd.getOrderMetaData().getColumnMetaData()[0];
                if (orderColmd.getName() == null) {
                    orderColmd = new ColumnMetaData(orderColmd);
                    if (this.mmd.hasExtension("adapter-column-name")) {
                        orderColmd.setName(this.mmd.getValueForExtension("adapter-column-name"));
                    } else {
                        id = this.storeMgr.getIdentifierFactory().newIndexFieldIdentifier(this.mmd);
                        orderColmd.setName(id.getIdentifierName());
                    }
                }
            } else if (this.mmd.hasExtension("adapter-column-name")) {
                orderColmd = new ColumnMetaData();
                orderColmd.setName(this.mmd.getValueForExtension("adapter-column-name"));
            } else {
                id = this.storeMgr.getIdentifierFactory().newIndexFieldIdentifier(this.mmd);
                orderColmd = new ColumnMetaData();
                orderColmd.setName(id.getIdentifierName());
            }
            this.orderMapping = this.storeMgr.getMappingManager().getMapping(Integer.TYPE);
            ColumnCreator.createIndexColumn((JavaTypeMapping)this.orderMapping, (MappedStoreManager)this.storeMgr, (ClassLoaderResolver)clr, (DatastoreContainerObject)this, (ColumnMetaData)orderColmd, (pkRequired && !pkColsSpecified ? 1 : 0) != 0);
            if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                this.debugMapping(this.orderMapping);
            }
        }
        if (pkRequired) {
            if (pkColsSpecified) {
                this.applyUserPrimaryKeySpecification(pkmd);
            } else if (orderRequired) {
                this.orderMapping.getDatastoreMapping(0).getDatastoreField().setAsPrimaryKey();
            } else {
                for (int i = 0; i < this.keyMapping.getNumberOfDatastoreMappings(); ++i) {
                    this.keyMapping.getDatastoreMapping(i).getDatastoreField().setAsPrimaryKey();
                }
            }
        }
        this.state = 2;
    }

    protected void applyUserPrimaryKeySpecification(PrimaryKeyMetaData pkmd) {
        ColumnMetaData[] pkCols = pkmd.getColumnMetaData();
        for (int i = 0; i < pkCols.length; ++i) {
            int j;
            String colName = pkCols[i].getName();
            boolean found = false;
            for (j = 0; j < this.ownerMapping.getNumberOfDatastoreMappings(); ++j) {
                if (!this.ownerMapping.getDatastoreMapping(j).getDatastoreField().getIdentifier().getIdentifierName().equals(colName)) continue;
                this.ownerMapping.getDatastoreMapping(j).getDatastoreField().setAsPrimaryKey();
                found = true;
            }
            if (!found) {
                for (j = 0; j < this.keyMapping.getNumberOfDatastoreMappings(); ++j) {
                    if (!this.keyMapping.getDatastoreMapping(j).getDatastoreField().getIdentifier().getIdentifierName().equals(colName)) continue;
                    this.keyMapping.getDatastoreMapping(j).getDatastoreField().setAsPrimaryKey();
                    found = true;
                }
            }
            if (!found) {
                for (j = 0; j < this.valueMapping.getNumberOfDatastoreMappings(); ++j) {
                    if (!this.valueMapping.getDatastoreMapping(j).getDatastoreField().getIdentifier().getIdentifierName().equals(colName)) continue;
                    this.valueMapping.getDatastoreMapping(j).getDatastoreField().setAsPrimaryKey();
                    found = true;
                }
            }
            if (found) continue;
            throw new NucleusUserException(LOCALISER.msg("057040", (Object)this.toString(), (Object)colName));
        }
    }

    public boolean isEmbeddedKey() {
        if (this.mmd.getMap() != null && this.mmd.getMap().isSerializedKey()) {
            return false;
        }
        return this.mmd.getMap() != null && this.mmd.getMap().isEmbeddedKey();
    }

    public boolean isSerialisedKey() {
        return this.mmd.getMap() != null && this.mmd.getMap().isSerializedKey();
    }

    public boolean isSerialisedKeyPC() {
        return this.mmd.getMap() != null && this.mmd.getMap().isSerializedKey() && this.mmd.getMap().keyIsPersistent();
    }

    public boolean isEmbeddedKeyPC() {
        if (this.mmd.getMap() != null && this.mmd.getMap().isSerializedKey()) {
            return false;
        }
        return this.mmd.getKeyMetaData() != null && this.mmd.getKeyMetaData().getEmbeddedMetaData() != null;
    }

    public boolean isEmbeddedValue() {
        if (this.mmd.getMap() != null && this.mmd.getMap().isSerializedValue()) {
            return false;
        }
        return this.mmd.getMap() != null && this.mmd.getMap().isEmbeddedValue();
    }

    public boolean isSerialisedValue() {
        return this.mmd.getMap() != null && this.mmd.getMap().isSerializedValue();
    }

    public boolean isSerialisedValuePC() {
        return this.mmd.getMap() != null && this.mmd.getMap().isSerializedValue() && this.mmd.getMap().valueIsPersistent();
    }

    public boolean isEmbeddedValuePC() {
        if (this.mmd.getMap() != null && this.mmd.getMap().isSerializedValue()) {
            return false;
        }
        return this.mmd.getValueMetaData() != null && this.mmd.getValueMetaData().getEmbeddedMetaData() != null;
    }

    public JavaTypeMapping getKeyMapping() {
        this.assertIsInitialized();
        return this.keyMapping;
    }

    public JavaTypeMapping getValueMapping() {
        this.assertIsInitialized();
        return this.valueMapping;
    }

    public String getKeyType() {
        return this.mmd.getMap().getKeyType();
    }

    public String getValueType() {
        return this.mmd.getMap().getValueType();
    }

    public JavaTypeMapping getOrderMapping() {
        this.assertIsInitialized();
        return this.orderMapping;
    }

    protected List getExpectedForeignKeys(ClassLoaderResolver clr) {
        this.assertIsInitialized();
        boolean autoMode = false;
        if (this.storeMgr.getOMFContext().getPersistenceConfiguration().getStringProperty("datanucleus.rdbms.constraintCreateMode").equals("DataNucleus")) {
            autoMode = true;
        }
        ArrayList<ForeignKey> foreignKeys = new ArrayList<ForeignKey>();
        try {
            ForeignKey fk;
            Collection fks;
            AbstractMemberMetaData embFmd;
            JavaTypeMapping embFieldMapping;
            EmbeddedValuePCMapping embMapping;
            ForeignKey fk2;
            ForeignKeyMetaData fkmd;
            DatastoreClass referencedTable = this.storeMgr.getDatastoreClass(this.ownerType, clr);
            if (referencedTable != null) {
                fkmd = null;
                if (this.mmd.getJoinMetaData() != null) {
                    fkmd = this.mmd.getJoinMetaData().getForeignKeyMetaData();
                }
                if (fkmd != null || autoMode) {
                    fk2 = new ForeignKey(this.ownerMapping, this.dba, referencedTable, true);
                    fk2.setForMetaData(fkmd);
                    foreignKeys.add(fk2);
                }
            }
            if (!this.isSerialisedValuePC()) {
                if (this.isEmbeddedValuePC()) {
                    embMapping = (EmbeddedValuePCMapping)this.valueMapping;
                    for (int i = 0; i < embMapping.getNumberOfJavaTypeMappings(); ++i) {
                        embFieldMapping = embMapping.getJavaTypeMapping(i);
                        embFmd = embFieldMapping.getMemberMetaData();
                        if (ClassUtils.isReferenceType((Class)embFmd.getType()) && embFieldMapping instanceof ReferenceMapping) {
                            fks = TableUtils.getForeignKeysForReferenceField(embFieldMapping, embFmd, autoMode, this.storeMgr, clr);
                            foreignKeys.addAll(fks);
                            continue;
                        }
                        if (this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(embFmd.getType(), clr) == null || embFieldMapping.getNumberOfDatastoreMappings() <= 0 || !(embFieldMapping instanceof PersistableMapping) || (fk = TableUtils.getForeignKeyForPCField(embFieldMapping, embFmd, autoMode, this.storeMgr, clr)) == null) continue;
                        foreignKeys.add(fk);
                    }
                } else if (this.mmd.getMap().valueIsPersistent() && (referencedTable = this.storeMgr.getDatastoreClass(this.mmd.getMap().getValueType(), clr)) != null) {
                    fkmd = null;
                    if (this.mmd.getValueMetaData() != null) {
                        fkmd = this.mmd.getValueMetaData().getForeignKeyMetaData();
                    }
                    if (fkmd != null || autoMode) {
                        fk2 = new ForeignKey(this.valueMapping, this.dba, referencedTable, true);
                        fk2.setForMetaData(fkmd);
                        foreignKeys.add(fk2);
                    }
                }
            }
            if (!this.isSerialisedKeyPC()) {
                if (this.isEmbeddedKeyPC()) {
                    embMapping = (EmbeddedKeyPCMapping)this.keyMapping;
                    for (int i = 0; i < embMapping.getNumberOfJavaTypeMappings(); ++i) {
                        embFieldMapping = embMapping.getJavaTypeMapping(i);
                        embFmd = embFieldMapping.getMemberMetaData();
                        if (ClassUtils.isReferenceType((Class)embFmd.getType()) && embFieldMapping instanceof ReferenceMapping) {
                            fks = TableUtils.getForeignKeysForReferenceField(embFieldMapping, embFmd, autoMode, this.storeMgr, clr);
                            foreignKeys.addAll(fks);
                            continue;
                        }
                        if (this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(embFmd.getType(), clr) == null || embFieldMapping.getNumberOfDatastoreMappings() <= 0 || !(embFieldMapping instanceof PersistableMapping) || (fk = TableUtils.getForeignKeyForPCField(embFieldMapping, embFmd, autoMode, this.storeMgr, clr)) == null) continue;
                        foreignKeys.add(fk);
                    }
                } else if (this.mmd.getMap().keyIsPersistent() && (referencedTable = this.storeMgr.getDatastoreClass(this.mmd.getMap().getKeyType(), clr)) != null) {
                    fkmd = null;
                    if (this.mmd.getKeyMetaData() != null) {
                        fkmd = this.mmd.getKeyMetaData().getForeignKeyMetaData();
                    }
                    if (fkmd != null || autoMode) {
                        fk2 = new ForeignKey(this.keyMapping, this.dba, referencedTable, true);
                        fk2.setForMetaData(fkmd);
                        foreignKeys.add(fk2);
                    }
                }
            }
        }
        catch (NoTableManagedException e) {
            // empty catch block
        }
        return foreignKeys;
    }

    protected Set getExpectedIndices(ClassLoaderResolver clr) {
        Index index;
        IndexMetaData imd;
        JavaTypeMapping embFieldMapping;
        int i;
        EmbeddedKeyPCMapping embMapping;
        Set indices = super.getExpectedIndices(clr);
        if (this.keyMapping instanceof EmbeddedKeyPCMapping) {
            embMapping = (EmbeddedKeyPCMapping)this.keyMapping;
            for (i = 0; i < embMapping.getNumberOfJavaTypeMappings(); ++i) {
                embFieldMapping = embMapping.getJavaTypeMapping(i);
                imd = embFieldMapping.getMemberMetaData().getIndexMetaData();
                if (imd == null || (index = TableUtils.getIndexForField(this, imd, embFieldMapping)) == null) continue;
                indices.add(index);
            }
        }
        if (this.valueMapping instanceof EmbeddedValuePCMapping) {
            embMapping = (EmbeddedValuePCMapping)this.valueMapping;
            for (i = 0; i < embMapping.getNumberOfJavaTypeMappings(); ++i) {
                embFieldMapping = embMapping.getJavaTypeMapping(i);
                imd = embFieldMapping.getMemberMetaData().getIndexMetaData();
                if (imd == null || (index = TableUtils.getIndexForField(this, imd, embFieldMapping)) == null) continue;
                indices.add(index);
            }
        }
        return indices;
    }

    protected List getExpectedCandidateKeys() {
        CandidateKey ck;
        UniqueMetaData umd;
        JavaTypeMapping embFieldMapping;
        int i;
        EmbeddedKeyPCMapping embMapping;
        List candidateKeys = super.getExpectedCandidateKeys();
        if (this.keyMapping instanceof EmbeddedKeyPCMapping) {
            embMapping = (EmbeddedKeyPCMapping)this.keyMapping;
            for (i = 0; i < embMapping.getNumberOfJavaTypeMappings(); ++i) {
                embFieldMapping = embMapping.getJavaTypeMapping(i);
                umd = embFieldMapping.getMemberMetaData().getUniqueMetaData();
                if (umd == null || (ck = TableUtils.getCandidateKeyForField(this, umd, embFieldMapping)) == null) continue;
                candidateKeys.add(ck);
            }
        }
        if (this.valueMapping instanceof EmbeddedValuePCMapping) {
            embMapping = (EmbeddedValuePCMapping)this.valueMapping;
            for (i = 0; i < embMapping.getNumberOfJavaTypeMappings(); ++i) {
                embFieldMapping = embMapping.getJavaTypeMapping(i);
                umd = embFieldMapping.getMemberMetaData().getUniqueMetaData();
                if (umd == null || (ck = TableUtils.getCandidateKeyForField(this, umd, embFieldMapping)) == null) continue;
                candidateKeys.add(ck);
            }
        }
        return candidateKeys;
    }

    public JavaTypeMapping getMemberMapping(AbstractMemberMetaData mmd) {
        return null;
    }
}

