/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.xml.beans.stocks.x102;

import java.io.OutputStream;
import java.util.Calendar;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlOptions;
import org.dma.java.io.CustomFile;
import org.dma.java.util.TimeDateUtils;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.model.Artigos;
import org.projectocolibri.api.database.model.Artigosunidades;
import org.projectocolibri.xml.beans.stocks.AbstractStocksExport;
import org.projectocolibri.xml.beans.stocks.IStocksExport;
import org.projectocolibri.xml.beans.stocks.StocksMap;
import stockFilePT102.ProductCategoryDocument;
import stockFilePT102.StockDocument;
import stockFilePT102.StockFileDocument;
import stockFilePT102.StockHeaderDocument;

public class Stocks102Export
extends AbstractStocksExport {
    private final StockFileDocument stockFileDocument = StockFileDocument.Factory.newInstance();
    private final StockFileDocument.StockFile stockFile = this.stockFileDocument.addNewStockFile();
    private final StockHeaderDocument.StockHeader header = this.stockFile.addNewStockHeader();

    public Stocks102Export(DatabaseManager manager, Calendar endDate) {
        super(IStocksExport.STOCKS_VERSIONS.x102, manager, endDate);
    }

    @Override
    public void process() throws Exception {
        XmlCursor cursor = this.stockFile.newCursor();
        cursor.toFirstContentToken();
        cursor.insertNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        cursor.dispose();
        this.createHeader();
        this.createStock();
    }

    public boolean save(OutputStream stream) {
        if (this.manager.getLicenca().allows(Colibri.FUNCIONALIDADES.INVENTARIO_EXISTENCIAS)) {
            try {
                XmlOptions options = new XmlOptions();
                options.setSavePrettyPrint();
                options.setUseDefaultNamespace();
                options.setCharacterEncoding(CustomFile.UTF8_CHARSET.name());
                this.stockFileDocument.save(stream, options);
                stream.close();
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean isEmpty() {
        return this.stockFile.getStockList().isEmpty();
    }

    public boolean isValid() {
        return this.stockFile.validate();
    }

    private void createHeader() {
        this.header.setFileVersion(this.version.tables.getFileVersion());
        this.header.setTaxRegistrationNumber(this.manager.getEmpresa().getNifToInteger().intValue());
        this.header.setFiscalYear(TimeDateUtils.getYear((Calendar)this.endDate));
        this.header.setEndDate(TimeDateUtils.getCalendarWithoutTimezone((Calendar)this.endDate));
        this.header.setNoStock(false);
    }

    private void createStock() {
        for (Artigos artigo : new StocksMap(this.manager, this.endDate).values()) {
            if (artigo.getStockreal().signum() <= 0) continue;
            StockDocument.Stock stock = this.stockFile.addNewStock();
            stock.setProductCategory(ProductCategoryDocument.ProductCategory.Enum.forInt((int)this.version.tables.getProductCategory(artigo).intValue()));
            stock.setProductCode(this.parseText(artigo.getCodigo(), 60));
            stock.setProductDescription(this.parseText(artigo.getDescricaoToText(), 200));
            Artigosunidades unidade = artigo.getUnidades(0);
            stock.setProductNumberCode(unidade.getCodigobarrasToText().isEmpty() ? stock.getProductCode() : this.parseText(unidade.getCodigobarrasToText(), 60));
            stock.setUnitOfMeasure(this.parseText(unidade.getUnidademedida().getDescricao(), 20));
            stock.setClosingStockQuantity(artigo.getStockreal());
        }
    }
}

