/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.xml.beans.saft.x0101;

import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.dma.java.io.CustomFile;
import org.dma.java.math.BusinessRules;
import org.dma.java.time.CalendarPeriod;
import org.dma.java.util.Debug;
import org.dma.java.util.StringUtils;
import org.dma.java.util.TimeDateUtils;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.filter.FilterMapRule;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.mapper.TableFieldKey;
import org.projectocolibri.api.database.model.Artigos;
import org.projectocolibri.api.database.model.Codigosiva;
import org.projectocolibri.api.database.model.Documentostipos;
import org.projectocolibri.api.database.model.Empresa;
import org.projectocolibri.api.database.model.Entidades;
import org.projectocolibri.api.database.model.Entidadesdocumentos;
import org.projectocolibri.api.database.model.Entidadesdocumentoslinhas;
import org.projectocolibri.api.database.query.QueryDefinition;
import org.projectocolibri.api.database.query.QueryOrdering;
import org.projectocolibri.xml.beans.saft.ATMessageFormatter;
import org.projectocolibri.xml.beans.saft.AbstractSAFTExport;
import org.projectocolibri.xml.beans.saft.ISAFTExport;
import org.projectocolibri.xml.beans.saft.x0101.SAFTx0101Tables;
import x0101.oecdStandardAuditFileTaxPT1.AddressStructure;
import x0101.oecdStandardAuditFileTaxPT1.AddressStructurePT;
import x0101.oecdStandardAuditFileTaxPT1.AuditFileDocument;
import x0101.oecdStandardAuditFileTaxPT1.CountryDocument;
import x0101.oecdStandardAuditFileTaxPT1.CurrencyDocument;
import x0101.oecdStandardAuditFileTaxPT1.CustomerDocument;
import x0101.oecdStandardAuditFileTaxPT1.HeaderDocument;
import x0101.oecdStandardAuditFileTaxPT1.OrderReferencesDocument;
import x0101.oecdStandardAuditFileTaxPT1.ProductDocument;
import x0101.oecdStandardAuditFileTaxPT1.SettlementDocument;
import x0101.oecdStandardAuditFileTaxPT1.ShippingPointStructure;
import x0101.oecdStandardAuditFileTaxPT1.SourceDocumentsDocument;
import x0101.oecdStandardAuditFileTaxPT1.TaxAccountingBasisDocument;
import x0101.oecdStandardAuditFileTaxPT1.TaxDocument;
import x0101.oecdStandardAuditFileTaxPT1.TaxTableDocument;
import x0101.oecdStandardAuditFileTaxPT1.TaxTableEntryDocument;
import x0101.oecdStandardAuditFileTaxPT1.TaxTypeDocument;

public class SAFTx0101Export
extends AbstractSAFTExport {
    private final SAFTx0101Tables tables = new SAFTx0101Tables();
    private final AuditFileDocument auditFileDocument = AuditFileDocument.Factory.newInstance();
    private final AuditFileDocument.AuditFile auditFile = this.auditFileDocument.addNewAuditFile();
    private final HeaderDocument.Header header = this.auditFile.addNewHeader();
    private final AuditFileDocument.AuditFile.MasterFiles masterFiles = this.auditFile.addNewMasterFiles();
    private final SourceDocumentsDocument.SourceDocuments sourceDocuments = this.auditFile.addNewSourceDocuments();
    private final SortedMap<String, Codigosiva> taxTableMap = new TreeMap<String, Codigosiva>();
    private final SortedSet<String> customer = new TreeSet<String>();
    private final SortedSet<String> products = new TreeSet<String>();
    private BigDecimal totalDebit = BigDecimal.ZERO;
    private BigDecimal totalCredit = BigDecimal.ZERO;

    public SAFTx0101Export(DatabaseManager manager, CalendarPeriod period) {
        super(ISAFTExport.SAFT_VERSIONS.x0101, manager, period);
    }

    @Override
    public void process(ISAFTExport.SAFT_TYPE type) throws Exception {
        XmlCursor cursor = this.auditFile.newCursor();
        cursor.toFirstContentToken();
        cursor.insertNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        cursor.dispose();
        switch (type) {
            case FACTURAS: 
            case GLOBAL: {
                this.createHeader();
                this.createSalesInvoices();
                this.createMasterFiles();
                break;
            }
            case TRANSPORTES: {
                break;
            }
        }
    }

    public boolean save(OutputStream stream) {
        if (stream != null) {
            try {
                XmlOptions options = new XmlOptions();
                options.setSavePrettyPrint();
                options.setUseDefaultNamespace();
                options.setCharacterEncoding(CustomFile.UTF8_CHARSET.name());
                this.auditFileDocument.save(stream, options);
                stream.close();
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean isEmpty() {
        return this.sourceDocuments.getSalesInvoices() == null || this.sourceDocuments.getSalesInvoices().getInvoiceList().isEmpty();
    }

    public boolean isValid() {
        return this.auditFile.validate();
    }

    private void createHeader() {
        Empresa empresa = this.manager.getEmpresa();
        this.header.setAuditFileVersion(this.parseText(this.tables.getFileVersion(), 10));
        this.header.setCompanyID(this.parseText(this.createCompanyID(empresa), 50));
        this.header.setTaxRegistrationNumber(empresa.getNifToInteger().intValue());
        this.header.setTaxAccountingBasis(TaxAccountingBasisDocument.TaxAccountingBasis.F);
        this.header.setCompanyName(this.parseText(empresa.getNomeToText(), 60));
        this.header.setCompanyAddress(this.createAdressStructurePT(this.parseText(empresa.getMoradaToText(), 50), this.parseText(empresa.getLocalidadeToText(), 50), this.parseText(empresa.getCodigopostal(), 8, ""), empresa.getPais().getCodigo()));
        this.header.setFiscalYear(TimeDateUtils.getYear((Calendar)this.period.getStartDate()));
        this.header.setStartDate(TimeDateUtils.getCalendarWithoutTimezone((Calendar)this.period.getStartDate()));
        this.header.setEndDate(TimeDateUtils.getCalendarWithoutTimezone((Calendar)this.period.getEndDate()));
        this.header.setCurrencyCode(this.parseCode(this.manager.getParametros().getMoeda().getCodigo(), 3));
        this.header.setDateCreated(TimeDateUtils.getCalendarWithoutTimezone());
        this.header.setTaxEntity(this.parseText(empresa.getEstabelecimentoToText().isEmpty() ? empresa.getNome() : empresa.getEstabelecimentoToText(), 20));
        this.header.setProductCompanyTaxID(String.valueOf(Colibri.AUTOR_LEGAL.nif));
        this.header.setSoftwareCertificateNumber(String.valueOf(38));
        this.header.setProductID(this.parseText(String.valueOf(Colibri.PROJECTO_NOME) + "/" + Colibri.AUTOR_LEGAL.nome, 255));
        this.header.setProductVersion(this.parseText(Colibri.PROJECTO_VERSAO, 30));
        if (!empresa.getTelefoneToText().isEmpty()) {
            this.header.setTelephone(this.parseText(empresa.getTelefoneToText(), 20));
        }
        if (!empresa.getFaxToText().isEmpty()) {
            this.header.setFax(this.parseText(empresa.getFaxToText(), 20));
        }
        if (!empresa.getEmailToText().isEmpty()) {
            this.header.setEmail(this.parseText(empresa.getEmailToText(), 60));
        }
        if (!empresa.getUrlToText().isEmpty()) {
            this.header.setWebsite(this.parseText(empresa.getUrlToText(), 60));
        }
    }

    private String createCompanyID(Empresa empresa) {
        String conservatoria = StringUtils.letters((String)empresa.getConservatoriaToText());
        String registo = StringUtils.numbers((String)empresa.getRegistocomercialToText());
        return conservatoria.isEmpty() || registo.isEmpty() ? empresa.getNifToNumbers() : String.valueOf(conservatoria) + " " + registo;
    }

    private AddressStructurePT createAdressStructurePT(String addressDetail, String city, String postalCode, String countryCode) {
        AddressStructurePT addressStructure = AddressStructurePT.Factory.newInstance();
        addressStructure.setAddressDetail(addressDetail.isEmpty() ? "Desconhecido" : addressDetail);
        addressStructure.setCity(city.isEmpty() ? "Desconhecido" : city);
        addressStructure.setPostalCode(postalCode.isEmpty() ? "Desconhecido" : postalCode);
        CountryDocument.Country country = CountryDocument.Country.Factory.newInstance();
        country.setStringValue(this.tables.countryCode(countryCode));
        addressStructure.setCountry((XmlObject)country);
        return addressStructure;
    }

    private AddressStructure createAdressStructure(String addressDetail, String city, String postalCode, String countryCode) {
        AddressStructure addressStructure = AddressStructure.Factory.newInstance();
        addressStructure.setAddressDetail(addressDetail.isEmpty() ? "Desconhecido" : addressDetail);
        addressStructure.setCity(city.isEmpty() ? "Desconhecido" : city);
        addressStructure.setPostalCode(postalCode.isEmpty() ? "Desconhecido" : postalCode);
        addressStructure.setCountry(this.tables.countryCode(countryCode));
        return addressStructure;
    }

    private void createMasterFiles() {
        this.createCustomers();
        this.createProducts();
        if (!this.taxTableMap.isEmpty()) {
            this.createTaxTable();
        }
    }

    private void createCustomers() {
        for (String key : this.customer) {
            Entidades entidade = this.manager.loadEntidades(key);
            this.createCustomers(entidade);
        }
    }

    private void createCustomers(Entidades entidade) {
        Debug.out((Object)entidade);
        CustomerDocument.Customer customer = this.masterFiles.addNewCustomer();
        customer.setCustomerID(this.parseText(entidade.getKey(), 30));
        customer.setAccountID(this.parseText("Desconhecido", 30));
        customer.setCustomerTaxID(this.parseText(entidade.getNifParsed(), 20));
        customer.setCompanyName(this.parseText(entidade.getNomeToText(), 60));
        if (!entidade.getResponsavelToText().isEmpty()) {
            customer.setContact(this.parseText(entidade.getResponsavelToText(), 50));
        }
        customer.setBillingAddress(this.createAdressStructure(this.parseText(entidade.getMoradaToText(), 50), this.parseText(entidade.getLocalidadeToText(), 50), this.parseText(entidade.getCodigopostal(), 20), entidade.getPais().getCodigo()));
        if (!entidade.getTelefoneToText().isEmpty()) {
            customer.setTelephone(this.parseText(entidade.getTelefoneToText(), 20));
        }
        if (!entidade.getFaxToText().isEmpty()) {
            customer.setFax(this.parseText(entidade.getFaxToText(), 20));
        }
        if (!entidade.getEmailToText().isEmpty()) {
            customer.setEmail(this.parseText(entidade.getEmailToText(), 60));
        }
        if (!entidade.getUrlToText().isEmpty()) {
            customer.setWebsite(this.parseText(entidade.getUrlToText(), 60));
        }
        customer.setSelfBillingIndicator(0);
    }

    private void createProducts() {
        for (String codigo : this.products) {
            Artigos artigo = this.manager.loadArtigos(codigo, false);
            this.createProducts(artigo == null ? new Artigos(this.manager, "GENERICO", "Artigo Generico") : artigo);
        }
    }

    private void createProducts(Artigos artigo) {
        Debug.out((Object)artigo);
        ProductDocument.Product product = this.masterFiles.addNewProduct();
        product.setProductType(this.tables.getProductType(artigo));
        product.setProductCode(this.parseCode(artigo.getCodigo(), 30));
        if (!artigo.getFamilia().getDescricaoToText().isEmpty()) {
            product.setProductGroup(this.parseText(artigo.getFamilia().getDescricaoToText(), 50));
        }
        product.setProductDescription(artigo.getDescricaoToText().isEmpty() ? "Desconhecido" : this.parseText(artigo.getDescricaoToText(), 60));
        product.setProductNumberCode(artigo.getUnidades().isEmpty() || artigo.getUnidades(0).getCodigobarrasToText().isEmpty() ? this.parseCode(artigo.getCodigo(), 50) : this.parseText(artigo.getUnidades(0).getCodigobarrasToText(), 50));
    }

    private void createTaxTable() {
        TaxTableDocument.TaxTable taxTable = this.masterFiles.addNewTaxTable();
        for (Codigosiva codigoiva : this.taxTableMap.values()) {
            this.createTaxTableEntry(taxTable, codigoiva);
        }
    }

    private void createTaxTableEntry(TaxTableDocument.TaxTable taxTable, Codigosiva codigoiva) {
        Debug.out((Object)codigoiva);
        TaxTableEntryDocument.TaxTableEntry taxTableEntry = taxTable.addNewTaxTableEntry();
        taxTableEntry.setTaxType(TaxTypeDocument.TaxType.IVA);
        taxTableEntry.setTaxCountryRegion(this.parseText(this.tables.getTaxCountryRegion(codigoiva, null), 5));
        taxTableEntry.setTaxCode(this.tables.getTaxCode(codigoiva));
        taxTableEntry.setDescription(this.parseText(codigoiva.getDescricaoToText(), 255));
        taxTableEntry.setTaxPercentage(codigoiva.getTaxa());
    }

    private void createSalesInvoices() {
        SourceDocumentsDocument.SourceDocuments.SalesInvoices salesInvoices = this.sourceDocuments.addNewSalesInvoices();
        for (Documentostipos tipodocumento : this.manager.getDocumentostiposCollection()) {
            if (tipodocumento.getSAFTDocumentGroup() != Documentostipos.SAFT_DOCUMENT_GROUP.INVOICE) continue;
            this.createSalesInvoices(salesInvoices, tipodocumento);
        }
        salesInvoices.setNumberOfEntries(BigInteger.valueOf(salesInvoices.sizeOfInvoiceArray()));
        salesInvoices.setTotalDebit(ATMessageFormatter.getGrossTotal(this.totalDebit));
        salesInvoices.setTotalCredit(ATMessageFormatter.getGrossTotal(this.totalCredit));
    }

    private void createSalesInvoices(SourceDocumentsDocument.SourceDocuments.SalesInvoices salesInvoices, Documentostipos tipodocumento) {
        Debug.out((Object)tipodocumento);
        for (Entidadesdocumentos element : this.getEntidadesdocumentosCollection(tipodocumento)) {
            Entidadesdocumentos documento = this.manager.loadEntidadesdocumentos(element.getKey());
            this.createSalesInvoices(salesInvoices, documento);
            this.customer.add(documento.getEntidade().getKey());
        }
    }

    private void createSalesInvoices(SourceDocumentsDocument.SourceDocuments.SalesInvoices salesInvoices, Entidadesdocumentos documento) {
        Debug.out((Object)documento);
        SourceDocumentsDocument.SourceDocuments.SalesInvoices.Invoice invoice = salesInvoices.addNewInvoice();
        invoice.setInvoiceDate(TimeDateUtils.getCalendarWithoutTimezone((Date)documento.getDatacriacao()));
        invoice.setSystemEntryDate(TimeDateUtils.getCalendarWithoutTimezone((Date)documento.getDatasistemaWithTime()));
        invoice.setInvoiceNo(this.parseText(documento.toString(), 60));
        invoice.setHash(documento.getHashToText());
        if (documento.isAssinado()) {
            invoice.setHashControl(documento.getHashcontrolToText());
        }
        invoice.setSelfBillingIndicator(0);
        invoice.setInvoiceType(this.tables.getInvoiceType(documento.getTipodocumento()));
        invoice.setPeriod(TimeDateUtils.getMonth((Date)documento.getDatacriacao()) + 1);
        invoice.setCustomerID(this.parseText(documento.getEntidade().getKey(), 30));
        invoice.setInvoiceStatus(this.tables.getInvoiceStatus(documento));
        invoice.setShipTo(this.createShipToStructure(documento));
        invoice.setShipFrom(this.createShipFromStructure(documento));
        this.createSalesInvoicesLines(invoice, documento);
        invoice.setDocumentTotals(this.createDocumentTotals(documento));
    }

    private ShippingPointStructure createShipToStructure(Entidadesdocumentos documento) {
        ShippingPointStructure shippingPoint = ShippingPointStructure.Factory.newInstance();
        shippingPoint.setDeliveryDate(TimeDateUtils.getCalendarWithoutTimezone((Date)documento.getDatadescarga()));
        shippingPoint.setAddress(this.createAdressStructure(this.parseText(documento.getLocaldescargaToText(), 60), this.parseText(documento.getLocalidadedescargaToText(), 50), this.parseText(documento.getCodigopostaldescarga(), 20), documento.getPaisdescarga().getCodigo()));
        return shippingPoint;
    }

    private ShippingPointStructure createShipFromStructure(Entidadesdocumentos documento) {
        ShippingPointStructure shippingPoint = ShippingPointStructure.Factory.newInstance();
        shippingPoint.setDeliveryDate(TimeDateUtils.getCalendarWithoutTimezone((Date)documento.getDatacarga()));
        shippingPoint.setAddress(this.createAdressStructure(this.parseText(documento.getLocalcargaToText(), 60), this.parseText(documento.getLocalidadecargaToText(), 50), this.parseText(documento.getCodigopostalcarga(), 20), documento.getPaiscarga().getCodigo()));
        return shippingPoint;
    }

    private void createSalesInvoicesLines(SourceDocumentsDocument.SourceDocuments.SalesInvoices.Invoice invoice, Entidadesdocumentos documento) {
        for (Entidadesdocumentoslinhas linha : documento.getLinhasdocumento$Tipo(1)) {
            this.createSalesInvoicesLine(invoice, linha);
        }
    }

    private void createSalesInvoicesLine(SourceDocumentsDocument.SourceDocuments.SalesInvoices.Invoice invoice, Entidadesdocumentoslinhas linha) {
        SourceDocumentsDocument.SourceDocuments.SalesInvoices.Invoice.Line line = invoice.addNewLine();
        line.setLineNumber(BigInteger.valueOf(linha.getNumerolinha().intValue()));
        Artigos artigo = linha.hasArtigo() ? linha.getArtigo() : new Artigos(this.manager, "GENERICO", "Artigo Generico");
        line.setProductCode(this.parseCode(artigo.getCodigo(), 30));
        line.setProductDescription(linha.getDescricaoToText().isEmpty() ? "Desconhecido" : this.parseText(linha.getDescricaoToText(), 60));
        this.products.add(artigo.getCodigo());
        line.setDescription(linha.getDescricaoToText().isEmpty() ? "Desconhecido" : this.parseText(linha.getDescricaoToText(), 60));
        line.setQuantity(linha.getQuantidade());
        line.setUnitOfMeasure(this.parseText(linha.getUnidademedida().getDescricaoToText(), 20));
        BigDecimal valorliquido = BusinessRules.netValue((BigDecimal)linha.getValorliquido(), (BigDecimal)linha.getDocumento().getPercdesconto());
        line.setUnitPrice(valorliquido.divide(linha.getQuantidade(), FIELDS.entidadesdocumentoslinhas_preco.format.getSize().scale, RoundingMode.HALF_EVEN).abs());
        if (linha.getLinhaorigem() != null) {
            line.setOrderReferencesArray(this.createOrderReferencesArray(linha.getLinhaorigem()));
        }
        line.setTaxPointDate(line.getOrderReferencesList().isEmpty() ? TimeDateUtils.getCalendarWithoutTimezone((Date)linha.getDocumento().getDatacriacao()) : ((OrderReferencesDocument.OrderReferences)line.getOrderReferencesList().get(0)).getOrderDate());
        switch (linha.getDocumento().getTipodocumento().getSAFTMovementClass()) {
            case NONE: {
                break;
            }
            case DEBIT: {
                line.setDebitAmount(FIELDS.entidadesdocumentoslinhas_valorliquido.format.setScale(valorliquido, RoundingMode.HALF_EVEN));
                break;
            }
            case CREDIT: {
                line.setCreditAmount(FIELDS.entidadesdocumentoslinhas_valorliquido.format.setScale(valorliquido, RoundingMode.HALF_EVEN));
            }
        }
        line.setSettlementAmount(FIELDS.entidadesdocumentoslinhas_valordesconto.format.setScale(linha.getValordesconto(), RoundingMode.HALF_EVEN));
        line.setTax(this.createTax(linha.getCodigoiva()));
        if (!linha.getCodigoiva().hasTaxa()) {
            line.setTaxExemptionReason(linha.getIsencaoiva().getArtigolegalToText().isEmpty() ? this.parseText(linha.getIsencaoiva().getDescricaoToText(), 60) : this.parseText(linha.getIsencaoiva().getArtigolegalToText(), 60));
        }
        this.taxTableMap.put(linha.getCodigoiva().getCodigo(), linha.getCodigoiva());
    }

    private OrderReferencesDocument.OrderReferences[] createOrderReferencesArray(Entidadesdocumentoslinhas linha) {
        OrderReferencesDocument.OrderReferences orderReferences = OrderReferencesDocument.OrderReferences.Factory.newInstance();
        orderReferences.setOrderDate(TimeDateUtils.getCalendarWithoutTimezone((Date)linha.getDatadocumento()));
        Entidadesdocumentos documento = this.manager.loadEntidadesdocumentos(linha.getDocumento().getKey());
        orderReferences.setOriginatingON(this.parseText(documento.toString(), 30));
        return new OrderReferencesDocument.OrderReferences[]{orderReferences};
    }

    private TaxDocument.Tax createTax(Codigosiva codigoiva) {
        TaxDocument.Tax tax = TaxDocument.Tax.Factory.newInstance();
        tax.setTaxType(TaxTypeDocument.TaxType.IVA);
        tax.setTaxCountryRegion(this.parseText(this.tables.getTaxCountryRegion(codigoiva, null), 5));
        tax.setTaxCode(this.tables.getTaxCode(codigoiva));
        tax.setTaxPercentage(codigoiva.getTaxa());
        return tax;
    }

    private SourceDocumentsDocument.SourceDocuments.SalesInvoices.Invoice.DocumentTotals createDocumentTotals(Entidadesdocumentos documento) {
        SourceDocumentsDocument.SourceDocuments.SalesInvoices.Invoice.DocumentTotals documentTotals = SourceDocumentsDocument.SourceDocuments.SalesInvoices.Invoice.DocumentTotals.Factory.newInstance();
        documentTotals.setTaxPayable(ATMessageFormatter.getGrossTotal(documento.getTotaliva()));
        documentTotals.setNetTotal(ATMessageFormatter.getGrossTotal(documento.getTotalliquido()));
        documentTotals.setGrossTotal(ATMessageFormatter.getGrossTotal(documento.getTotalbruto()));
        documentTotals.setSettlement(this.createSettlement(documento));
        if (!documento.isEstado(1)) {
            switch (documento.getTipodocumento().getSAFTMovementClass()) {
                case NONE: {
                    break;
                }
                case DEBIT: {
                    this.totalDebit = this.totalDebit.add(documentTotals.getNetTotal());
                    break;
                }
                case CREDIT: {
                    this.totalCredit = this.totalCredit.add(documentTotals.getNetTotal());
                }
            }
        }
        return documentTotals;
    }

    private CurrencyDocument.Currency createCurrency(Entidadesdocumentos documento) {
        CurrencyDocument.Currency currency = CurrencyDocument.Currency.Factory.newInstance();
        currency.setCurrencyCode(this.parseCode(this.manager.getParametros().getMoeda().getCodigo(), 3));
        switch (documento.getTipodocumento().getSAFTMovementClass()) {
            case NONE: {
                break;
            }
            case DEBIT: {
                currency.setCurrencyDebitAmount(ATMessageFormatter.getGrossTotal(documento.getTotalbruto()));
                break;
            }
            case CREDIT: {
                currency.setCurrencyCreditAmount(ATMessageFormatter.getGrossTotal(documento.getTotalbruto()));
            }
        }
        return currency;
    }

    private SettlementDocument.Settlement createSettlement(Entidadesdocumentos documento) {
        SettlementDocument.Settlement settlement = SettlementDocument.Settlement.Factory.newInstance();
        settlement.setSettlementDate(TimeDateUtils.getCalendarWithoutTimezone((Date)documento.getDatavencimento()));
        settlement.setPaymentMechanism(this.tables.getPaymentMechanism(documento.getMetodopagamento()));
        return settlement;
    }

    private Collection<Entidadesdocumentos> getEntidadesdocumentosCollection(Documentostipos tipodocumento) {
        QueryDefinition query = new QueryDefinition(TABLES.entidadesdocumentos, new QueryOrdering(QueryOrdering.DIRECTION.ASCENDING, new TableFieldKey(FIELDS.entidadesdocumentos_seriedocumento, FIELDS.documentosseries_numero), new TableFieldKey(FIELDS.entidadesdocumentos_numerodocumento)));
        query.addRule(new FilterMapRule(FIELDS.entidadesdocumentos_tipodocumento, FIELDS.documentostipos_codigo).equal(tipodocumento.getCodigo()));
        query.addRule(new FilterMapRule(FIELDS.entidadesdocumentos_datacriacao).biggerEqual(this.period.getStartDate()).and().smallerEqual(this.period.getEndDate()));
        return this.manager.getEntidadesdocumentosCollection(query);
    }
}

