/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.xml.beans.saft.qrcode;

import io.nayuki.qrcodegen.QrCode;
import java.awt.image.BufferedImage;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.TreeMap;
import org.apache.commons.codec.binary.Base64;
import org.apache.xmlbeans.StringEnumAbstractBase;
import org.dma.java.util.MessageLine;
import org.dma.java.util.MessageList;
import org.dma.java.util.StringList;
import org.dma.java.util.TimeDateUtils;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.database.model.Entidadesdocumentos;
import org.projectocolibri.api.database.model.Entidadesdocumentosivas;
import org.projectocolibri.core.support.QRCodeEncoder;
import org.projectocolibri.xml.beans.saft.ISAFTExport;
import org.projectocolibri.xml.beans.saft.qrcode.ATQRCodeField;
import x0401.oecdStandardAuditFileTaxPT1.InvoiceStatusDocument;
import x0401.oecdStandardAuditFileTaxPT1.InvoiceTypeDocument;

public class ATQRCodeFieldList
extends ArrayList<ATQRCodeField> {
    private static final long serialVersionUID = 1L;
    private final Entidadesdocumentos documento;

    public ATQRCodeFieldList(Entidadesdocumentos documento) {
        this.documento = documento;
        this.add(new ATQRCodeField(ATQRCodeField.CODES.A, documento.getManager().getEmpresa().getNifToNumbers()));
        this.add(new ATQRCodeField(ATQRCodeField.CODES.B, documento.getNifParsed()));
        this.add(new ATQRCodeField(ATQRCodeField.CODES.C, documento.getPais().getCodigo()));
        this.add(new ATQRCodeField(ATQRCodeField.CODES.D, this.getSAFTDocumentClass().toString()));
        this.add(new ATQRCodeField(ATQRCodeField.CODES.E, this.getSAFTDocumentStatus().toString()));
        this.add(new ATQRCodeField(ATQRCodeField.CODES.F, TimeDateUtils.getDateFormatted((Date)documento.getDatacriacao(), (String)(String.valueOf(TimeDateUtils.DATE_YEAR_PATTERN) + TimeDateUtils.DATE_MONTH_PATTERN + TimeDateUtils.DATE_DAY_PATTERN))));
        this.add(new ATQRCodeField(ATQRCodeField.CODES.G, documento.toString()));
        this.add(new ATQRCodeField(ATQRCodeField.CODES.H, documento.getATCUD()));
        TaxCountryRegionMap taxCountryRegionMap = new TaxCountryRegionMap(documento);
        if (taxCountryRegionMap.isEmpty()) {
            this.add(new ATQRCodeField(ATQRCodeField.CODES.I1, "0"));
        } else {
            char codigo = 'I';
            while (codigo <= 'K' && !taxCountryRegionMap.isEmpty()) {
                String taxCountryRegion = (String)taxCountryRegionMap.firstKey();
                this.add(new ATQRCodeField(ATQRCodeField.CODES.get(String.valueOf(codigo) + "1"), taxCountryRegion));
                TaxCodeMap taxCodeMap = (TaxCodeMap)taxCountryRegionMap.remove(taxCountryRegion);
                Entidadesdocumentosivas iva = (Entidadesdocumentosivas)taxCodeMap.get(3);
                if (iva != null) {
                    this.add(new ATQRCodeField(ATQRCodeField.CODES.get(String.valueOf(codigo) + "2"), iva.getValorbase()));
                }
                if ((iva = (Entidadesdocumentosivas)taxCodeMap.get(1)) != null) {
                    this.add(new ATQRCodeField(ATQRCodeField.CODES.get(String.valueOf(codigo) + "3"), iva.getValorbase()));
                    this.add(new ATQRCodeField(ATQRCodeField.CODES.get(String.valueOf(codigo) + "4"), iva.getTotal()));
                }
                if ((iva = (Entidadesdocumentosivas)taxCodeMap.get(2)) != null) {
                    this.add(new ATQRCodeField(ATQRCodeField.CODES.get(String.valueOf(codigo) + "5"), iva.getValorbase()));
                    this.add(new ATQRCodeField(ATQRCodeField.CODES.get(String.valueOf(codigo) + "6"), iva.getValorbase()));
                }
                if ((iva = (Entidadesdocumentosivas)taxCodeMap.get(0)) != null) {
                    this.add(new ATQRCodeField(ATQRCodeField.CODES.get(String.valueOf(codigo) + "7"), iva.getValorbase()));
                    this.add(new ATQRCodeField(ATQRCodeField.CODES.get(String.valueOf(codigo) + "8"), iva.getTotal()));
                }
                codigo = (char)(codigo + '\u0001');
            }
        }
        if (taxCountryRegionMap.L.signum() != 0) {
            this.add(new ATQRCodeField(ATQRCodeField.CODES.L, taxCountryRegionMap.L));
        }
        this.add(new ATQRCodeField(ATQRCodeField.CODES.N, documento.getTotaliva()));
        this.add(new ATQRCodeField(ATQRCodeField.CODES.O, documento.getTotalbruto()));
        if (documento.getTotalretencoes().signum() != 0) {
            this.add(new ATQRCodeField(ATQRCodeField.CODES.P, documento.getTotalretencoes()));
        }
        this.add(new ATQRCodeField(ATQRCodeField.CODES.Q, documento.getHashCheckdigits()));
        this.add(new ATQRCodeField(ATQRCodeField.CODES.R, String.valueOf(38)));
        this.add(new ATQRCodeField(ATQRCodeField.CODES.S, Colibri.WEBPAGES.PRODUTO.name));
    }

    private StringEnumAbstractBase getSAFTDocumentClass() {
        switch (this.documento.getTipodocumento().getSAFTDocumentGroup()) {
            case UNKNOWN: {
                return InvoiceTypeDocument.InvoiceType.FT;
            }
            case INVOICE: {
                return ISAFTExport.SAFT_VERSIONS.DEFAULT.tables.getInvoiceType(this.documento.getTipodocumento());
            }
            case MOVEMENT: {
                return ISAFTExport.SAFT_VERSIONS.DEFAULT.tables.getMovementType(this.documento.getTipodocumento());
            }
            case WORKING: {
                return ISAFTExport.SAFT_VERSIONS.DEFAULT.tables.getWorkType(this.documento.getTipodocumento());
            }
            case PAYMENT: {
                return ISAFTExport.SAFT_VERSIONS.DEFAULT.tables.getPaymentType(this.documento.getTipodocumento());
            }
        }
        return null;
    }

    private StringEnumAbstractBase getSAFTDocumentStatus() {
        switch (this.documento.getTipodocumento().getSAFTDocumentGroup()) {
            case UNKNOWN: {
                return InvoiceStatusDocument.InvoiceStatus.N;
            }
            case INVOICE: {
                return ISAFTExport.SAFT_VERSIONS.DEFAULT.tables.getInvoiceStatus(this.documento);
            }
            case MOVEMENT: {
                return ISAFTExport.SAFT_VERSIONS.DEFAULT.tables.getMovementStatus(this.documento);
            }
            case WORKING: {
                return ISAFTExport.SAFT_VERSIONS.DEFAULT.tables.getWorkStatus(this.documento);
            }
            case PAYMENT: {
                return ISAFTExport.SAFT_VERSIONS.DEFAULT.tables.getPaymentStatus(this.documento);
            }
        }
        return null;
    }

    public ATQRCodeField get(ATQRCodeField.CODES code) {
        for (ATQRCodeField field : this) {
            if (field.code != code) continue;
            return field;
        }
        return null;
    }

    public MessageList validate() {
        MessageList error = new MessageList();
        for (ATQRCodeField field : this) {
            if (field.isValid()) continue;
            error.add((Object)new MessageLine((Object)"Invalid FIELD").brackets((Object)field));
        }
        ATQRCodeField.CODES[] cODESArray = ATQRCodeField.CODES.values();
        int n = cODESArray.length;
        int n2 = 0;
        while (n2 < n) {
            ATQRCodeField.CODES code = cODESArray[n2];
            ATQRCodeField field = this.get(code);
            if (field == null && code.mandatory) {
                error.add((Object)new MessageLine((Object)"Missing FIELD").brackets((Object)code));
            }
            ++n2;
        }
        return error;
    }

    public BufferedImage toImage() {
        return QRCodeEncoder.encodeBinary(this.toString(), 9, QrCode.Ecc.MEDIUM).toImage(2, 2);
    }

    public String toBase64String() {
        try {
            return new Base64().encodeToString(this.toString().getBytes("UTF8"));
        }
        catch (Exception exception) {
            return this.toString();
        }
    }

    @Override
    public String toString() {
        return StringList.valueOf((Collection)this).concat("*");
    }

    private class TaxCodeMap
    extends HashMap<Integer, Entidadesdocumentosivas> {
        private static final long serialVersionUID = 1L;

        private TaxCodeMap() {
        }

        public void add(Entidadesdocumentosivas iva) {
            Integer key = iva.getCodigoiva().getTipotaxa();
            Entidadesdocumentosivas value = (Entidadesdocumentosivas)this.get(key);
            if (value == null) {
                this.put(key, iva.cloneCopy());
            } else {
                value.setValorbase(value.getValorbase().add(iva.getValorbase()));
                value.setTotal(value.getTotal().add(iva.getTotal()));
            }
        }
    }

    private class TaxCountryRegionMap
    extends TreeMap<String, TaxCodeMap> {
        private static final long serialVersionUID = 1L;
        public BigDecimal L = BigDecimal.ZERO;

        public TaxCountryRegionMap(Entidadesdocumentos documento) {
            for (Entidadesdocumentosivas iva : documento.getTabelaiva()) {
                String key = ISAFTExport.SAFT_VERSIONS.DEFAULT.tables.getTaxCountryRegion(iva.getCodigoiva(), iva.getDocumento().getPais());
                if (!this.containsKey(key)) {
                    this.put(key, new TaxCodeMap());
                }
                switch (iva.getCodigoiva().getTipotaxa()) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        ((TaxCodeMap)this.get(key)).add(iva);
                        break;
                    }
                    case 4: 
                    case 5: {
                        this.L = this.L.add(iva.getTotal());
                    }
                }
            }
        }
    }
}

