/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.xml.beans.saft.qrcode;

import java.math.BigDecimal;
import org.projectocolibri.xml.beans.saft.ATMessageFormatter;

public class ATQRCodeField {
    public final CODES code;
    public final String value;

    public ATQRCodeField(CODES code, BigDecimal value) {
        this(code, ATMessageFormatter.getGrossTotal(value).toPlainString());
    }

    public ATQRCodeField(CODES code, String value) {
        this.code = code;
        this.value = value;
    }

    public boolean isValid() {
        return this.value.length() <= this.code.length;
    }

    public String toString() {
        return (Object)((Object)this.code) + ":" + this.value;
    }

    public int hashCode() {
        return this.code.hashCode();
    }

    public boolean equals(Object obj) {
        return this.hashCode() == obj.hashCode();
    }

    public static enum CODES {
        INVALID(-1),
        A(9, true),
        B(30, true),
        C(12, true),
        D(2, true),
        E(1, true),
        F(8, true),
        G(60, true),
        H(70, true),
        I1(5, true),
        I2(16),
        I3(16),
        I4(16),
        I5(16),
        I6(16),
        I7(16),
        I8(16),
        J1(5),
        J2(16),
        J3(16),
        J4(16),
        J5(16),
        J6(16),
        J7(16),
        J8(16),
        K1(5),
        K2(16),
        K3(16),
        K4(16),
        K5(16),
        K6(16),
        K7(16),
        K8(16),
        L(16),
        M(16),
        N(16, true),
        O(16, true),
        P(16),
        Q(4, true),
        R(4, true),
        S(65, false);

        public final int length;
        public final boolean mandatory;

        private CODES(int max) {
            this(max, false);
        }

        private CODES(int length, boolean mandatory) {
            this.length = length;
            this.mandatory = mandatory;
        }

        public static CODES get(String name) {
            try {
                return CODES.valueOf(name);
            }
            catch (Exception exception) {
                return INVALID;
            }
        }
    }
}

