/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.xml.beans.saft;

import java.io.File;
import java.util.Calendar;
import java.util.Date;
import org.dma.java.input.FieldSize;
import org.dma.java.io.FileParameters;
import org.dma.java.time.CalendarPeriod;
import org.dma.java.util.MessageLine;
import org.dma.java.util.MessageList;
import org.dma.java.util.StringList;
import org.dma.java.util.TimeDateUtils;
import org.projectocolibri.xml.IXMLExport;
import org.projectocolibri.xml.beans.saft.ISAFTTables;
import org.projectocolibri.xml.beans.saft.x0101.SAFTx0101Tables;
import org.projectocolibri.xml.beans.saft.x0201.SAFTx0201Tables;
import org.projectocolibri.xml.beans.saft.x0301.SAFTx0301Tables;
import org.projectocolibri.xml.beans.saft.x0401.SAFTx0401Tables;

public interface ISAFTExport
extends IXMLExport {
    public static final String HASH_VAZIA = "0";
    public static final String ATCUD_VAZIO = "0";
    public static final String DESCONHECIDO = "Desconhecido";
    public static final String ARTIGO_GENERICO_CODIGO = "GENERICO";
    public static final String ARTIGO_GENERICO_DESCRICAO = "Artigo Generico";
    public static final int DIA_ENTREGA = 5;

    public FileParameters getFileParameters(File var1);

    public MessageList export(SAFT_TYPE var1, File var2);

    public void process(SAFT_TYPE var1) throws Exception;

    public static enum SAFT_FIELDS {
        CompanyName(new FieldSize(100)),
        AddressDetail(new FieldSize(210)),
        Region(new FieldSize(50)),
        TaxID(new FieldSize(30)),
        Email(new FieldSize(60)),
        Website(new FieldSize(60)),
        Telephone(new FieldSize(40)),
        ProductCode(new FieldSize(60)),
        ProductDescription(new FieldSize(200)),
        CustomerID(new FieldSize(30));

        public final FieldSize size;

        private SAFT_FIELDS(FieldSize size) {
            this.size = size;
        }
    }

    public static enum SAFT_TYPE {
        FACTURAS,
        TRANSPORTES,
        CONFERENCIA,
        GLOBAL;

        public static final String[] NAMES;

        static {
            NAMES = StringList.valueOf((Object[])SAFT_TYPE.values()).toArray();
        }

        public static SAFT_TYPE get(String name) {
            try {
                return SAFT_TYPE.valueOf(name);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    public static enum SAFT_VERSIONS {
        x0101(new SAFTx0101Tables()),
        x0201(new SAFTx0201Tables()),
        x0301(new SAFTx0301Tables()),
        x0401(new SAFTx0401Tables());

        public static final SAFT_VERSIONS DEFAULT;
        public static final String[] ITEMS;
        public final ISAFTTables tables;

        static {
            DEFAULT = SAFT_VERSIONS.getDefault();
            ITEMS = new String[SAFT_VERSIONS.values().length];
            int index = 0;
            SAFT_VERSIONS[] sAFT_VERSIONSArray = SAFT_VERSIONS.values();
            int n = sAFT_VERSIONSArray.length;
            int n2 = 0;
            while (n2 < n) {
                SAFT_VERSIONS value = sAFT_VERSIONSArray[n2];
                Calendar expiration = value.tables.getExpiration();
                SAFT_VERSIONS.ITEMS[index++] = expiration == null ? value.name() : new MessageLine((Object)value).brackets((Object)TimeDateUtils.getDateFormatted((Date)expiration.getTime())).toString();
                ++n2;
            }
        }

        private static SAFT_VERSIONS getDefault() {
            return SAFT_VERSIONS.values()[SAFT_VERSIONS.values().length - 1];
        }

        private SAFT_VERSIONS(ISAFTTables tables) {
            this.tables = tables;
        }

        public boolean isExpired(Calendar calendar) {
            Calendar expiration = this.tables.getExpiration();
            return expiration != null && TimeDateUtils.getCalendarWithoutTime((Calendar)calendar).after(expiration);
        }

        public boolean isExpired() {
            return this.isExpired(TimeDateUtils.getCalendar());
        }

        public FileParameters getFileParameters(File folder, int nif, CalendarPeriod period) {
            return new FileParameters(new StringList(new String[]{String.valueOf(nif), "SAFT", this.name(), TimeDateUtils.getDateFormatted((Calendar)period.getStartDate(), (String)"yyyy-MM-dd")}).concat("_"), "xml", folder);
        }

        public static Date getDatalimite(Date datacriacao) {
            return TimeDateUtils.getDateWithDay((Date)TimeDateUtils.addMonths((Date)datacriacao, (int)1), (int)5);
        }
    }
}

