/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.xml.beans.licencas;

import java.io.File;
import java.math.BigDecimal;
import java.nio.file.CopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.dma.java.io.CustomFile;
import org.dma.java.util.Debug;
import org.dma.java.util.StringList;
import org.dma.java.util.TimeDateUtils;
import org.dma.services.vies.CheckVatHandler;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.language.LABELS;
import org.projectocolibri.api.services.licencas.controlo.ControloLicencaExec;
import org.projectocolibri.api.services.licencas.controlo.ControloLicencaResponseType;
import org.projectocolibri.api.services.licencas.controlo.ControloLicencaType;
import org.projectocolibri.api.services.licencas.controlo.LicencasAssociadosType;
import org.projectocolibri.api.services.licencas.renovacao.DownloadLicencaExec;
import org.projectocolibri.api.services.licencas.renovacao.RenovacaoLicencaExec;
import org.projectocolibri.api.services.licencas.renovacao.RenovacaoLicencaResponseType;
import org.projectocolibri.api.services.licencas.renovacao.RenovacaoLicencaType;
import org.projectocolibri.core.support.locks.PersistentLock;
import org.projectocolibri.core.support.locks.RuntimeLock;
import org.projectocolibri.xml.beans.XmlDatabase;
import org.projectocolibri.xml.beans.licencas.ILicencaListener;
import org.projectocolibri.xml.beans.licencas.LICENCAS;
import org.projectocolibri.xml.beans.licencas.LicencaContainer;
import org.projectocolibri.xml.beans.licencas.LicencasXmlDatabase;
import org.projectocolibri.xml.beans.licencas.LimiteFacturacao;
import org.projectocolibri.xml.licencas.LicencaDocument;

public final class ColibriLicenca
extends LicencaContainer {
    public static final LICENCAS DEVELOPER_LICENSE = LICENCAS.PRO;
    public static final String AUTOR_LEGAL = String.valueOf(Colibri.AUTOR_LEGAL.nif);
    private static XmlDatabase<LicencaDocument.Licenca> database;
    private final Collection<ILicencaListener> listeners = new ArrayList<ILicencaListener>();
    private final List<PersistentLock> persistentLock = new ArrayList<PersistentLock>();
    private final RuntimeLock expirationLock = new RuntimeLock();
    private final RuntimeLock genericLock = new RuntimeLock();
    private Date data_renovacao = super.getDataRenovacao();
    private final RenovacaoLicencaType renovacao = new RenovacaoLicencaType(this.getPaisTitular(), this.getNifTitular(), this.getTipo(), this.getPeriodicidade());
    private final String password;

    @Deprecated
    public static XmlDatabase<LicencaDocument.Licenca> getDatabase() {
        if (database == null) {
            database = new LicencasXmlDatabase((File)Colibri.FILES.DATABASES.LICENCAS.parameters.toFile());
        }
        return database;
    }

    private static LicencaDocument.Licenca create(File file) {
        try {
            return ColibriLicenca.parse((File)file);
        }
        catch (Exception e) {
            System.err.println(e);
            return ColibriLicenca.create(LICENCAS.DEMO);
        }
    }

    private static LicencaDocument.Licenca create(LICENCAS tipo) {
        LicencaDocument.Licenca.Titular titular = LicencaDocument.Licenca.Titular.Factory.newInstance();
        try {
            titular.setNif(Arrays.asList("999999990"));
            titular.setNome(Colibri.PROJECTO_NOME);
            titular.setMorada(LABELS.DESCONHECIDO.toString());
            titular.setCodigopostal("0000-000");
            titular.setLocalidade(LABELS.DESCONHECIDO.toString());
            titular.setPais(Colibri.MARKET_TYPE.country.code);
            titular.setTelefone(LABELS.DESCONHECIDO.toString());
            titular.setWebsite(Colibri.WEBPAGES.PRODUTO.name);
            titular.setEmail(Colibri.AUTOR_LEGAL.email);
        }
        catch (Exception e) {
            System.err.println(e);
        }
        return ColibriLicenca.create(tipo, titular);
    }

    private static LicencaDocument.Licenca create(LICENCAS tipo, LicencaDocument.Licenca.Titular titular) {
        LicencaDocument.Licenca licenca = LicencaDocument.Licenca.Factory.newInstance();
        try {
            licenca.setId(0);
            licenca.setData(TimeDateUtils.getCalendarWithoutTimezone());
            licenca.setPeriodicidade(tipo.periodicidade.meses);
            licenca.setTipo(tipo.name());
            licenca.setModulos(tipo == LICENCAS.DEMO || tipo == LICENCAS.PRO ? Arrays.asList(LICENCAS.MODULOS.NAMES) : Arrays.asList(new Object[0]));
            licenca.setParceiro(AUTOR_LEGAL);
            licenca.setTitular(titular);
            return licenca;
        }
        catch (Exception e) {
            System.err.println(e);
            return null;
        }
    }

    public static ColibriLicenca load() {
        switch (Colibri.VERSION_TYPE) {
            case INTERNAL: {
                break;
            }
            case SERVER: {
                return new ColibriLicenca(LICENCAS.DEMO);
            }
            case PLUGIN: 
            case DESKTOP: {
                return ColibriLicenca.load((File)Colibri.FILES.LICENCA.parameters.toFile());
            }
        }
        return new ColibriLicenca(DEVELOPER_LICENSE);
    }

    public static ColibriLicenca load(File file) {
        return ColibriLicenca.load(file, Colibri.ACCESS_PASSWORD.toString());
    }

    public static ColibriLicenca load(File file, String password) {
        return new ColibriLicenca(file, password);
    }

    public static void update() {
        ColibriLicenca licenca = ColibriLicenca.load();
        if (!licenca.isValid()) {
            new DownloadLicencaExec(licenca.renovacao){

                @Override
                public void done(File file) {
                    Debug.out((Object)file);
                    if (ColibriLicenca.load(file).isValid()) {
                        new CustomFile(file).moveTo((File)Colibri.FILES.LICENCA.parameters.toFile(), new CopyOption[0]);
                    }
                }
            }.run();
        }
    }

    public void addListener(ILicencaListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ILicencaListener listener) {
        this.listeners.remove(listener);
    }

    public void setListener(ILicencaListener listener) {
        this.listeners.clear();
        this.addListener(listener);
    }

    private void lock(RuntimeLock lock, String reason) {
        if (lock.setVaule(true)) {
            for (ILicencaListener listener : this.listeners) {
                listener.locked(reason);
            }
        }
    }

    private void lock(List<PersistentLock> list, String reason) {
        for (RuntimeLock runtimeLock : list) {
            this.lock(runtimeLock, reason);
        }
    }

    private void unlock(RuntimeLock lock, String reason) {
        if (lock.setVaule(false)) {
            for (ILicencaListener listener : this.listeners) {
                listener.unlocked(reason);
            }
        }
    }

    private void unlock(List<PersistentLock> list, String reason) {
        for (RuntimeLock runtimeLock : list) {
            this.unlock(runtimeLock, reason);
        }
    }

    private boolean hasLock(List<PersistentLock> list) {
        for (RuntimeLock runtimeLock : list) {
            if (!runtimeLock.hasLock()) continue;
            return true;
        }
        return false;
    }

    public boolean hasLock() {
        return this.isTecnica() ? false : this.hasLock(this.persistentLock) || this.expirationLock.hasLock() || this.genericLock.hasLock();
    }

    @Deprecated
    public ColibriLicenca(LICENCAS tipo) {
        this(ColibriLicenca.create(tipo), Colibri.ACCESS_PASSWORD.toString());
    }

    public ColibriLicenca(String password) {
        this(ColibriLicenca.create(LICENCAS.PRO), password);
    }

    public ColibriLicenca(File file, String password) {
        this(ColibriLicenca.create(file), password);
    }

    private ColibriLicenca(LicencaDocument.Licenca licenca, String password) {
        super(licenca);
        this.password = password;
    }

    public Date getDataRenovacao() {
        Date[] date = new Date[]{super.getDataRenovacao(), this.data_renovacao};
        return date[0].compareTo(date[1]) > 0 ? date[0] : date[1];
    }

    public boolean hasModulo(LICENCAS.MODULOS ... modulo) {
        return !this.hasLock() && super.hasModulo(modulo);
    }

    public boolean isTecnica() {
        return Colibri.ACCESS_PASSWORD.equals(this.password);
    }

    public boolean isFormacao() {
        return this.isTipo(LICENCAS.DEMO);
    }

    public boolean isValid() {
        if (super.isValid() || this.isTecnica()) {
            switch (Colibri.MARKET_TYPE) {
                case INTERNAL: {
                    return this.getPaisTitular().equalsIgnoreCase(CheckVatHandler.COUNTRIES.PT.code);
                }
                case EXTERNAL: {
                    return !this.getPaisTitular().equalsIgnoreCase(CheckVatHandler.COUNTRIES.PT.code);
                }
            }
        }
        return false;
    }

    public boolean allows(Colibri.FUNCIONALIDADES funcionalidade) {
        return funcionalidade.contains(this.getTipo());
    }

    private LimiteFacturacao getLimiteFacturacao() {
        if (Colibri.VERSION_TYPE == Colibri.VERSIONS.SERVER) {
            switch (this.getTipo()) {
                case PRO: 
                case PLUS: 
                case LITE: {
                    break;
                }
                case FREE: {
                    return new LimiteFacturacao(new BigDecimal("20000"));
                }
            }
        } else if (Colibri.MARKET_TYPE == Colibri.MARKETS.INTERNAL) {
            switch (this.getTipo()) {
                case PRO: 
                case PLUS: 
                case LITE: {
                    break;
                }
                case FREE: {
                    return new LimiteFacturacao(new BigDecimal("20000"));
                }
            }
        }
        return null;
    }

    public boolean allows(BigDecimal total_facturado) {
        LimiteFacturacao limite = this.getLimiteFacturacao();
        return limite == null || limite.isValid(total_facturado);
    }

    public boolean allows(String nif_empresa) {
        switch (Colibri.MARKET_TYPE) {
            case INTERNAL: {
                break;
            }
            case EXTERNAL: {
                if (this.allows(Colibri.FUNCIONALIDADES.LICENCA_COMERCIAL)) break;
                return true;
            }
        }
        return this.contains(nif_empresa);
    }

    public boolean contains(String nif_empresa) {
        return this.xml.getTitular().getNif().contains(nif_empresa);
    }

    public String getValidade() {
        if (this.isTecnica()) {
            return "TECNICA";
        }
        LimiteFacturacao limite = this.getLimiteFacturacao();
        if (limite != null) {
            switch (Colibri.MARKET_TYPE) {
                case INTERNAL: {
                    return limite.toString();
                }
            }
        }
        switch (this.getPeriodicidade()) {
            case NENHUMA: {
                return "v" + Colibri.VERSION_NUMBER.major;
            }
        }
        return String.valueOf(this.daysToExpire()) + " " + LABELS.info_dias_restantes.toString();
    }

    public String getLicenciamento() {
        if (this.isTipo(LICENCAS.DEMO)) {
            return new StringList(new String[]{Colibri.MARKET_TYPE == Colibri.MARKETS.INTERNAL ? "Vers\u00e3o Demonstra\u00e7\u00e3o" : "Demo Version", this.getNomeTitular()}).concat(" - ");
        }
        if (this.isTipo(LICENCAS.FREE)) {
            return new StringList(new String[]{Colibri.MARKET_TYPE == Colibri.MARKETS.INTERNAL ? "Vers\u00e3o Gratuita" : "Free Version", this.getNomeTitular()}).concat(" - ");
        }
        if (this.allows(Colibri.FUNCIONALIDADES.LICENCA_COMERCIAL)) {
            return new StringList(new String[]{Colibri.MARKET_TYPE == Colibri.MARKETS.INTERNAL ? "C\u00f3pia Licenciada" : "Licensed Copy", this.getNomeTitular()}).concat(" - ");
        }
        return new StringList(new String[]{"***", Colibri.MARKET_TYPE == Colibri.MARKETS.INTERNAL ? "C\u00d3PIA ILEGAL" : "ILLEGAL COPY", "***"}).concat("");
    }

    public String getMencaoLegal(String ... titulo) {
        StringList list = new StringList(titulo);
        list.add((Object)this.getLicenciamento());
        return list.concat(" | ");
    }

    public void control(final String nif_empresa, BigDecimal total_facturado) {
        this.persistentLock.add(new PersistentLock(nif_empresa));
        if (!this.isTecnica()) {
            switch (Colibri.VERSION_TYPE) {
                case INTERNAL: 
                case SERVER: {
                    break;
                }
                case PLUGIN: 
                case DESKTOP: {
                    if (!this.allows(total_facturado)) {
                        this.lock(this.genericLock, Colibri.FILES.MESSAGES.LIMITE_FACTURACAO.text);
                    } else if (!this.allows(nif_empresa)) {
                        this.lock(this.genericLock, Colibri.FILES.MESSAGES.LICENCA_NIF_EMPRESA.text);
                    } else if (this.isExpired(-this.getPeriodicidade().dias_extra)) {
                        this.lock(this.expirationLock, Colibri.FILES.MESSAGES.LICENCA_EXPIRADA.text);
                    }
                    if (Colibri.MARKET_TYPE != Colibri.MARKETS.INTERNAL && !this.allows(Colibri.FUNCIONALIDADES.LICENCA_COMERCIAL)) break;
                    new ControloLicencaExec(new ControloLicencaType(this.getPaisTitular(), this.getNifTitular(), nif_empresa, this.getTipo())){

                        @Override
                        public void done(ControloLicencaResponseType response) {
                            Debug.out((Object)response);
                            ColibriLicenca.this.data_renovacao = response.getData_renovacao();
                            if (ColibriLicenca.this.isExpired()) {
                                new RenovacaoLicencaExec(ColibriLicenca.this.renovacao){

                                    @Override
                                    public void done(RenovacaoLicencaResponseType response) {
                                        Debug.out((Object)response);
                                        for (ILicencaListener listener : ColibriLicenca.this.listeners) {
                                            listener.renovacao(response);
                                        }
                                    }
                                }.schedule();
                            } else if (ColibriLicenca.this.expirationLock.hasLock()) {
                                ColibriLicenca.this.unlock(ColibriLicenca.this.expirationLock, "");
                                new DownloadLicencaExec(ColibriLicenca.this.renovacao){

                                    @Override
                                    public void done(File file) {
                                        Debug.out((Object)file);
                                        new CustomFile(file).copyTo((File)Colibri.FILES.LICENCA.parameters.toFile(), new CopyOption[0]);
                                    }
                                }.schedule();
                            }
                            ColibriLicenca.this.control(response.getEstado_licenca(), response.getEstado_motivo());
                            if (response.getEstado_licenca() == 0) {
                                for (LicencasAssociadosType associado : response.getNif_associados()) {
                                    if (!associado.getNif_associado().equals(nif_empresa)) continue;
                                    ColibriLicenca.this.control(associado.getEstado_licenca(), associado.getEstado_motivo().isEmpty() ? response.getEstado_motivo() : associado.getEstado_motivo());
                                }
                            }
                        }
                    }.schedule();
                }
            }
        }
    }

    private void control(int estado_licenca, String estado_motivo) {
        switch (estado_licenca) {
            case -1: {
                this.lock(this.persistentLock, Colibri.FILES.MESSAGES.LICENCA_INEXISTENTE.text);
                break;
            }
            case 0: {
                this.unlock(this.persistentLock, estado_motivo.isEmpty() ? Colibri.FILES.MESSAGES.LICENCA_ACTIVA.text : estado_motivo);
                break;
            }
            case 1: {
                this.lock(this.persistentLock, estado_motivo.isEmpty() ? Colibri.FILES.MESSAGES.LICENCA_INACTIVA.text : estado_motivo);
                break;
            }
            case 2: {
                this.lock(this.persistentLock, estado_motivo);
                Colibri.PREFERENCES.INTERNAL_LOCK.value.setValue(estado_motivo.isEmpty());
            }
        }
    }
}

