/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.xml.beans.ciuspt;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Date;
import java.util.TreeMap;
import oasisNamesSpecificationUblSchemaXsdCommonAggregateComponents2.AddressType;
import oasisNamesSpecificationUblSchemaXsdCommonAggregateComponents2.AllowanceChargeType;
import oasisNamesSpecificationUblSchemaXsdCommonAggregateComponents2.AttachmentType;
import oasisNamesSpecificationUblSchemaXsdCommonAggregateComponents2.BranchType;
import oasisNamesSpecificationUblSchemaXsdCommonAggregateComponents2.CountryType;
import oasisNamesSpecificationUblSchemaXsdCommonAggregateComponents2.CustomerPartyType;
import oasisNamesSpecificationUblSchemaXsdCommonAggregateComponents2.DeliveryType;
import oasisNamesSpecificationUblSchemaXsdCommonAggregateComponents2.DocumentReferenceType;
import oasisNamesSpecificationUblSchemaXsdCommonAggregateComponents2.FinancialAccountType;
import oasisNamesSpecificationUblSchemaXsdCommonAggregateComponents2.LocationType;
import oasisNamesSpecificationUblSchemaXsdCommonAggregateComponents2.MonetaryTotalType;
import oasisNamesSpecificationUblSchemaXsdCommonAggregateComponents2.PartyIdentificationType;
import oasisNamesSpecificationUblSchemaXsdCommonAggregateComponents2.PartyLegalEntityType;
import oasisNamesSpecificationUblSchemaXsdCommonAggregateComponents2.PartyNameType;
import oasisNamesSpecificationUblSchemaXsdCommonAggregateComponents2.PartyTaxSchemeType;
import oasisNamesSpecificationUblSchemaXsdCommonAggregateComponents2.PartyType;
import oasisNamesSpecificationUblSchemaXsdCommonAggregateComponents2.PaymentMeansType;
import oasisNamesSpecificationUblSchemaXsdCommonAggregateComponents2.PaymentTermsType;
import oasisNamesSpecificationUblSchemaXsdCommonAggregateComponents2.PeriodType;
import oasisNamesSpecificationUblSchemaXsdCommonAggregateComponents2.SupplierPartyType;
import oasisNamesSpecificationUblSchemaXsdCommonAggregateComponents2.TaxCategoryType;
import oasisNamesSpecificationUblSchemaXsdCommonAggregateComponents2.TaxSchemeType;
import oasisNamesSpecificationUblSchemaXsdCommonAggregateComponents2.TaxSubtotalType;
import oasisNamesSpecificationUblSchemaXsdCommonAggregateComponents2.TaxTotalType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.ActualDeliveryDateType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.AllowanceChargeReasonCodeType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.AllowanceChargeReasonType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.AllowanceTotalAmountType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.AmountType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.ChargeIndicatorType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.CityNameType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.CompanyIDType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.CountrySubentityType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.CustomizationIDType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.DescriptionCodeType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.DocumentCurrencyCodeType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.EmbeddedDocumentBinaryObjectType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.EndDateType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.EndpointIDType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.IDType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.IdentificationCodeType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.IssueDateType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.LineExtensionAmountType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.NameType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.NoteType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.PayableAmountType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.PaymentIDType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.PaymentMeansCodeType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.PercentType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.PostalZoneType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.RegistrationNameType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.StartDateType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.StreetNameType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.TaxAmountType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.TaxExclusiveAmountType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.TaxExemptionReasonCodeType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.TaxExemptionReasonType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.TaxInclusiveAmountType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.TaxableAmountType;
import org.dma.java.io.CustomFile;
import org.dma.java.io.FileParameters;
import org.dma.java.math.BusinessRules;
import org.dma.java.util.MessageLine;
import org.dma.java.util.MessageList;
import org.dma.java.util.StringList;
import org.dma.java.util.TimeDateUtils;
import org.dma.services.mb.MultibancoRef;
import org.projectocolibri.api.birt.report.BIRTReport;
import org.projectocolibri.api.birt.report.BIRTReportFile;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.model.Contasbancarias;
import org.projectocolibri.api.database.model.Empresa;
import org.projectocolibri.api.database.model.Entidades;
import org.projectocolibri.api.database.model.Entidadesdocumentos;
import org.projectocolibri.api.database.model.Entidadesdocumentosivas;
import org.projectocolibri.api.database.model.Entidadesdocumentoslinhas;
import org.projectocolibri.api.language.LABELS;
import org.projectocolibri.api.services.broker.BrokerDocumentType;
import org.projectocolibri.api.services.broker.BrokerServicesClient;
import org.projectocolibri.api.services.broker.UploadDocumentResponseType;
import org.projectocolibri.api.services.broker.UploadDocumentType;
import org.projectocolibri.xml.beans.ciuspt.ICIUSExport;
import org.projectocolibri.xml.beans.ciuspt.UBL21Tables;
import org.projectocolibri.xml.beans.saft.ATMessageFormatter;
import org.projectocolibri.xml.beans.saft.qrcode.ATQRCodeField;
import org.projectocolibri.xml.beans.saft.qrcode.ATQRCodeFieldList;

public abstract class CIUS21Export
extends UBL21Tables
implements ICIUSExport {
    public static final String VERSAO = "2.1";
    public static final String ELETRONIC_EMAIL_SCHEME_ID = "EM";
    public static final String COUNTRY_CODE_ID = "ISO3166-1:Alpha2";
    public static final String DISCOUNT_REASON_CODE_ID = "UNCL5189";
    public static final String DISCOUNT_REASON_CODE_VALUE = "104";
    public static final String DISCOUNT_REASON_VALUE = "Standart Discount";
    protected final Entidadesdocumentos documento;
    protected final DatabaseManager manager;

    public CIUS21Export(Entidadesdocumentos documento) {
        this.documento = documento;
        this.manager = documento.getManager();
    }

    @Override
    public FileParameters getFileParameters(File folder) {
        return new FileParameters(new StringList(new String[]{this.manager.getEmpresa().getNifParsed(), "CIUS-PT", new BrokerDocumentType(this.documento).getIdtoText()}).concat("_"), "xml", folder);
    }

    public MessageList export(OutputStream stream) {
        MessageList error = new MessageList();
        try {
            this.process();
        }
        catch (Exception e) {
            error.add((Throwable)e);
        }
        if (!this.save(stream)) {
            error.add((Object)new MessageLine((Object)LABELS.erro_ficheiro_gravar));
        } else if (this.isEmpty()) {
            error.add((Object)new MessageLine((Object)LABELS.erro_ficheiro_vazio));
        } else if (!this.isValid()) {
            error.add((Object)new MessageLine((Object)LABELS.erro_ficheiro_invalido));
        }
        return error;
    }

    @Override
    public MessageList export(File file) {
        if (!file.isDirectory()) {
            try {
                return this.export(new CustomFile(file).asOutputStream());
            }
            catch (Exception e) {
                return new MessageList((Throwable)e);
            }
        }
        return this.export((File)this.getFileParameters(file).toFile());
    }

    @Override
    public UploadDocumentResponseType upload() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        MessageList error = this.export(out);
        return error.isEmpty() ? new BrokerServicesClient().uploadDocument(new UploadDocumentType(this.manager.getLicenca().getNifTitular(), this.manager.getEmpresa().getNifParsed(), this.documento.getNifParsed(), new BrokerDocumentType(this.documento, out.toByteArray()))) : new UploadDocumentResponseType(error);
    }

    protected void createCustomizationID(CustomizationIDType customizationIDType, IDType IDType2, IssueDateType issueDateType, DocumentCurrencyCodeType documentCurrencyCodeType) {
        customizationIDType.setStringValue("urn:cen.eu:en16931:2017#compliant#urn:feap.gov.pt:CIUS-PT:2.1");
        IDType2.setStringValue(this.parseText(this.documento.toString(), 50));
        issueDateType.setCalendarValue(TimeDateUtils.getCalendarWithoutTimezone((Date)this.documento.getDatacriacao()));
        documentCurrencyCodeType.setListID("ISO4217");
        documentCurrencyCodeType.setStringValue(this.manager.getParametros().getMoeda().getCodigo());
    }

    @Deprecated
    protected void createInvoicePeriod(PeriodType periodType) {
        DescriptionCodeType descriptionCodeType = periodType.addNewDescriptionCode();
        descriptionCodeType.setListID("UNTDID2005[6]");
        descriptionCodeType.setStringValue("3");
        StartDateType startDateType = periodType.addNewStartDate();
        startDateType.setCalendarValue(TimeDateUtils.getCalendarWithoutTimezone((Date)this.documento.getDatacriacao()));
        EndDateType endDateType = periodType.addNewEndDate();
        endDateType.setCalendarValue(TimeDateUtils.getCalendarWithoutTimezone((Date)this.documento.getDatavencimento()));
    }

    protected void createEmbeddedAttachment(ADDITIONAL_DOCUMENT_REFERENCE_TYPE type, DocumentReferenceType documentReferenceType) {
        AttachmentType attachmentType = documentReferenceType.addNewAttachment();
        EmbeddedDocumentBinaryObjectType embeddedDocumentBinaryObjectType = attachmentType.addNewEmbeddedDocumentBinaryObject();
        switch (type) {
            case PDF: {
                BIRTReportFile file = this.documento.createReport().process(BIRTReport.REPORT_ACTIONS.EMBED, BIRTReport.REPORT_FORMATS.PDF);
                if (file == null) break;
                embeddedDocumentBinaryObjectType.setStringValue(file.encodeBase64String());
                embeddedDocumentBinaryObjectType.setMimeCode("application/pdf");
                embeddedDocumentBinaryObjectType.setFilename(file.getName());
                break;
            }
            case QRCODE: {
                ATQRCodeFieldList list = new ATQRCodeFieldList(this.documento);
                embeddedDocumentBinaryObjectType.setStringValue(list.toBase64String());
                embeddedDocumentBinaryObjectType.setMimeCode("text/plain");
                embeddedDocumentBinaryObjectType.setFilename(list.get((ATQRCodeField.CODES)ATQRCodeField.CODES.G).value);
            }
        }
    }

    protected void createAccountingSupplierParty(SupplierPartyType supplierPartyType) {
        Empresa empresa = this.manager.getEmpresa();
        PartyType partyType = supplierPartyType.addNewParty();
        if (!this.isEmpty(empresa.getEmail())) {
            EndpointIDType endpointIDType = partyType.addNewEndpointID();
            endpointIDType.setSchemeID(ELETRONIC_EMAIL_SCHEME_ID);
            endpointIDType.setStringValue(this.parseText(empresa.getEmail(), 50));
        }
        this.createSupplierPartyIdentification(partyType, empresa);
        this.createSupplierPartyName(partyType, empresa);
        this.createSupplierPostalAddress(partyType, empresa);
        this.createSupplierPartyTaxScheme(partyType, empresa);
        this.createSupplierPartyLegalEntity(partyType, empresa);
    }

    private void createSupplierPartyIdentification(PartyType partyType, Empresa empresa) {
        PartyIdentificationType partyIdentificationType = partyType.addNewPartyIdentification();
        IDType IDType2 = partyIdentificationType.addNewID();
        IDType2.setStringValue(this.parseText(String.valueOf(empresa.getPais().getCodigo()) + empresa.getNifParsed(), 50));
    }

    private void createSupplierPartyName(PartyType partyType, Empresa empresa) {
        PartyNameType partyNameType = partyType.addNewPartyName();
        NameType nameType = partyNameType.addNewName();
        nameType.setStringValue(this.parseText(empresa.getNome(), 200));
    }

    private void createSupplierPostalAddress(PartyType partyType, Empresa empresa) {
        AddressType addressType = partyType.addNewPostalAddress();
        StreetNameType streetNameType = addressType.addNewStreetName();
        streetNameType.setStringValue(this.isEmpty(empresa.getMorada()) ? "Desconhecido" : this.parseText(empresa.getMoradaToText(), 200));
        CityNameType cityNameType = addressType.addNewCityName();
        cityNameType.setStringValue(this.isEmpty(empresa.getCodigopostal().getDescricao()) ? "Desconhecido" : this.parseText(empresa.getCodigopostal().getDescricao(), 200));
        PostalZoneType postalZoneType = addressType.addNewPostalZone();
        postalZoneType.setStringValue(this.parseText(empresa.getCodigopostal(), 200, ""));
        CountrySubentityType countrySubentityType = addressType.addNewCountrySubentity();
        countrySubentityType.setStringValue(this.isEmpty(empresa.getCodigopostal().getDescricao()) ? "Desconhecido" : this.parseText(empresa.getCodigopostal().getDescricao(), 200));
        this.createSupplierCountry(addressType, empresa);
    }

    private void createSupplierCountry(AddressType addressType, Empresa empresa) {
        CountryType countryType = addressType.addNewCountry();
        IdentificationCodeType identificationCodeType = countryType.addNewIdentificationCode();
        identificationCodeType.setListID(COUNTRY_CODE_ID);
        identificationCodeType.setStringValue(this.isEmpty(empresa.getPais().getCodigo()) ? "Desconhecido" : this.parseText(empresa.getPais().getCodigo(), 50));
    }

    private void createSupplierPartyTaxScheme(PartyType partyType, Empresa empresa) {
        PartyTaxSchemeType partyTaxSchemeType = partyType.addNewPartyTaxScheme();
        CompanyIDType companyIDType = partyTaxSchemeType.addNewCompanyID();
        companyIDType.setStringValue(this.parseText(String.valueOf(empresa.getPais().getCodigo()) + empresa.getNifParsed(), 50));
        this.createTaxScheme(partyTaxSchemeType.addNewTaxScheme());
    }

    private void createSupplierPartyLegalEntity(PartyType partyType, Empresa empresa) {
        PartyLegalEntityType partyLegalEntityType = partyType.addNewPartyLegalEntity();
        RegistrationNameType registrationNameType = partyLegalEntityType.addNewRegistrationName();
        registrationNameType.setStringValue(this.parseText(empresa.getNome(), 200));
        CompanyIDType companyIDType = partyLegalEntityType.addNewCompanyID();
        companyIDType.setStringValue(this.parseText(String.valueOf(empresa.getPais().getCodigo()) + empresa.getNifParsed(), 50));
    }

    protected void createAccountingCustomerParty(CustomerPartyType customerPartyType) {
        PartyType partyType = customerPartyType.addNewParty();
        if (!this.isEmpty(this.documento.getEntidade().getEmail())) {
            EndpointIDType endpointIDType = partyType.addNewEndpointID();
            endpointIDType.setSchemeID(ELETRONIC_EMAIL_SCHEME_ID);
            endpointIDType.setStringValue(this.parseText(this.documento.getEntidade().getEmail(), 50));
        }
        this.createCustomerPartyIdentification(partyType, this.documento.getEntidade());
        this.createCustomerPartyName(partyType, this.documento.getEntidade());
        this.createCustomerPostalAddress(partyType, this.documento.getEntidade());
        this.createCustomerPartyTaxScheme(partyType, this.documento.getEntidade());
        this.createCustomerPartyLegalEntity(partyType, this.documento.getEntidade());
    }

    private void createCustomerPartyIdentification(PartyType partyType, Entidades entidade) {
        PartyIdentificationType partyIdentificationType = partyType.addNewPartyIdentification();
        IDType IDType2 = partyIdentificationType.addNewID();
        IDType2.setStringValue(this.parseText(String.valueOf(entidade.getPais().getCodigo()) + entidade.getNifParsed(), 50));
    }

    private void createCustomerPartyName(PartyType partyType, Entidades entidade) {
        PartyNameType partyName = partyType.addNewPartyName();
        NameType nameType = partyName.addNewName();
        nameType.setStringValue(this.parseText(entidade.getNome(), 200));
    }

    private void createCustomerPostalAddress(PartyType partyType, Entidades entidade) {
        AddressType addressType = partyType.addNewPostalAddress();
        StreetNameType streetNameType = addressType.addNewStreetName();
        streetNameType.setStringValue(this.isEmpty(entidade.getMorada()) ? "Desconhecido" : this.parseText(entidade.getMoradaToText(), 200));
        CityNameType cityNameType = addressType.addNewCityName();
        cityNameType.setStringValue(this.isEmpty(entidade.getCodigopostal().getDescricao()) ? "Desconhecido" : this.parseText(entidade.getCodigopostal().getDescricao(), 200));
        PostalZoneType postalZoneType = addressType.addNewPostalZone();
        postalZoneType.setStringValue(this.parseText(entidade.getCodigopostal(), 200));
        CountrySubentityType countrySubentityType = addressType.addNewCountrySubentity();
        countrySubentityType.setStringValue(this.isEmpty(entidade.getCodigopostal().getDescricao()) ? "Desconhecido" : this.parseText(entidade.getCodigopostal().getDescricao(), 200));
        this.createCustomerCountry(addressType, entidade);
    }

    private void createCustomerCountry(AddressType addressType, Entidades entidade) {
        CountryType countryType = addressType.addNewCountry();
        IdentificationCodeType identificationCodeType = countryType.addNewIdentificationCode();
        identificationCodeType.setListID(COUNTRY_CODE_ID);
        identificationCodeType.setStringValue(this.isEmpty(entidade.getPais().getCodigo()) ? "Desconhecido" : this.parseText(entidade.getPais().getCodigo(), 50));
    }

    private void createCustomerPartyTaxScheme(PartyType partyType, Entidades entidade) {
        PartyTaxSchemeType partyTaxSchemeType = partyType.addNewPartyTaxScheme();
        CompanyIDType companyIDType = partyTaxSchemeType.addNewCompanyID();
        companyIDType.setStringValue(this.parseText(String.valueOf(entidade.getPais().getCodigo()) + entidade.getNifParsed(), 50));
        this.createTaxScheme(partyTaxSchemeType.addNewTaxScheme());
    }

    private void createCustomerPartyLegalEntity(PartyType partyType, Entidades entidade) {
        PartyLegalEntityType partyLegalEntityType = partyType.addNewPartyLegalEntity();
        RegistrationNameType registrationNameType = partyLegalEntityType.addNewRegistrationName();
        registrationNameType.setStringValue(this.parseText(entidade.getNome(), 200));
        CompanyIDType companyIDType = partyLegalEntityType.addNewCompanyID();
        companyIDType.setStringValue(this.parseText(String.valueOf(entidade.getPais().getCodigo()) + entidade.getNifParsed(), 50));
    }

    protected void createDelivery(DeliveryType deliveryType) {
        ActualDeliveryDateType actualDeliveryDateType = deliveryType.addNewActualDeliveryDate();
        actualDeliveryDateType.setCalendarValue(TimeDateUtils.getCalendarWithoutTimezone((Date)this.documento.getDatadescarga()));
        this.createDeliveryLocation(deliveryType);
        this.createDeliveryParty(deliveryType);
    }

    private void createDeliveryLocation(DeliveryType deliveryType) {
        LocationType locationType = deliveryType.addNewDeliveryLocation();
        this.createDeliveryLocationAddress(locationType);
    }

    private void createDeliveryLocationAddress(LocationType locationType) {
        AddressType addressType = locationType.addNewAddress();
        StreetNameType streetNameType = addressType.addNewStreetName();
        streetNameType.setStringValue(this.isEmpty(this.documento.getLocaldescarga()) ? "Desconhecido" : this.parseText(this.documento.getLocaldescargaToText(), 200));
        CityNameType cityNameType = addressType.addNewCityName();
        cityNameType.setStringValue(this.isEmpty(this.documento.getLocalidadedescarga()) ? "Desconhecido" : this.parseText(this.documento.getLocalidadedescarga(), 200));
        PostalZoneType postalZoneType = addressType.addNewPostalZone();
        postalZoneType.setStringValue(this.isEmpty(this.documento.getCodigopostaldescarga().getCodigo()) ? "Desconhecido" : this.parseText(this.documento.getCodigopostaldescarga().getCodigo(), 200));
        CountrySubentityType countrySubentityType = addressType.addNewCountrySubentity();
        countrySubentityType.setStringValue(this.isEmpty(this.documento.getCodigopostaldescarga().getDescricao()) ? "Desconhecido" : this.parseText(this.documento.getCodigopostaldescarga().getDescricao(), 200));
        this.createDeliveryCountry(addressType);
    }

    private void createDeliveryCountry(AddressType addressType) {
        CountryType countryType = addressType.addNewCountry();
        IdentificationCodeType identificationCodeType = countryType.addNewIdentificationCode();
        identificationCodeType.setListID(COUNTRY_CODE_ID);
        identificationCodeType.setStringValue(this.isEmpty(this.documento.getPaisdescarga().getCodigo()) ? "Desconhecido" : this.documento.getPaisdescarga().getCodigo());
    }

    private void createDeliveryParty(DeliveryType deliveryType) {
        PartyType partyType = deliveryType.addNewDeliveryParty();
        PartyNameType partyNameType = partyType.addNewPartyName();
        NameType nameType = partyNameType.addNewName();
        nameType.setStringValue(this.isEmpty(this.documento.getLocaldescarga()) ? "Desconhecido" : this.parseText(this.documento.getLocaldescargaToText(), 200));
    }

    protected void createPaymentMeans(PaymentMeansType paymentMeansType) {
        PaymentMeansCodeType paymentMeansCodeType = paymentMeansType.addNewPaymentMeansCode();
        paymentMeansCodeType.setStringValue(CIUS21Export.getPaymentMeansCode(this.documento.getMetodopagamento()));
        switch (this.documento.getMetodopagamento().getTipo()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.createPayeeFinancialAccount(paymentMeansType);
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                this.createATMPayment(paymentMeansType, paymentMeansCodeType);
            }
        }
    }

    private void createATMPayment(PaymentMeansType paymentMeansType, PaymentMeansCodeType paymentMeansCodeType) {
        MultibancoRef multibanco = this.documento.getMultibanco();
        paymentMeansCodeType.setStringValue("#ENTITY@ATMPAYMENT#" + multibanco.getEntity() + "#");
        paymentMeansCodeType.setName("#DESCRIPTION@ATMPAYMENT#" + this.documento.getTotal().toPlainString() + "#");
        PaymentIDType paymentIDType = paymentMeansType.addNewPaymentID();
        paymentIDType.setStringValue("#REFERENCE@ATMPAYMENT#" + multibanco.getRef9() + "#");
    }

    private void createPayeeFinancialAccount(PaymentMeansType paymentMeansType) {
        Contasbancarias contabancaria = this.documento.getManager().getParametros().getContabancaria();
        FinancialAccountType financialAccountType = paymentMeansType.addNewPayeeFinancialAccount();
        IDType IDType2 = financialAccountType.addNewID();
        IDType2.setStringValue(contabancaria.getNomebancoToText());
        NameType nameType = financialAccountType.addNewName();
        nameType.setStringValue(contabancaria.getNomebancoToText());
        this.createFinancialInstitutionBranch(financialAccountType, contabancaria);
    }

    private void createFinancialInstitutionBranch(FinancialAccountType financialAccountType, Contasbancarias contabancaria) {
        BranchType branchType = financialAccountType.addNewFinancialInstitutionBranch();
        IDType IDType2 = branchType.addNewID();
        IDType2.setStringValue(contabancaria.getNomebancoToText());
    }

    protected void createPaymentTerms(PaymentTermsType paymentTermsType) {
        NoteType noteType = paymentTermsType.addNewNote();
        noteType.setStringValue(this.parseText(this.documento.getCondicaopagamento().getDescricao(), 200));
    }

    protected void createAllowanceCharge(AllowanceChargeType allowanceChargeType, Entidadesdocumentosivas iva) {
        ChargeIndicatorType chargeIndicatorType = allowanceChargeType.addNewChargeIndicator();
        chargeIndicatorType.setBooleanValue(false);
        AllowanceChargeReasonCodeType allowanceChargeReasonCodeType = allowanceChargeType.addNewAllowanceChargeReasonCode();
        allowanceChargeReasonCodeType.setListID(DISCOUNT_REASON_CODE_ID);
        allowanceChargeReasonCodeType.setStringValue(DISCOUNT_REASON_CODE_VALUE);
        AllowanceChargeReasonType allowanceChargeReasonType = allowanceChargeType.addNewAllowanceChargeReason();
        allowanceChargeReasonType.setStringValue(DISCOUNT_REASON_VALUE);
        AmountType amountType = allowanceChargeType.addNewAmount();
        amountType.setBigDecimalValue(ATMessageFormatter.getGrossTotal(iva.getValordesconto()));
        amountType.setCurrencyID(this.manager.getParametros().getMoeda().getCodigo());
        this.createTaxCategory(allowanceChargeType, iva);
    }

    private void createTaxCategory(AllowanceChargeType allowanceChargeType, Entidadesdocumentosivas iva) {
        TaxCategoryType taxCategoryType = allowanceChargeType.addNewTaxCategory();
        IDType IDType2 = taxCategoryType.addNewID();
        IDType2.setStringValue(CIUS21Export.getTaxCategory(iva.getCodigoiva()));
        PercentType percentType = taxCategoryType.addNewPercent();
        percentType.setBigDecimalValue(iva.getCodigoiva().getTaxa());
        this.createTaxScheme(taxCategoryType.addNewTaxScheme());
    }

    protected void createTaxTotal(TaxTotalType taxTotalType) {
        TaxAmountType taxAmountType = taxTotalType.addNewTaxAmount();
        taxAmountType.setBigDecimalValue(ATMessageFormatter.getGrossTotal(this.documento.getTotaliva()));
        taxAmountType.setCurrencyID(this.manager.getParametros().getMoeda().getCodigo());
        this.createTaxSubtotal(taxTotalType);
    }

    private void createTaxSubtotal(TaxTotalType taxTotalType) {
        TreeMap<String, TaxSubtotalType> map = new TreeMap<String, TaxSubtotalType>();
        for (Entidadesdocumentoslinhas linha : this.documento.getLinhasdocumento$Tipo(1)) {
            TaxAmountType taxAmountType;
            TaxableAmountType taxableAmountType;
            String key = String.valueOf(linha.getCodigoiva().getCodigo()) + linha.getIsencaoiva().getCodigo();
            TaxSubtotalType taxSubtotalType = (TaxSubtotalType)map.get(key);
            if (taxSubtotalType == null) {
                taxSubtotalType = taxTotalType.addNewTaxSubtotal();
                map.put(key, taxSubtotalType);
                taxableAmountType = taxSubtotalType.addNewTaxableAmount();
                taxableAmountType.setBigDecimalValue(BigDecimal.ZERO);
                taxableAmountType.setCurrencyID(this.manager.getParametros().getMoeda().getCodigo());
                taxAmountType = taxSubtotalType.addNewTaxAmount();
                taxAmountType.setBigDecimalValue(BigDecimal.ZERO);
                taxAmountType.setCurrencyID(this.manager.getParametros().getMoeda().getCodigo());
                this.createTaxCategory(taxSubtotalType, linha);
            }
            taxableAmountType = taxSubtotalType.getTaxableAmount();
            taxableAmountType.setBigDecimalValue(taxableAmountType.getBigDecimalValue().add(linha.getValorliquido()));
            taxAmountType = taxSubtotalType.getTaxAmount();
            taxAmountType.setBigDecimalValue(taxAmountType.getBigDecimalValue().add(linha.getValoriva()));
        }
        for (TaxSubtotalType taxSubtotalType : map.values()) {
            TaxableAmountType taxableAmountType = taxSubtotalType.getTaxableAmount();
            taxableAmountType.setBigDecimalValue(ATMessageFormatter.getGrossTotal(BusinessRules.netValue((BigDecimal)taxableAmountType.getBigDecimalValue(), (BigDecimal)this.documento.getPercdesconto())));
            TaxAmountType taxAmountType = taxSubtotalType.getTaxAmount();
            taxAmountType.setBigDecimalValue(ATMessageFormatter.getGrossTotal(BusinessRules.netValue((BigDecimal)taxAmountType.getBigDecimalValue(), (BigDecimal)this.documento.getPercdesconto())));
        }
    }

    private void createTaxCategory(TaxSubtotalType taxSubtotalType, Entidadesdocumentoslinhas linha) {
        TaxCategoryType taxCategoryType = taxSubtotalType.addNewTaxCategory();
        IDType IDType2 = taxCategoryType.addNewID();
        IDType2.setStringValue(CIUS21Export.getTaxCategory(linha.getCodigoiva()));
        PercentType percentType = taxCategoryType.addNewPercent();
        percentType.setBigDecimalValue(ATMessageFormatter.getGrossTotal(linha.getCodigoiva().getTaxa()));
        if (!linha.getCodigoiva().hasTaxa()) {
            TaxExemptionReasonType taxExemptionReasonType = taxCategoryType.addNewTaxExemptionReason();
            taxExemptionReasonType.setStringValue(linha.getIsencaoiva().getDescricao());
            TaxExemptionReasonCodeType taxExemptionReasonCodeType = taxCategoryType.addNewTaxExemptionReasonCode();
            taxExemptionReasonCodeType.setStringValue(linha.getIsencaoiva().getCodigo());
        }
        this.createTaxScheme(taxCategoryType.addNewTaxScheme());
    }

    protected void createTaxScheme(TaxSchemeType taxSchemeType) {
        IDType IDType2 = taxSchemeType.addNewID();
        IDType2.setSchemeID("UN/ECE 5153");
        IDType2.setStringValue("VAT");
    }

    protected void createLegalMonetaryTotal(MonetaryTotalType monetaryTotalType) {
        LineExtensionAmountType lineExtensionAmountType = monetaryTotalType.addNewLineExtensionAmount();
        lineExtensionAmountType.setBigDecimalValue(ATMessageFormatter.getGrossTotal(this.documento.getTotalliquido2()));
        lineExtensionAmountType.setCurrencyID(this.manager.getParametros().getMoeda().getCodigo());
        TaxExclusiveAmountType taxExclusiveAmountType = monetaryTotalType.addNewTaxExclusiveAmount();
        taxExclusiveAmountType.setBigDecimalValue(ATMessageFormatter.getGrossTotal(this.documento.getTotalliquido()));
        taxExclusiveAmountType.setCurrencyID(this.manager.getParametros().getMoeda().getCodigo());
        TaxInclusiveAmountType taxInclusiveAmountType = monetaryTotalType.addNewTaxInclusiveAmount();
        taxInclusiveAmountType.setBigDecimalValue(ATMessageFormatter.getGrossTotal(this.documento.getTotalbruto()));
        taxInclusiveAmountType.setCurrencyID(this.manager.getParametros().getMoeda().getCodigo());
        if (this.documento.getPercdesconto().signum() != 0) {
            AllowanceTotalAmountType allowanceTotalAmountType = monetaryTotalType.addNewAllowanceTotalAmount();
            allowanceTotalAmountType.setBigDecimalValue(ATMessageFormatter.getGrossTotal(this.documento.getTotaldesconto().subtract(this.documento.getTotaldesconto2())));
            allowanceTotalAmountType.setCurrencyID(this.manager.getParametros().getMoeda().getCodigo());
        }
        PayableAmountType payableAmountType = monetaryTotalType.addNewPayableAmount();
        payableAmountType.setBigDecimalValue(ATMessageFormatter.getGrossTotal(this.documento.getTotalbruto()));
        payableAmountType.setCurrencyID(this.manager.getParametros().getMoeda().getCodigo());
    }

    public static enum ADDITIONAL_DOCUMENT_REFERENCE_TYPE {
        PDF("AIM"),
        QRCODE("ANG");

        public final String schemeID;

        private ADDITIONAL_DOCUMENT_REFERENCE_TYPE(String schemeID) {
            this.schemeID = schemeID;
        }
    }
}

