/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.xml.beans.ciuspt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.dma.java.input.FieldFormat;
import org.dma.java.util.StringUtils;
import org.projectocolibri.api.database.model.Artigos;
import org.projectocolibri.api.database.model.Campos;
import org.projectocolibri.api.database.model.Entidades;
import org.projectocolibri.api.database.model.Entidadesdocumentos;
import org.projectocolibri.api.database.model.Entidadesdocumentoslinhas;
import org.projectocolibri.xml.beans.ciuspt.AdditionalNoteProperty;
import org.projectocolibri.xml.beans.ciuspt.AdditionalProperty;
import org.projectocolibri.xml.beans.saft.ATMessageFormatter;

public class AdditionalFieldMap
extends HashMap<Integer, List<AdditionalProperty>> {
    private static final long serialVersionUID = 1L;

    public List<AdditionalProperty> get(Integer id) {
        if (!this.containsKey(id)) {
            this.put(id, new ArrayList());
        }
        return (List)super.get(id);
    }

    public boolean add(AdditionalProperty property) {
        return this.add(1, property);
    }

    public boolean add(Campos campo, AdditionalProperty property) {
        return this.add(campo.getCiusid(), property);
    }

    public boolean add(Integer id, AdditionalProperty property) {
        return property.isEmpty() ? false : this.get(id).add(property);
    }

    public AdditionalFieldMap(Entidadesdocumentos documento) {
        this.add(new AdditionalNoteProperty("NUMBER@ATCERTIFIEDPROGRAM", "38/AT", 20));
        this.add(new AdditionalNoteProperty("HASHCODE@ATCERTIFIEDPROGRAM", documento.getHashCheckdigits(), 20));
        this.add(new AdditionalNoteProperty("DESCRIPTION@ATCERTIFIEDPROGRAM", documento.getReportMessage(), 150));
        int count = 0;
        for (Entidadesdocumentoslinhas entidadesdocumentoslinhas : documento.getLinhasdocumento()) {
            if (entidadesdocumentoslinhas.getValorretencao().signum() <= 0) continue;
            String id = "WITHHOLDINGTAX-" + StringUtils.padLeft((String)String.valueOf(++count), (int)3, (char)'0');
            this.add(new AdditionalNoteProperty("WITHHOLDINGTAXDESCRIPTION@" + id, "RETENCAO", 150));
            this.add(new AdditionalNoteProperty("WITHHOLDINGTAXAMOUNT@" + id, ATMessageFormatter.getGrossTotal(entidadesdocumentoslinhas.getValorretencao()).toPlainString(), 150));
            this.add(new AdditionalNoteProperty("WITHHOLDINGTAXTYPE@" + id, "IRF", 150));
        }
        this.add(new AdditionalNoteProperty("ADDITIONALPROPERTY#NUMEROAUXILIAR", documento.getNumeroauxiliar(), 100));
        for (String string : documento.getObsToList()) {
            for (String value : StringUtils.wrap((String)string, (int)100, (String)FieldFormat.SEPARATOR.SEMICOLON.value)) {
                this.add(new AdditionalNoteProperty("ADDITIONALPROPERTY#OBSERVACOES", value, 100));
            }
        }
        for (Entidadesdocumentoslinhas entidadesdocumentoslinhas : documento.getLinhasdocumento$Tipo(2)) {
            for (String value : StringUtils.wrap((String)entidadesdocumentoslinhas.getDescricaoToText(), (int)100, (String)FieldFormat.SEPARATOR.SEMICOLON.value)) {
                this.add(new AdditionalNoteProperty("ADDITIONALPROPERTY#COMENTARIOS", value, 100));
            }
        }
        for (Campos campos : documento.getManager().getCamposCollection(4)) {
            this.add(campos, (AdditionalProperty)new AdditionalNoteProperty(campos, documento, 100));
        }
    }

    public AdditionalFieldMap(Entidadesdocumentoslinhas linha) {
        if (!linha.getCodigoiva().hasTaxa()) {
            this.add(new AdditionalNoteProperty("TAXEXEMPTIONREASONCODE@CLASSIFIEDTAXCATEGORY", linha.getIsencaoiva().getCodigo(), 200));
            this.add(new AdditionalNoteProperty("TAXEXEMPTIONREASON@CLASSIFIEDTAXCATEGORY", linha.getIsencaoiva().getDescricao(), 200));
        }
        for (Campos campo : linha.getManager().getCamposCollection(5)) {
            this.add(campo, new AdditionalProperty(campo, linha, 200));
        }
    }

    public AdditionalFieldMap(Entidades entidade) {
        for (Campos campo : entidade.getManager().getCamposCollection(3)) {
            this.add(campo, new AdditionalProperty(campo, entidade, 200));
        }
    }

    public AdditionalFieldMap(Artigos artigo) {
        for (Campos campo : artigo.getManager().getCamposCollection(0)) {
            this.add(campo, new AdditionalProperty(campo, artigo, 200));
        }
    }
}

