/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.core.support.printer;

import java.awt.Desktop;
import java.io.File;
import org.dma.eclipse.swt.widgets.CustomPrintDialog;
import org.dma.java.awt.PrinterHandler;
import org.dma.java.util.Debug;
import org.dma.java.util.MessageLine;
import org.dma.java.util.MessageList;
import org.projectocolibri.api.language.LABELS;
import org.projectocolibri.core.support.printer.PRINTERS;

public class PrinterSupport
extends MessageList {
    private static final long serialVersionUID = 1L;
    private final String printerName;

    public PrinterSupport() {
        this(PRINTERS.DIALOG.name);
    }

    public PrinterSupport(String printerName) {
        String string = this.printerName = printerName == null ? PRINTERS.DIALOG.name : printerName;
        if (!this.isPrinterValid()) {
            this.add(new MessageLine((Object)LABELS.erro_impressora_invalida).brackets((Object)printerName));
        }
    }

    public boolean isPrinterValid() {
        return PRINTERS.isValid(this.printerName);
    }

    public String getPrinterName() {
        if (PRINTERS.DIALOG.equals(this.printerName)) {
            return new CustomPrintDialog().openDialog();
        }
        if (PRINTERS.DEFAULT.equals(this.printerName)) {
            return PrinterHandler.lookupPrinterName((String)this.printerName);
        }
        return this.printerName;
    }

    public boolean printPdf(File file) {
        Debug.out((String)this.printerName);
        if (!this.systemPrint(file)) {
            try {
                Debug.out((String)this.printerName);
                String printerName = this.getPrinterName();
                Debug.out((String)printerName);
                if (printerName != null) {
                    new PrinterHandler(printerName).printPdf(file);
                }
            }
            catch (Exception e) {
                this.add(new MessageLine((Object)LABELS.operacao_relatorio_imprimir).brackets((Object)e));
            }
        }
        return this.isEmpty();
    }

    public boolean printFile(File file) {
        if (!this.systemPrint(file)) {
            try {
                String printerName = this.getPrinterName();
                if (printerName != null) {
                    new PrinterHandler(printerName).print(file);
                }
            }
            catch (Exception e) {
                this.add(new MessageLine((Object)LABELS.operacao_relatorio_imprimir).brackets((Object)e));
            }
        }
        return this.isEmpty();
    }

    public boolean systemPrint(File file) {
        Desktop desktop;
        if (PRINTERS.SYSTEM.equals(this.printerName) && Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.PRINT)) {
            try {
                desktop.print(file);
                return true;
            }
            catch (Exception e) {
                this.add(new MessageLine((Object)LABELS.operacao_relatorio_imprimir).brackets((Object)e));
            }
        }
        return false;
    }
}

