/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.core.support.printer;

import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import org.dma.java.awt.PrinterHandler;
import org.dma.java.util.StringList;
import org.projectocolibri.api.language.LABELS;

public enum PRINTERS {
    DIALOG("$dialog", (Object)((Object)LABELS.documentostipos_impressora_opcao1) + "(*)"),
    DEFAULT("$default", (Object)((Object)LABELS.documentostipos_impressora_opcao2) + "(*)"),
    SYSTEM("$system", (Object)((Object)LABELS.documentostipos_impressora_opcao3) + "(*)");

    public final String name;
    public final String label;

    private PRINTERS(String name) {
        this(name, "");
    }

    private PRINTERS(String name, String label) {
        this.name = name;
        this.label = label;
    }

    public boolean equals(String printerName) {
        return this.name.equals(printerName);
    }

    public static PRINTERS get(String printerName) {
        PRINTERS[] pRINTERSArray = PRINTERS.values();
        int n = pRINTERSArray.length;
        int n2 = 0;
        while (n2 < n) {
            PRINTERS printer = pRINTERSArray[n2];
            if (printer.equals(printerName)) {
                return printer;
            }
            ++n2;
        }
        return null;
    }

    public static boolean contains(String printerName) {
        return PRINTERS.get(printerName) != null;
    }

    public static boolean isValid(String printerName) {
        if (!PRINTERS.contains(printerName)) {
            try {
                new PrinterHandler(printerName).checkPrinter();
            }
            catch (PrinterException printerException) {
                return false;
            }
        }
        return true;
    }

    public static String[] getAll() {
        StringList list = new StringList();
        Object[] objectArray = PRINTERS.values();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            PRINTERS printer = objectArray[n2];
            list.add((Object)printer.label);
            ++n2;
        }
        objectArray = PrinterJob.lookupPrintServices();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            PRINTERS ps = objectArray[n2];
            list.add((Object)ps.getName());
            ++n2;
        }
        return list.toArray();
    }
}

