/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.core.support.install;

import java.io.File;
import java.net.URL;
import org.dma.java.io.AbstractURLFileCopy;
import org.dma.java.io.URLFile;
import org.dma.java.util.VersionNumber;
import org.eclipse.core.runtime.IProgressMonitor;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.core.support.install.LocalFile;

public class RemoteFile
extends URLFile {
    private final VersionNumber version;
    private final long date;

    public RemoteFile() {
        this(RemoteFile.getURL((String)Colibri.PREFERENCES.INSTALLER_NAME.value.getString(), (String[])new String[0]), VersionNumber.valueOf((String)Colibri.PREFERENCES.INSTALLER_VERSION.value.getString()), Colibri.PREFERENCES.INSTALLER_DATE.value.getLong());
    }

    public RemoteFile(URL url, VersionNumber version) {
        this(url, version, 0L);
    }

    private RemoteFile(URL url, VersionNumber version, long date) {
        super(url);
        this.version = version;
        this.date = date == 0L ? this.getLastModified() : date;
    }

    public boolean isValid() {
        return super.isValid() && Colibri.VERSION_NUMBER.smallerThan(this.version) && this.getLastModified() == this.date;
    }

    public boolean isMicro() {
        return Colibri.VERSION_NUMBER.major == this.version.major && Colibri.VERSION_NUMBER.minor == this.version.minor;
    }

    public boolean update() {
        if (this.isValid()) {
            Colibri.PREFERENCES.INSTALLER_NAME.value.setValue(this.toString());
            Colibri.PREFERENCES.INSTALLER_VERSION.value.setValue(this.version.toString());
            Colibri.PREFERENCES.INSTALLER_DATE.value.setValue(this.date);
            Colibri.markDirty();
            return true;
        }
        return false;
    }

    public void reset() {
        Colibri.PREFERENCES.INSTALLER_NAME.value.setToDefault();
    }

    public void download(final IProgressMonitor monitor) throws Exception {
        new AbstractURLFileCopy(this){

            public boolean cancel() {
                return monitor.isCanceled();
            }
        }.to((File)((Object)this.dst()));
    }

    public LocalFile dst() throws Exception {
        return new LocalFile(this);
    }
}

