/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.core.support.install;

import org.dma.java.io.URLFile;
import org.dma.java.util.SystemUtils;
import org.projectocolibri.api.Colibri;

public enum PLATFORMS {
    win32_win32_x86("Windows 32bits", "colibri.rcp.win32.x86.exe"),
    win32_win32_x86_64("Windows 64bits", "colibri.rcp.win32.x86_64.exe"),
    linux_gtk_x86("Linux GTK 32bits", "colibri.rcp.gtk.x86.tar.gz"),
    linux_gtk_x86_64("Linux GTK 64bits", "colibri.rcp.gtk.x86_64.tar.gz"),
    macosx_carbon_x86("MAC OS-X Carbon 32bits", "colibri.rcp.carbon.x86.dmg"),
    macosx_carbon_ppc("MAC OS-X Carbon PPC", "colibri.rcp.carbon.ppc.dmg"),
    macosx_cocoa_ppc("MAC OS-X Cocoa PPC", "colibri.rcp.cocoa.ppc.dmg"),
    macosx_cocoa_x86("MAC OS-X Cocoa 32bits", "colibri.rcp.cocoa.x86.dmg"),
    macosx_cocoa_x86_64("MAC OS-X Cocoa 64bits", "colibri.rcp.cocoa.x86_64.dmg");

    public final String description;
    public final URLFile file;

    private PLATFORMS(String description, String filename) {
        this.description = description;
        this.file = new URLFile(Colibri.REMOTE_SERVER.handler.folders.installers, new String[]{filename});
    }

    public void debug() {
        this.file.printHeaderFields();
    }

    public static PLATFORMS getCurrent() {
        if (SystemUtils.IS_OS_WINDOWS_ARCH_32) {
            return win32_win32_x86;
        }
        if (SystemUtils.IS_OS_WINDOWS_ARCH_64) {
            return win32_win32_x86_64;
        }
        if (SystemUtils.IS_OS_LINUX_ARCH_32) {
            return linux_gtk_x86;
        }
        if (SystemUtils.IS_OS_LINUX_ARCH_64) {
            return linux_gtk_x86_64;
        }
        if (SystemUtils.IS_OS_MAC_ARCH_32) {
            return macosx_cocoa_x86;
        }
        if (SystemUtils.IS_OS_MAC_ARCH_64) {
            return macosx_cocoa_x86_64;
        }
        return null;
    }
}

