/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.core.support;

import java.util.Iterator;
import java.util.LinkedHashMap;
import org.dma.java.io.UTF8INIConfiguration;
import org.dma.java.util.Debug;
import org.iban4j.Iban;
import org.projectocolibri.api.Colibri;

public class SWIFTBankCodesMap
extends LinkedHashMap<String, SWIFTCode> {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_CODE = "0001";
    private static SWIFTBankCodesMap instance;

    public static SWIFTBankCodesMap getInstance() {
        if (instance == null) {
            instance = new SWIFTBankCodesMap(Colibri.FILES.CONFIG.SWIFT_BANK_CODES.pathname);
        }
        return instance;
    }

    public SWIFTCode get(Iban iban) {
        SWIFTCode value = (SWIFTCode)this.get(iban.getBankCode());
        return value == null ? (SWIFTCode)this.get(DEFAULT_CODE) : value;
    }

    private SWIFTBankCodesMap(String url) {
        block3: {
            Debug.out((String)url);
            try {
                UTF8INIConfiguration reader = new UTF8INIConfiguration();
                reader.load(url);
                Iterator iterator = reader.getKeys();
                while (iterator.hasNext()) {
                    String code = (String)iterator.next();
                    if (code.startsWith("\ufeff#")) continue;
                    String[] data = reader.getStringArray(code);
                    SWIFTCode value = new SWIFTCode(code, data[0], data[1]);
                    System.out.println(value);
                    this.put(code, value);
                }
            }
            catch (Exception exception) {
                if (this.containsKey(DEFAULT_CODE)) break block3;
                this.put(DEFAULT_CODE, new SWIFTCode());
            }
        }
    }

    public static class SWIFTCode {
        public final String code;
        public final String bic;
        public final String name;

        public SWIFTCode() {
            this("", "", "");
        }

        public SWIFTCode(String code, String bic, String name) {
            this.code = code;
            this.bic = bic.trim();
            this.name = name.trim();
        }

        public String toString() {
            return String.valueOf(this.code) + ": " + this.bic + " - " + this.name;
        }
    }
}

