/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.core.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import org.dma.java.util.StringList;
import org.dma.java.util.StringUtils;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.Utilizadores;

public final class PermissionsMap
extends EnumMap<TABLES, TableCommands> {
    private static final long serialVersionUID = 1L;

    public void print() {
        System.out.println("---PERMISSIONS MAP---");
        System.out.println("SIZE=" + this.size());
        for (TABLES key : this.keySet()) {
            System.out.println(this.get(key));
        }
    }

    public TableCommands get(TABLES table) {
        return this.containsKey((Object)table) ? (TableCommands)super.get((Object)table) : new TableCommands(table);
    }

    public TableCommands put(TableCommands tableCommands) {
        return tableCommands.isEmpty() ? null : this.put(tableCommands.table, tableCommands);
    }

    public PermissionsMap(String permissions) {
        super(TABLES.class);
        for (String line : StringUtils.split((String)permissions, (String)";")) {
            try {
                StringList list = StringUtils.split((String)line, (String)":");
                TABLES table = TABLES.valueOf((String)list.get(0));
                if (table == null) continue;
                StringList commands = StringUtils.split((String)((String)list.get(1)), (String)",");
                this.put(new TableCommands(table, commands));
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (TABLES table : this.keySet()) {
            if (sb.length() > 0) {
                sb.append(";");
            }
            sb.append(this.get(table).toString());
        }
        return sb.toString();
    }

    public static class TableCommands
    extends LinkedHashSet<Utilizadores.COMMANDS> {
        private static final long serialVersionUID = 1L;
        public static final String LINE_SEPARATOR = ";";
        public static final String TABLE_SEPARATOR = ":";
        public static final String COMMAND_SEPARATOR = ",";
        public final TABLES table;

        public TableCommands(TABLES table) {
            this(table, new ArrayList<Utilizadores.COMMANDS>());
        }

        public TableCommands(TABLES table, StringList commands) {
            this(table, Utilizadores.COMMANDS.get((Collection<String>)commands));
        }

        public TableCommands(TABLES table, Utilizadores.COMMANDS ... commands) {
            this(table, Arrays.asList(commands));
        }

        public TableCommands(TABLES table, Collection<Utilizadores.COMMANDS> commands) {
            this.table = table;
            this.addAll(commands);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (Utilizadores.COMMANDS command : this) {
                if (sb.length() > 0) {
                    sb.append(COMMAND_SEPARATOR);
                }
                sb.append(command.name());
            }
            if (sb.length() > 0) {
                sb.insert(0, String.valueOf(this.table.name()) + TABLE_SEPARATOR);
            }
            return sb.toString();
        }
    }
}

