/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.core.remote.updates;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.dma.java.io.UTF8URLTextFile;
import org.dma.java.util.Debug;
import org.dma.java.util.StringList;
import org.dma.java.util.VersionNumber;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.core.CERTIFICATES;
import org.projectocolibri.core.remote.RemoteFileHandler;
import org.projectocolibri.core.remote.updates.URLSectionKey;
import org.projectocolibri.core.remote.updates.URLSectionList;
import org.projectocolibri.core.remote.updates.UpdateFileHeader;
import org.projectocolibri.core.support.install.PLATFORMS;
import org.projectocolibri.core.support.install.RemoteFile;

public class UpdateFileHandler
extends RemoteFileHandler {
    private static final long serialVersionUID = 1L;
    private UpdateFileHeader header;
    private URLSectionList platforms;
    private URLSectionList certificates;

    public UpdateFileHeader getHeader() {
        return this.header;
    }

    public URLSectionList getPlatforms() {
        return this.platforms;
    }

    public URLSectionList getCertificates() {
        return this.certificates;
    }

    public UpdateFileHandler(File file) {
        super(file);
        this.header = new UpdateFileHeader(Colibri.VERSION_NUMBER, new UTF8URLTextFile(Colibri.REMOTE_SERVER.handler.folders.readme, new String[]{Colibri.FILES.MESSAGES.REMOTE_UPDATES.filename}), String.valueOf(599999993));
        this.platforms = new URLSectionList(new URLSectionKey(PLATFORMS.win32_win32_x86), new URLSectionKey(PLATFORMS.win32_win32_x86_64), new URLSectionKey(PLATFORMS.linux_gtk_x86), new URLSectionKey(PLATFORMS.linux_gtk_x86_64), new URLSectionKey(PLATFORMS.macosx_cocoa_x86), new URLSectionKey(PLATFORMS.macosx_cocoa_x86_64));
        this.certificates = new URLSectionList(new URLSectionKey(CERTIFICATES.DGITA_SA_GLOBAL), new URLSectionKey(CERTIFICATES.DGITA_SW_PROD), new URLSectionKey(CERTIFICATES.DGITA_SW_TEST));
    }

    @Override
    public void reset() {
        new UpdateFileHandler(this.getFile()).save();
        this.load();
    }

    @Override
    public void loadSections() {
        SECTIONS[] sECTIONSArray = SECTIONS.values();
        int n = sECTIONSArray.length;
        int n2 = 0;
        while (n2 < n) {
            SECTIONS section = sECTIONSArray[n2];
            try {
                SubnodeConfiguration node = this.getSection(section.name());
                switch (section) {
                    case HEADER: {
                        this.header = new UpdateFileHeader(VersionNumber.valueOf((String)node.getString("version")), node.getString("readme") == null ? null : new UTF8URLTextFile(node.getString("readme"), new String[0]), node.getStringArray("nif"));
                        break;
                    }
                    case PLATFORMS: {
                        this.platforms = new URLSectionList(node);
                        break;
                    }
                    case CERTIFICATES: {
                        this.certificates = new URLSectionList(node);
                    }
                }
            }
            catch (Exception e) {
                Debug.out((String)("Error loading section: " + (Object)((Object)section)), (Object)e);
            }
            ++n2;
        }
    }

    @Override
    public void saveSections() {
        SECTIONS[] sECTIONSArray = SECTIONS.values();
        int n = sECTIONSArray.length;
        int n2 = 0;
        while (n2 < n) {
            SECTIONS section = sECTIONSArray[n2];
            try {
                SubnodeConfiguration node = this.getSection(section.name());
                switch (section) {
                    case HEADER: {
                        node.setProperty("version", (Object)this.header.version);
                        if (this.header.readme != null) {
                            node.setProperty("readme", (Object)this.header.readme);
                        }
                        node.setProperty("nif", (Object)StringList.valueOf((Collection)((Object)this.header)).concat(", "));
                        break;
                    }
                    case PLATFORMS: {
                        URLSectionKey element;
                        Iterator iterator = this.platforms.iterator();
                        while (iterator.hasNext()) {
                            element = (URLSectionKey)iterator.next();
                            node.setProperty(element.name, (Object)element);
                        }
                        break;
                    }
                    case CERTIFICATES: {
                        URLSectionKey element;
                        Iterator iterator = this.certificates.iterator();
                        while (iterator.hasNext()) {
                            element = (URLSectionKey)iterator.next();
                            node.setProperty(element.name, (Object)element);
                        }
                        break block1;
                    }
                }
            }
            catch (Exception e) {
                Debug.out((String)("Error saving section: " + (Object)((Object)section)), (Object)e);
            }
            ++n2;
        }
    }

    public RemoteFile getRemoteFile(PLATFORMS platform) {
        URLSectionKey key = platform == null ? null : this.platforms.get(platform.name());
        return this.getRemoteFile(key);
    }

    @Deprecated
    public RemoteFile getRemoteFile(CERTIFICATES certificate) {
        URLSectionKey key = certificate == null ? null : this.certificates.get(certificate.name());
        return this.getRemoteFile(key);
    }

    public RemoteFile getRemoteFile(URLSectionKey key) {
        return key == null ? null : new RemoteFile(key.file.url, this.header.version);
    }

    private static enum SECTIONS {
        HEADER,
        PLATFORMS,
        CERTIFICATES;

    }
}

