/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.core.remote.control;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.dma.java.util.Debug;
import org.dma.java.util.MessageList;
import org.dma.java.util.TimeDateUtils;
import org.projectocolibri.core.remote.control.MessageListSectionKey;

public class MessageListSection
extends ArrayList<MessageListSectionKey> {
    private static final long serialVersionUID = 1L;

    public MessageListSection(MessageListSectionKey ... array) {
        super(Arrays.asList(array));
    }

    public MessageListSection(SubnodeConfiguration node) {
        this.add(node);
    }

    public void add(SubnodeConfiguration node) {
        Iterator iterator = node.getKeys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String[] values = node.getStringArray(key);
            this.add(new MessageListSectionKey(key, values[0]));
        }
    }

    private int indexOf(Date date, int fromIndex) {
        String formatted = TimeDateUtils.getDateFormatted((Date)date);
        int index = fromIndex;
        for (MessageListSectionKey key : this.subList(fromIndex, this.size())) {
            Debug.out((String)"date", (Object)key.date);
            StringBuilder result = new StringBuilder();
            int j = 0;
            while (j < key.date.length()) {
                result.append(key.date.charAt(j) == '?' ? formatted.charAt(j) : key.date.charAt(j));
                ++j;
            }
            if (result.toString().equals(formatted)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public MessageList get(Date date) {
        MessageList list = new MessageList();
        int index = -1;
        while ((index = this.indexOf(date, index + 1)) != -1) {
            Debug.out((String)"match");
            list.add(((MessageListSectionKey)this.get(index)).toText());
        }
        return list;
    }
}

