/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.core.remote.control;

import java.io.File;
import java.util.Date;
import javax.mail.PasswordAuthentication;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.dma.java.email.ServerParameters;
import org.dma.java.io.URLFile;
import org.dma.java.io.UTF8URLTextFile;
import org.dma.java.util.Debug;
import org.dma.java.util.MessageList;
import org.dma.java.util.TimeDateUtils;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.core.remote.RemoteFileHandler;
import org.projectocolibri.core.remote.control.BlackListSection;
import org.projectocolibri.core.remote.control.BlackListSectionKey;
import org.projectocolibri.core.remote.control.CheckListSection;
import org.projectocolibri.core.remote.control.MessageListSection;
import org.projectocolibri.core.remote.control.MessageListSectionKey;
import org.projectocolibri.core.remote.control.RemoteAssistanceSection;

public class ControlFileHandler
extends RemoteFileHandler {
    private static final long serialVersionUID = 1L;
    @Deprecated
    private final ServerParameters mailServer = new ServerParameters("mail.projectocolibri.com", 25, ServerParameters.SECURITY.NONE, new PasswordAuthentication(Colibri.CONTROL_EMAIL.getEmail(), "***"));
    @Deprecated
    private final CheckListSection checkList = new CheckListSection(this.mailServer, Colibri.CONTROL_EMAIL);
    @Deprecated
    private final BlackListSection blackList = new BlackListSection(new BlackListSectionKey(String.valueOf(599999993), "O uso do Colibri est\u00e1 limitado devido ao prazo da licen\u00e7a ter expirado.\\nP.f. entre em contacto com o suporte atrav\u00e9s do telefone 252 904 099."));
    private MessageListSection messageList = new MessageListSection(new MessageListSectionKey("#1", "Lista de datas com mensagem a apresentar ao utilizador"), new MessageListSectionKey("#2", "A data deve estar no formato " + TimeDateUtils.DEFAULT_DATE_PATTERN + " e pode conter ?"), new MessageListSectionKey("#3", "1?-03-2001 = Qualquer dia de 10 a 19 de mar\u00e7o de 2001"), new MessageListSectionKey("#4", "??-02-???? = Qualquer dia de fevereiro de quaquer ano"), new MessageListSectionKey("#5", "??-02-2001 = Qualquer dia de fevereiro de 2001"), new MessageListSectionKey("#6", "14-??-2001 = Dia 14 de qualquer m\u00eas de 2001"), new MessageListSectionKey("11-??-????", "O prazo limite para comunicar o ficheiro SAFT termina amanh\u00e3!"), new MessageListSectionKey("14-02-????", "A equipa do Projecto Colibri deseja a todos um Feliz Namoro!"), new MessageListSectionKey("24-12-????", "A equipa do Projecto Colibri deseja a todos um Feliz Natal!"), new MessageListSectionKey("01-01-????", "A equipa do Projecto Colibri deseja a todos um Feliz Ano Novo!"));
    private RemoteAssistanceSection remoteAssistance;

    @Deprecated
    public ServerParameters getMailServer() {
        return this.mailServer;
    }

    @Deprecated
    public CheckListSection getCheckList() {
        return this.checkList;
    }

    @Deprecated
    public BlackListSection getBlackList() {
        return this.blackList;
    }

    public MessageList getMessageList(Date date) {
        return this.messageList.get(date);
    }

    public RemoteAssistanceSection getRemoteAssistance() {
        return this.remoteAssistance;
    }

    public ControlFileHandler(File file) {
        super(file);
        this.remoteAssistance = new RemoteAssistanceSection(new UTF8URLTextFile(Colibri.REMOTE_SERVER.handler.folders.readme, new String[]{Colibri.FILES.MESSAGES.REMOTE_ASSISTANCE.filename}), new URLFile("https://anydesk.com/pt/downloads/thank-you?dv=win_exe", new String[0]), new URLFile("https://anydesk.com/pt/downloads/thank-you?dv=deb_64", new String[0]), new URLFile("https://anydesk.com/pt/downloads/thank-you?dv=mac_dmg", new String[0]));
    }

    @Override
    public void reset() {
        new ControlFileHandler(this.getFile()).save();
        this.load();
    }

    @Override
    public void loadSections() {
        SECTIONS[] sECTIONSArray = SECTIONS.values();
        int n = sECTIONSArray.length;
        int n2 = 0;
        while (n2 < n) {
            SECTIONS section = sECTIONSArray[n2];
            try {
                SubnodeConfiguration node = this.getSection(section.name());
                switch (section) {
                    case MailServer: {
                        break;
                    }
                    case CheckList: {
                        break;
                    }
                    case BlackList: {
                        break;
                    }
                    case MessageList: {
                        this.messageList = new MessageListSection(node);
                        break;
                    }
                    case RemoteAssistance: {
                        this.remoteAssistance = new RemoteAssistanceSection(node.getString("readme") == null ? null : new UTF8URLTextFile(node.getString("readme"), new String[0]), node.getString("windows") == null ? null : new URLFile(node.getString("windows"), new String[0]), node.getString("linux") == null ? null : new URLFile(node.getString("linux"), new String[0]), node.getString("mac") == null ? null : new URLFile(node.getString("mac"), new String[0]));
                    }
                }
            }
            catch (Exception e) {
                Debug.out((String)("Error loading section: " + (Object)((Object)section)), (Object)e);
            }
            ++n2;
        }
    }

    @Override
    public void saveSections() {
        SECTIONS[] sECTIONSArray = SECTIONS.values();
        int n = sECTIONSArray.length;
        int n2 = 0;
        while (n2 < n) {
            SECTIONS section = sECTIONSArray[n2];
            try {
                SubnodeConfiguration node = this.getSection(section.name());
                switch (section) {
                    case MailServer: {
                        break;
                    }
                    case CheckList: {
                        break;
                    }
                    case BlackList: {
                        break;
                    }
                    case MessageList: {
                        for (MessageListSectionKey key : this.messageList) {
                            node.setProperty(key.date, (Object)key);
                        }
                        break;
                    }
                    case RemoteAssistance: {
                        if (this.remoteAssistance.readme != null) {
                            node.setProperty("readme", (Object)this.remoteAssistance.readme.path(new String[0]));
                        }
                        if (this.remoteAssistance.windows != null) {
                            node.setProperty("windows", (Object)this.remoteAssistance.windows.path(new String[0]));
                        }
                        if (this.remoteAssistance.linux != null) {
                            node.setProperty("linux", (Object)this.remoteAssistance.linux.path(new String[0]));
                        }
                        if (this.remoteAssistance.mac == null) break;
                        node.setProperty("mac", (Object)this.remoteAssistance.mac.path(new String[0]));
                    }
                    default: {
                        break;
                    }
                }
            }
            catch (Exception e) {
                Debug.out((String)("Error saving section: " + (Object)((Object)section)), (Object)e);
            }
            ++n2;
        }
    }

    private static enum SECTIONS {
        MailServer,
        CheckList,
        BlackList,
        MessageList,
        RemoteAssistance;

    }
}

