/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.services.payment;

import java.util.ArrayList;
import java.util.Collection;
import org.dma.eclipse.core.jobs.CustomJob;
import org.dma.eclipse.core.jobs.MutexRule;
import org.dma.eclipse.core.jobs.UIAction;
import org.dma.java.time.DatePeriod;
import org.dma.java.util.MessageList;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.language.LABELS;
import org.projectocolibri.api.services.payment.IPaymentService;
import org.projectocolibri.api.services.payment.PaymentServiceResponseType;

public abstract class PaymentServiceJob
extends CustomJob {
    private static final MutexRule RULE = new MutexRule();
    private final MessageList error = new MessageList();
    private final Collection<PaymentServiceResponseType> col = new ArrayList<PaymentServiceResponseType>();

    public abstract void error(MessageList var1);

    public abstract void done(Collection<PaymentServiceResponseType> var1);

    public PaymentServiceJob(final DatabaseManager manager, final DatePeriod periodo) {
        super(LABELS.operacao_remota_comunicacao.toString());
        this.addTask((IAction)new Action(manager.getParametros().getMbproviderToText()){

            public void run() {
                IPaymentService service = manager.getParametros().getPaymentService();
                if (service != null) {
                    try {
                        PaymentServiceJob.this.col.addAll(service.getCollection(periodo));
                    }
                    catch (Exception e) {
                        PaymentServiceJob.this.error.add((Throwable)e);
                    }
                }
            }
        }).addTask((IAction)new Action(LABELS.operacao_registo_processar.toString()){

            public void run() {
                for (PaymentServiceResponseType response : PaymentServiceJob.this.col) {
                    response.process(manager);
                }
            }
        }).addTask((IAction)new UIAction(){

            public void run() {
                if (PaymentServiceJob.this.error.isEmpty()) {
                    PaymentServiceJob.this.done(PaymentServiceJob.this.col);
                } else {
                    PaymentServiceJob.this.error(PaymentServiceJob.this.error);
                }
            }
        }).setRule((ISchedulingRule)RULE);
    }
}

