/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.services.broker;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import oasisNamesSpecificationUblSchemaXsdCommonAggregateComponents2.DocumentReferenceType;
import oasisNamesSpecificationUblSchemaXsdInvoice2.InvoiceDocument;
import org.apache.commons.codec.binary.Base64;
import org.projectocolibri.api.database.model.Documentostipos;
import org.projectocolibri.api.database.model.Entidadesdocumentos;
import org.projectocolibri.xml.beans.ciuspt.CIUS21Export;

@XmlRootElement(name="document")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class BrokerDocumentType {
    private String id;
    private TYPES type;
    private String base64;

    private BrokerDocumentType() {
    }

    public BrokerDocumentType(Entidadesdocumentos documento) {
        this(documento, new byte[0]);
    }

    public BrokerDocumentType(Entidadesdocumentos documento, byte[] array) {
        this(documento.toString(), TYPES.get(documento.getTipodocumento()), new Base64().encodeToString(array));
    }

    public BrokerDocumentType(String id, TYPES type, String base64) {
        this.id = id;
        this.type = type;
        this.base64 = base64;
    }

    public boolean isEmpty() {
        return this.base64.isEmpty();
    }

    public String getId() {
        return this.id;
    }

    public String getIdtoText() {
        return this.id.replace(' ', '-').replace('/', '-');
    }

    public TYPES getType() {
        return this.type;
    }

    public String getBase64() {
        return this.base64;
    }

    @Deprecated
    public String getBase64(String filename) {
        ByteArrayInputStream in = new ByteArrayInputStream(new Base64().decode(this.base64));
        try {
            InvoiceDocument document = InvoiceDocument.Factory.parse((InputStream)in);
            for (DocumentReferenceType documentReference : document.getInvoice().getAdditionalDocumentReferenceList()) {
                if (!documentReference.getID().getSchemeID().equals(CIUS21Export.ADDITIONAL_DOCUMENT_REFERENCE_TYPE.PDF.schemeID)) continue;
                documentReference.getID().setStringValue(filename);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.base64;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [id=" + this.id + ", type=" + (Object)((Object)this.type) + ", size=" + this.base64.length() + "]";
    }

    @XmlRootElement(name="type")
    public static enum TYPES {
        UNKNOWN,
        CIUS_INVOICE,
        CIUS_CREDIT,
        CIUS_DEBIT,
        PDF;


        public static TYPES get(Documentostipos tipodocumento) {
            switch (tipodocumento.getCIUSDocumentGroup()) {
                case UNKNOWN: {
                    break;
                }
                case INVOICE: {
                    return CIUS_INVOICE;
                }
                case CREDIT: {
                    return CIUS_CREDIT;
                }
                case DEBIT: {
                    return CIUS_DEBIT;
                }
            }
            return UNKNOWN;
        }
    }
}

