/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.services.at.taxfree;

import java.math.BigDecimal;
import org.dma.java.math.BusinessRules;
import org.dma.java.util.RandomValue;
import org.dma.java.util.TimeDateUtils;
import org.projectocolibri.api.database.model.Artigos;
import org.projectocolibri.api.database.model.Documentostipos;
import org.projectocolibri.api.database.model.Entidadesdocumentos;
import org.projectocolibri.api.database.model.Entidadesdocumentosivas;
import org.projectocolibri.api.database.model.Entidadesdocumentoslinhas;
import org.projectocolibri.xml.beans.saft.ATMessageFormatter;
import pt.gov.portaldasfinancas.servicos.taxfree.BuyerType;
import pt.gov.portaldasfinancas.servicos.taxfree.CalculatedTaxType;
import pt.gov.portaldasfinancas.servicos.taxfree.CalculatedTaxesType;
import pt.gov.portaldasfinancas.servicos.taxfree.CompanyType;
import pt.gov.portaldasfinancas.servicos.taxfree.IdentityDocType;
import pt.gov.portaldasfinancas.servicos.taxfree.InvoiceIdentifiersType;
import pt.gov.portaldasfinancas.servicos.taxfree.InvoiceLineType;
import pt.gov.portaldasfinancas.servicos.taxfree.InvoiceLinesListType;
import pt.gov.portaldasfinancas.servicos.taxfree.InvoiceType;
import pt.gov.portaldasfinancas.servicos.taxfree.InvoicesListType;
import pt.gov.portaldasfinancas.servicos.taxfree.InvoicesType;
import pt.gov.portaldasfinancas.servicos.taxfree.RefundType;
import pt.gov.portaldasfinancas.servicos.taxfree.RequestHeaderType;
import pt.gov.portaldasfinancas.servicos.taxfree.TaxFreeCommType;
import pt.gov.portaldasfinancas.servicos.taxfree.TaxFreeSubmissionRequestType;

public class TaxFreeSubmissionType
extends TaxFreeSubmissionRequestType {
    public TaxFreeSubmissionType(Entidadesdocumentos documento) {
        this.setRequestHeader(this.createRequestHeader(documento));
        this.setTaxFreeComm(this.createTaxFreeComm(documento));
    }

    private RequestHeaderType createRequestHeader(Entidadesdocumentos documento) {
        RequestHeaderType header = new RequestHeaderType();
        header.setRequesterTaxID(documento.getManager().getEmpresa().getNifToInteger().intValue());
        return header;
    }

    private TaxFreeCommType createTaxFreeComm(Entidadesdocumentos documento) {
        TaxFreeCommType taxFree = new TaxFreeCommType();
        taxFree.setIdentifier(new RandomValue().integer(9));
        taxFree.setSeller(this.createCompany(documento));
        taxFree.setBuyer(this.createBuyer(documento));
        taxFree.setRefund(this.createRefund(documento));
        InvoicesType invoices = new InvoicesType();
        invoices.setNumberOfEntries(1);
        InvoicesListType invoicesList = new InvoicesListType();
        invoicesList.getInvoice().add(this.createInvoice(documento));
        invoices.setInvoicesList(invoicesList);
        taxFree.setInvoices(invoices);
        return taxFree;
    }

    private CompanyType createCompany(Entidadesdocumentos documento) {
        CompanyType company = new CompanyType();
        company.setTaxRegistrationNumber(documento.getManager().getEmpresa().getNifToInteger().intValue());
        company.setBusinessName(documento.getManager().getEmpresa().getNome());
        company.setEmail(documento.getManager().getEmpresa().getEmail());
        return company;
    }

    private BuyerType createBuyer(Entidadesdocumentos documento) {
        BuyerType buyer = new BuyerType();
        buyer.setName(documento.getNome());
        buyer.setIdentityDoc(this.createIdentityDoc());
        buyer.setResidenceCountryCode(documento.getPais().getCodigo());
        if (!documento.getPais().isEstrangeiro()) {
            buyer.setTaxRegistrationNumber(documento.getNifToInteger());
        }
        buyer.setBirthDate(TimeDateUtils.getXMLGregorianCalendar((String)"2001-09-11"));
        return buyer;
    }

    private IdentityDocType createIdentityDoc() {
        IdentityDocType identity = new IdentityDocType();
        identity.setType("PASSAPORTE");
        identity.setNumber(new RandomValue().integer(9));
        identity.setCountryCode("BR");
        return identity;
    }

    private RefundType createRefund(Entidadesdocumentos documento) {
        RefundType refund = new RefundType();
        refund.setGuaranteeTotal(new BigDecimal("0.00"));
        refund.setCalculatedTaxTotal(documento.getTotaliva());
        return refund;
    }

    private InvoiceType createInvoice(Entidadesdocumentos documento) {
        InvoiceType invoice = new InvoiceType();
        invoice.setInvoiceIdentifiers(this.createInvoiceIdentifiers(documento));
        invoice.setInvoiceType(this.getInvoiceType(documento.getTipodocumento()));
        invoice.setInvoiceDate(TimeDateUtils.getXMLGregorianCalendar((String)ATMessageFormatter.getInvoiceDate(documento.getDatacriacao())));
        invoice.setGrossTotal(documento.getTotalbruto());
        invoice.setCalculatedTaxes(this.createCalculatedTaxes(documento));
        invoice.setRefundableAmount(documento.getTotaliva());
        invoice.setInvoiceLinesList(this.createInvoiceLinesList(documento));
        return invoice;
    }

    private InvoiceIdentifiersType createInvoiceIdentifiers(Entidadesdocumentos documento) {
        InvoiceIdentifiersType identifiers = new InvoiceIdentifiersType();
        identifiers.setInvoiceNo(documento.toString());
        identifiers.setHashTermination(documento.getHashCheckdigits());
        return identifiers;
    }

    private String getInvoiceType(Documentostipos tipodocumento) {
        switch (tipodocumento.getTipodocumentosaft()) {
            case 1: {
                return "FT";
            }
            case 2: {
                return "FS";
            }
            case 3: {
                return "FR";
            }
            case 5: {
                return "NC";
            }
            case 4: {
                return "ND";
            }
        }
        return null;
    }

    private CalculatedTaxesType createCalculatedTaxes(Entidadesdocumentos documento) {
        CalculatedTaxesType taxes = new CalculatedTaxesType();
        for (Entidadesdocumentosivas linha : documento.getTabelaiva()) {
            CalculatedTaxType tax = new CalculatedTaxType();
            tax.setTaxPercentage(linha.getTaxa());
            tax.setTaxAmount(linha.getTotal());
            taxes.getCalculatedTax().add(tax);
        }
        return taxes;
    }

    private InvoiceLinesListType createInvoiceLinesList(Entidadesdocumentos documento) {
        InvoiceLinesListType invoiceLines = new InvoiceLinesListType();
        for (Entidadesdocumentoslinhas linha : documento.getLinhasdocumento$Tipo(1)) {
            InvoiceLineType line = new InvoiceLineType();
            invoiceLines.getInvoiceLine().add(line);
            line.setProductClass(this.getProductClass(linha.getArtigo()));
            line.setProductDescription(linha.getDescricao());
            line.setQuantity(linha.getQuantidade());
            BigDecimal valorliquido = BusinessRules.netValue((BigDecimal)linha.getValorliquido(), (BigDecimal)documento.getPercdesconto());
            line.setTaxBaseTotal(valorliquido);
        }
        return invoiceLines;
    }

    private String getProductClass(Artigos artigo) {
        return "ALI";
    }
}

