/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.services.at.facturas.v2012;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.TreeMap;
import org.dma.java.math.BusinessRules;
import org.dma.java.util.Debug;
import org.dma.java.util.TimeDateUtils;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.model.Codigosiva;
import org.projectocolibri.api.database.model.Entidadesdocumentos;
import org.projectocolibri.api.database.model.Entidadesdocumentoslinhas;
import org.projectocolibri.xml.beans.saft.ATMessageFormatter;
import pt.gov.portaldasfinancas.servicos.faturas.InternationalCustomerTaxID;
import pt.gov.portaldasfinancas.servicos.faturas.RegisterInvoiceType;
import pt.gov.portaldasfinancas.servicos.faturas.Tax;

@Deprecated
public class RegisterInvoiceType
extends pt.gov.portaldasfinancas.servicos.faturas.RegisterInvoiceType {
    public RegisterInvoiceType(Entidadesdocumentos documento) {
        this.setTaxRegistrationNumber(documento.getManager().getEmpresa().getNifToInteger());
        this.setInvoiceNo(documento.toString());
        this.setInvoiceDate(TimeDateUtils.getXMLGregorianCalendar((String)ATMessageFormatter.getInvoiceDate(documento.getDatacriacao())));
        this.setInvoiceType(this.getInvoiceType(documento));
        this.setInvoiceStatus(this.getInvoiceStatus(documento));
        if (documento.getEntidade().getPais().isPortugal()) {
            this.setCustomerTaxID(documento.getNifToInteger());
        } else {
            this.setInternationalCustomerTaxID(this.createInternationalCustomerTaxID(documento));
        }
        this.getLine().addAll(this.createLines(documento));
        this.setDocumentTotals(this.createDocumentTotals(documento));
    }

    private String getInvoiceType(Entidadesdocumentos documento) {
        switch (documento.getTipodocumento().getTipodocumentosaft()) {
            case 1: {
                return "FT";
            }
            case 2: {
                return "FS";
            }
            case 3: {
                return "FR";
            }
            case 4: {
                return "ND";
            }
            case 5: {
                return "NC";
            }
        }
        return null;
    }

    private String getInvoiceStatus(Entidadesdocumentos documento) {
        switch (documento.getEstado()) {
            case 0: 
            case 2: {
                return "N";
            }
            case 1: {
                return "A";
            }
        }
        return null;
    }

    private InternationalCustomerTaxID createInternationalCustomerTaxID(Entidadesdocumentos documento) {
        InternationalCustomerTaxID internationalCustomerTaxID = new InternationalCustomerTaxID();
        internationalCustomerTaxID.setTaxIDNumber(documento.getNifParsed());
        internationalCustomerTaxID.setTaxIDCountry(documento.getEntidade().getPais().getCodigo());
        return internationalCustomerTaxID;
    }

    private RegisterInvoiceType.DocumentTotals createDocumentTotals(Entidadesdocumentos documento) {
        RegisterInvoiceType.DocumentTotals documentTotals = new RegisterInvoiceType.DocumentTotals();
        documentTotals.setTaxPayable(ATMessageFormatter.getGrossTotal(documento.getTotaliva().abs()));
        documentTotals.setNetTotal(ATMessageFormatter.getGrossTotal(documento.getTotalliquido().abs()));
        documentTotals.setGrossTotal(ATMessageFormatter.getGrossTotal(documento.getTotalbruto().abs()));
        return documentTotals;
    }

    private Collection<RegisterInvoiceType.Line> createLines(Entidadesdocumentos documento) {
        TreeMap<String, RegisterInvoiceType.Line> map = new TreeMap<String, RegisterInvoiceType.Line>();
        for (Entidadesdocumentoslinhas linha : documento.getLinhasdocumento$Tipo(1)) {
            RegisterInvoiceType.Line line = this.createLines(linha);
            String key = String.valueOf(linha.getCodigoiva().getCodigo()) + (line.getTaxExemptionReason() == null ? "" : line.getTaxExemptionReason());
            Debug.out((String)"key", (Object)key);
            RegisterInvoiceType.Line value = map.put(key, line);
            if (value == null) continue;
            if (value.getDebitAmount() != null) {
                line.setDebitAmount(line.getDebitAmount().add(value.getDebitAmount()));
            }
            if (value.getCreditAmount() == null) continue;
            line.setCreditAmount(line.getCreditAmount().add(value.getCreditAmount()));
        }
        for (RegisterInvoiceType.Line line : map.values()) {
            if (line.getDebitAmount() != null) {
                BigDecimal debitAmount = BusinessRules.netValue((BigDecimal)line.getDebitAmount(), (BigDecimal)documento.getPercdesconto());
                line.setDebitAmount(FIELDS.entidadesdocumentoslinhas_valorliquido.format.setScale(debitAmount, RoundingMode.HALF_EVEN));
            }
            if (line.getCreditAmount() == null) continue;
            BigDecimal creditAmount = BusinessRules.netValue((BigDecimal)line.getCreditAmount(), (BigDecimal)documento.getPercdesconto());
            line.setCreditAmount(FIELDS.entidadesdocumentoslinhas_valorliquido.format.setScale(creditAmount, RoundingMode.HALF_EVEN));
        }
        return map.values();
    }

    private RegisterInvoiceType.Line createLines(Entidadesdocumentoslinhas linha) {
        RegisterInvoiceType.Line line = new RegisterInvoiceType.Line();
        if (linha.getDocumento().getTipodocumento().isTipodocumentosaft(5)) {
            line.setDebitAmount(linha.getValorliquido());
        } else {
            line.setCreditAmount(linha.getValorliquido());
        }
        line.setTax(this.createTax(linha.getCodigoiva()));
        if (!linha.getCodigoiva().hasTaxa()) {
            line.setTaxExemptionReason(linha.getIsencaoiva().getMotivoAT().name());
        }
        return line;
    }

    private Tax createTax(Codigosiva codigoiva) {
        Tax tax = new Tax();
        tax.setTaxType("IVA");
        tax.setTaxCountryRegion(this.getTaxCountryRegion(codigoiva));
        tax.setTaxPercentage(codigoiva.getTaxa());
        return tax;
    }

    private String getTaxCountryRegion(Codigosiva codigoiva) {
        switch (codigoiva.getEspacofiscal()) {
            case 0: 
            case 3: {
                return "PT";
            }
            case 1: {
                return "PT-MA";
            }
            case 2: {
                return "PT-AC";
            }
        }
        return null;
    }
}

