/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.update.templates;

import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.projectocolibri.api.birt.design.BIRTDesignHelper;
import org.projectocolibri.api.birt.design.BIRTParametersMap;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.update.templates.DesignUpdate;
import org.projectocolibri.api.database.update.templates.TemplatesUpdate;

public class Version80to90
extends TemplatesUpdate {
    public Version80to90(DatabaseManager manager) {
        super(manager);
    }

    @Override
    public void run(DesignUpdate update) throws Exception {
        if (update.getTemplate().getTabela() == 5) {
            this.updateExtenso(update.getDesign(), update.getTemplate().getTipo());
            this.updateCodigoPostal(update.getDesign(), update.getTemplate().getTipo());
        }
    }

    private void updateExtenso(ReportDesignHandle design, int reportType) throws Exception {
        DataItemHandle dataItem = BIRTDesignHelper.findSlotColumn(design.getBody(), "d1-11");
        if (dataItem != null) {
            CellHandle cellHandle = (CellHandle)dataItem.getContainer();
            cellHandle.clearContents(0);
            cellHandle.getContent().add((DesignElementHandle)BIRTDesignHelper.createDataItemColumn(design, reportType, BIRTParametersMap.PARAMETERS_TYPES.written_total));
        }
    }

    private void updateCodigoPostal(ReportDesignHandle design, int reportType) throws Exception {
        DataItemHandle dataItem = BIRTDesignHelper.findSlotColumn(design.getBody(), "d1-52");
        if (dataItem != null) {
            CellHandle cellHandle = (CellHandle)dataItem.getContainer();
            cellHandle.clearContents(0);
            String expression = "dataSetRow[\"d1-52\"] + \" \" + dataSetRow[\"d1-20\"]";
            cellHandle.getContent().add((DesignElementHandle)BIRTDesignHelper.createDataItemColumn(design, FIELDS.codigospostais_codigo.name, FIELDS.codigospostais_codigo.type, expression));
        }
    }
}

