/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.update.templates;

import java.util.Iterator;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.HideRule;
import org.projectocolibri.api.birt.design.BIRTDesignHelper;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.update.templates.DesignUpdate;
import org.projectocolibri.api.database.update.templates.TemplatesUpdate;

public class Version63to70
extends TemplatesUpdate {
    public Version63to70(DatabaseManager manager) {
        super(manager);
    }

    @Override
    public void run(DesignUpdate update) throws Exception {
        if (update.getTemplate().getTabela() == 5) {
            this.updateDataBinding(update.getDesign());
        }
    }

    private void updateDataBinding(ReportDesignHandle design) throws Exception {
        for (DesignElementHandle elementHandle : design.getBody()) {
            if (!(elementHandle instanceof TableHandle)) continue;
            TableHandle tableHandle = (TableHandle)elementHandle;
            int rowNumber = 0;
            while (rowNumber < tableHandle.getDetail().getCount()) {
                RowHandle rowHandle = (RowHandle)tableHandle.getDetail().get(rowNumber);
                int columnNumber = 0;
                while (columnNumber < tableHandle.getColumnCount()) {
                    CellHandle cellHandle = (CellHandle)rowHandle.getCells().get(columnNumber);
                    if (cellHandle != null) {
                        for (DesignElementHandle cellElementHandle : cellHandle.getContent()) {
                            if (!(cellElementHandle instanceof TableHandle)) continue;
                            TableHandle cellTableHandle = (TableHandle)cellElementHandle;
                            this.updateCellBinding(cellTableHandle);
                        }
                    }
                    ++columnNumber;
                }
                ++rowNumber;
            }
        }
    }

    private void updateCellBinding(TableHandle tableHandle) throws Exception {
        Iterator iterator = tableHandle.getAvailableBindings();
        while (iterator.hasNext()) {
            ComputedColumnHandle column = (ComputedColumnHandle)iterator.next();
            if (column.getExpression() == null || !column.getExpression().contains("empty")) continue;
            column.setExpression("dataSetRow[\"" + column.getName() + "\"]");
            if (!column.getName().equals("d2-67") && !column.getName().equals("d2-19") && !column.getName().equals("d2-17") && !column.getName().equals("d2-14") && !column.getName().equals("d2-21")) continue;
            column.setExpression("dataSetRow[\"" + column.getName() + "\"]");
        }
        DataItemHandle dataItem_d2_19 = BIRTDesignHelper.findSlotColumn(tableHandle.getDetail(), "d2-19");
        int rowNumber = 0;
        while (rowNumber < tableHandle.getDetail().getCount()) {
            RowHandle rowHandle = (RowHandle)tableHandle.getDetail().get(rowNumber);
            int columnNumber = 0;
            while (columnNumber < tableHandle.getColumnCount()) {
                CellHandle cellHandle = (CellHandle)rowHandle.getCells().get(columnNumber);
                if (cellHandle != null) {
                    for (DesignElementHandle cellElementHandle : cellHandle.getContent()) {
                        HideRule hideRule;
                        if (!(cellElementHandle instanceof DataItemHandle)) continue;
                        DataItemHandle dataItem = (DataItemHandle)cellElementHandle;
                        if (dataItem.getResultSetColumn().equals("d2-12") || dataItem.getResultSetColumn().equals("d2-4") && !dataItem.getResultSetColumn().equals("d2-37")) {
                            dataItem.getPropertyHandle("visibility").clearValue();
                            hideRule = StructureFactory.createHideRule();
                            hideRule.setFormat("all");
                            hideRule.setExpression("true");
                            dataItem.getPropertyHandle("visibility").addItem((IStructure)hideRule);
                        }
                        if (dataItem_d2_19 == null) continue;
                        if (dataItem.getResultSetColumn().equals("d2-4") || dataItem.getResultSetColumn().equals("d2-37")) {
                            dataItem.getPropertyHandle("visibility").clearValue();
                            hideRule = StructureFactory.createHideRule();
                            hideRule.setFormat("all");
                            hideRule.setExpression("false");
                            dataItem.getPropertyHandle("visibility").addItem((IStructure)hideRule);
                            continue;
                        }
                        if (dataItem.getResultSetColumn().equals("d2-12")) continue;
                        dataItem.getPropertyHandle("visibility").clearValue();
                        hideRule = StructureFactory.createHideRule();
                        hideRule.setFormat("all");
                        hideRule.setExpression("if (row[\"d2-19\"] > 0){ false }else{ true }");
                        dataItem.getPropertyHandle("visibility").addItem((IStructure)hideRule);
                    }
                }
                ++columnNumber;
            }
            ++rowNumber;
        }
    }
}

