/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.update.templates;

import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.update.templates.DesignUpdate;
import org.projectocolibri.api.database.update.templates.TemplatesUpdate;

public class Version62to63
extends TemplatesUpdate {
    public Version62to63(DatabaseManager manager) {
        super(manager);
    }

    @Override
    public void run(DesignUpdate update) throws Exception {
        this.updateGridAlignment(update.getDesign(), "left");
    }

    private void updateGridAlignment(ReportDesignHandle design, String textAlign) throws Exception {
        SharedStyleHandle sharedStyleHandle = design.getElementFactory().newStyle(textAlign);
        sharedStyleHandle.setTextAlign(textAlign);
        design.getStyles().add((DesignElementHandle)sharedStyleHandle);
        for (DesignElementHandle elementHandle : design.getBody()) {
            if (!(elementHandle instanceof TableHandle)) continue;
            TableHandle tableHandle = (TableHandle)elementHandle;
            int rowNumber = 0;
            while (rowNumber < tableHandle.getHeader().getCount()) {
                RowHandle rowHandle = (RowHandle)tableHandle.getHeader().get(rowNumber);
                int columnNumber = 0;
                while (columnNumber < tableHandle.getColumnCount()) {
                    CellHandle cellHandle = (CellHandle)rowHandle.getCells().get(columnNumber);
                    if (cellHandle != null) {
                        for (DesignElementHandle cellElementHandle : cellHandle.getContent()) {
                            if (!(cellElementHandle instanceof GridHandle)) continue;
                            GridHandle cellGridHandle = (GridHandle)cellElementHandle;
                            cellGridHandle.setStyle(sharedStyleHandle);
                        }
                    }
                    ++columnNumber;
                }
                ++rowNumber;
            }
        }
    }
}

