/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.update.tables;

import java.math.BigDecimal;
import java.sql.Time;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.Artigosprecos;
import org.projectocolibri.api.database.model.Contasbancarias;
import org.projectocolibri.api.database.model.Documentostipos;
import org.projectocolibri.api.database.model.Empresa;
import org.projectocolibri.api.database.model.Entidades;
import org.projectocolibri.api.database.model.Entidadesdocumentos;
import org.projectocolibri.api.database.model.Entidadesmovimentos;
import org.projectocolibri.api.database.model.Layouts;
import org.projectocolibri.api.database.model.Parametros;
import org.projectocolibri.api.database.model.Pesquisas;
import org.projectocolibri.api.database.model.Utilizadores;
import org.projectocolibri.api.database.model.Vendedores;
import org.projectocolibri.api.database.query.TransactionalQuery;
import org.projectocolibri.api.database.update.tables.AbstractUpdate;

public final class Version80to90
extends AbstractUpdate {
    public Version80to90(DatabaseManager manager) {
        super(manager);
    }

    public void run(IProgressMonitor monitor) throws Exception {
        this.populate(TABLES.isencoesiva);
        this.populate(TABLES.condicoespagamento);
        new TransactionalQuery<Vendedores>(TABLES.vendedores, this.manager){

            @Override
            public void process(Vendedores model) throws Exception {
                model.setComissao(BigDecimal.ZERO);
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Layouts>(TABLES.layouts, this.manager){
            final Collection<String> list;
            {
                this.list = Arrays.asList("202", "302", "602", "702");
            }

            @Override
            public void process(Layouts model) throws Exception {
                if (this.list.contains(model.getCodigo())) {
                    this.delete(model);
                }
            }
        }.executeTryCatch();
        this.populate(TABLES.layouts);
        new TransactionalQuery<Pesquisas>(TABLES.pesquisas, this.manager){
            final Collection<String> list;
            {
                this.list = Arrays.asList("611");
            }

            @Override
            public void process(Pesquisas model) throws Exception {
                if (this.list.contains(model.getCodigo())) {
                    this.delete(model);
                }
            }
        }.executeTryCatch();
        this.populate(TABLES.pesquisas);
        new TransactionalQuery<Documentostipos>(TABLES.documentostipos, this.manager){

            @Override
            public void process(Documentostipos model) throws Exception {
                model.setTitulo(model.isTipodocumentosaft(0) ? model.getDescricao() : model.getTipodocumentosaftToText());
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Empresa>(TABLES.empresa, this.manager){

            @Override
            public void process(Empresa model) throws Exception {
                if (model.getCodigopostal() != null) {
                    model.setLocalidade(model.getCodigopostal().getDescricao());
                }
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Parametros>(TABLES.parametros, this.manager){
            Contasbancarias contabancaria;
            {
                this.contabancaria = this.manager.loadContasbancarias();
            }

            @Override
            public void process(Parametros model) throws Exception {
                if (model.getContabancaria() == null) {
                    model.setContabancaria(this.contabancaria);
                }
                model.setAtwebservice(0);
                model.setAtutilizador(Utilizadores.USERS.FISCO.user);
                model.setAtpassword(Utilizadores.USERS.FISCO.password);
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Artigosprecos>(TABLES.artigosprecos, this.manager){
            Collection<String> col;
            {
                this.col = new LinkedHashSet<String>();
            }

            @Override
            public void process(Artigosprecos model) throws Exception {
                Artigosprecos clone = model.cloneCopy();
                this.delete(model);
                clone.setCascade(false);
                String key = String.valueOf(clone.getArtigo().getCodigo()) + ":" + clone.getPrecario().getCodigo() + ":" + clone.getTamanho().getCodigo() + ":" + clone.getCor().getCodigo();
                if (!clone.getKey().equals(key) && this.col.add(key)) {
                    clone.setKey(key);
                    this.store(clone);
                }
            }
        }.execute();
        new TransactionalQuery<Entidades>(TABLES.entidades, this.manager){

            @Override
            public void process(Entidades model) throws Exception {
                if (model.getCodigopostal() != null) {
                    model.setLocalidade(model.getCodigopostal().getDescricao());
                }
                if (model.getPais().isPortugal() && model.getNifToText().isEmpty()) {
                    model.setNif("999999990");
                }
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Entidadesdocumentos>(TABLES.entidadesdocumentos, this.manager){

            @Override
            public void process(Entidadesdocumentos model) throws Exception {
                model.setTotalliquido(model.getTotaliliquido().subtract(model.getTotaldesconto()));
                model.setEstadoenvio(0);
                model.setHashcontrol(model.getHashcontrol() == null ? 0 : 2);
                model.setHorasistema(new Time(model.getHoracriacao().getTime()));
                if (model.getCodigopostal() == null) {
                    model.setCodigopostal(model.getEntidade().getCodigopostal());
                }
                model.setLocalidade(model.getCodigopostal().getDescricao());
                if (model.getPais() == null) {
                    model.setPais(model.getEntidade().getPais());
                }
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Entidadesmovimentos>(TABLES.entidadesmovimentos, this.manager){

            @Override
            public void process(Entidadesmovimentos model) throws Exception {
                model.setTotalliquido(model.getTotaliliquido().subtract(model.getTotaldesconto()));
                BigDecimal valorfacturado = BigDecimal.ZERO;
                BigDecimal valordevolvido = BigDecimal.ZERO;
                switch (model.getTipodocumento().getTipodocumento()) {
                    case 1: 
                    case 3: {
                        valorfacturado = model.getTotalliquido();
                        break;
                    }
                    case 4: {
                        valordevolvido = model.getTotalliquido();
                    }
                }
                model.setValorfacturado(valorfacturado);
                model.setValordevolvido(valordevolvido);
                this.store(model);
            }
        }.execute();
    }
}

