/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.update.tables;

import java.io.File;
import org.dma.java.util.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.Artigosmovimentos;
import org.projectocolibri.api.database.model.Artigosprecos;
import org.projectocolibri.api.database.model.Documentostipos;
import org.projectocolibri.api.database.model.Empresa;
import org.projectocolibri.api.database.model.Entidades;
import org.projectocolibri.api.database.model.Entidadesmovimentos;
import org.projectocolibri.api.database.model.Layouts;
import org.projectocolibri.api.database.model.Parametros;
import org.projectocolibri.api.database.model.Pesquisas;
import org.projectocolibri.api.database.model.Precarios;
import org.projectocolibri.api.database.model.Templates;
import org.projectocolibri.api.database.query.TransactionalQuery;
import org.projectocolibri.api.database.update.tables.AbstractUpdate;
import org.projectocolibri.api.language.LABELS;

public final class Version51to52
extends AbstractUpdate {
    public Version51to52(DatabaseManager manager) {
        super(manager);
    }

    public void run(IProgressMonitor monitor) throws Exception {
        new TransactionalQuery<Layouts>(TABLES.layouts, this.manager){

            @Override
            public void process(Layouts model) throws Exception {
                if (model.equals(Layouts.RECORDS.entidadesdocumentoslinhas_recibo.codigo)) {
                    model.setLayout(Layouts.RECORDS.entidadesdocumentoslinhas_recibo.array);
                    this.store(model);
                }
            }
        }.execute();
        new TransactionalQuery<Pesquisas>(TABLES.pesquisas, this.manager){

            @Override
            public void process(Pesquisas model) throws Exception {
                this.delete(model);
            }
        }.executeTryCatch();
        new TransactionalQuery<Templates>(TABLES.templates, this.manager){

            @Override
            public void process(Templates model) throws Exception {
                if (model.getCodigo().startsWith("6")) {
                    this.delete(model);
                } else if (model.getCodigo().startsWith("3") || model.getCodigo().startsWith("7")) {
                    model.setTipo(0);
                    this.store(model);
                } else {
                    model.importDesign((File)Colibri.FOLDERS.POPULATE_TEMPLATES.folder, Colibri.FILES.TEMPLATES.parameters.wildcards, false);
                    model.setTipo(1);
                    this.store(model);
                }
            }
        }.executeTryCatch();
        this.populate(TABLES.templates);
        new TransactionalQuery<Precarios>(TABLES.precarios, this.manager){

            @Override
            public void process(Precarios model) throws Exception {
                if (model.equals("001")) {
                    model.setDescricao(String.valueOf(LABELS.artigosmovimentos_preco.toString()) + " 1");
                    this.store(model);
                }
            }
        }.execute();
        new TransactionalQuery<Documentostipos>(TABLES.documentostipos, this.manager){

            @Override
            public void process(Documentostipos model) throws Exception {
                if (model.getTipodocumento() == null) {
                    if (model.isTabela(0)) {
                        model.setTipodocumento(0);
                        model.setTipocarregamento(0);
                    } else if (model.isTabela(1)) {
                        if (model.isMovimentaentidades(3)) {
                            model.setTipodocumento(3);
                            if (model.getTipoentidade().isTipoentidade(0)) {
                                model.setMovimentaentidades(1);
                            } else {
                                model.setMovimentaentidades(2);
                            }
                        } else if (model.isTipocarregamento(2)) {
                            model.setTipodocumento(2);
                        } else {
                            model.setTipodocumento(1);
                        }
                        if (model.isMovimentaentidades(0)) {
                            model.setTipocarregamento(0);
                        } else {
                            model.setTipocarregamento(1);
                        }
                    }
                }
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Empresa>(TABLES.empresa, this.manager){

            @Override
            public void process(Empresa model) throws Exception {
                model.setEstabelecimento(this.manager.getLicenca().getNomeTitular());
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Parametros>(TABLES.parametros, this.manager){

            @Override
            public void process(Parametros model) throws Exception {
                model.setPrecocusto(1);
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Artigosprecos>(TABLES.artigosprecos, this.manager){

            @Override
            public void process(Artigosprecos model) throws Exception {
                String codigo = StringUtils.padLeft((String)model.getNumerolinhaToText(), (int)3, (char)'0');
                if (!model.getPrecario().equals(codigo)) {
                    if (!this.manager.existsPrecarios(codigo)) {
                        Precarios precario = new Precarios(this.manager, codigo, String.valueOf(LABELS.artigosmovimentos_preco.toString()) + " " + model.getNumerolinhaToText());
                        this.manager.storePrecarios(precario).throwException();
                    }
                    model.setPrecario(this.manager.loadPrecarios(codigo));
                }
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Artigosmovimentos>(TABLES.artigosmovimentos, this.manager){

            @Override
            public void process(Artigosmovimentos model) throws Exception {
                model.setTipostock(model.getTipodocumento().getStockartigos());
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Entidades>(TABLES.entidades, this.manager){

            @Override
            public void process(Entidades model) throws Exception {
                model.setTipopreco(0);
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Entidadesmovimentos>(TABLES.entidadesmovimentos, this.manager){

            @Override
            public void process(Entidadesmovimentos model) throws Exception {
                model.setTiposaldo(model.getTipodocumento().getSaldoentidades());
                this.store(model);
            }
        }.execute();
    }
}

