/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.update.tables;

import java.io.File;
import org.dma.java.io.CustomFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.manager.tasks.UtilizadoresiconesTask;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.mapper.TableLayout;
import org.projectocolibri.api.database.model.Artigosdocumentos;
import org.projectocolibri.api.database.model.Artigosmovimentos;
import org.projectocolibri.api.database.model.Entidades;
import org.projectocolibri.api.database.model.Entidadesdocumentos;
import org.projectocolibri.api.database.model.Layouts;
import org.projectocolibri.api.database.model.Pesquisas;
import org.projectocolibri.api.database.model.Templates;
import org.projectocolibri.api.database.model.Utilizadores;
import org.projectocolibri.api.database.query.TransactionalQuery;
import org.projectocolibri.api.database.update.tables.AbstractUpdate;
import org.projectocolibri.core.support.PermissionsMap;

public final class Version151to160
extends AbstractUpdate {
    public Version151to160(DatabaseManager manager) {
        super(manager);
    }

    public void run(IProgressMonitor monitor) throws Exception {
        for (Utilizadores utilizador : this.manager.getUtilizadoresCollection()) {
            UtilizadoresiconesTask task = new UtilizadoresiconesTask(this.manager);
            CustomFile file = Colibri.FILES.COOLBAR.getParameters(utilizador.getUser()).toFile();
            task.exportTo(utilizador, (File)file);
            this.manager.deleteUtilizadoresicones$User(utilizador.getUser());
        }
        this.populate(TABLES.utilizadoresicones);
        new TransactionalQuery<Utilizadores>(TABLES.utilizadores, this.manager){

            @Override
            public void process(Utilizadores model) throws Exception {
                PermissionsMap map = new PermissionsMap(model.getPermissoes());
                model.setPermissoes(map);
                model.setChecksum();
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Layouts>(TABLES.layouts, this.manager){

            @Override
            public void process(Layouts model) throws Exception {
                if (model.equals(Layouts.RECORDS.entidadesdocumentoslinhas_recibo.codigo)) {
                    model.setLayout(Layouts.RECORDS.entidadesdocumentoslinhas_recibo.array);
                } else {
                    model.setLayout(new TableLayout(model));
                }
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Pesquisas>(TABLES.pesquisas, this.manager){

            @Override
            public void process(Pesquisas model) throws Exception {
                Pesquisas.RECORDS record = Pesquisas.RECORDS.get(model.getCodigo());
                if (record != null) {
                    model.setFiltro(record.filterMap);
                }
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Templates>(TABLES.templates, this.manager){

            @Override
            public void process(Templates model) throws Exception {
                model.setLayout(new TableLayout(model));
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Artigosmovimentos>(TABLES.artigosmovimentos, this.manager){

            @Override
            public void process(Artigosmovimentos model) throws Exception {
                if (model.getAutor() == null) {
                    switch (model.getTipodocumento().getTabela()) {
                        case 0: {
                            model.setAutor(((Artigosdocumentos)TABLES.artigosdocumentos.getObject(this.pm, Artigosdocumentos.generateKey(model.getTipodocumento().getCodigo(), model.getSeriedocumento().getSerie(), model.getNumerodocumento()))).getAutor());
                            break;
                        }
                        case 1: {
                            model.setAutor(((Entidadesdocumentos)TABLES.entidadesdocumentos.getObject(this.pm, Entidadesdocumentos.generateKey(model.getTipodocumento().getCodigo(), model.getSeriedocumento().getSerie(), model.getNumerodocumento()))).getAutor());
                        }
                    }
                }
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Entidades>(TABLES.entidades, this.manager){

            @Override
            public void process(Entidades model) throws Exception {
                if (model.getMoradas().isEmpty()) {
                    model.addMoradas();
                }
                model.setPais(model.getMoradas(0).getPais());
                this.store(model);
            }
        }.execute();
    }
}

