/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.update.tables;

import org.eclipse.core.runtime.IProgressMonitor;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.filter.FilterMapRule;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.Campos;
import org.projectocolibri.api.database.model.Documentosseries;
import org.projectocolibri.api.database.model.Documentostipos;
import org.projectocolibri.api.database.model.Entidadesdocumentoslinhas;
import org.projectocolibri.api.database.model.Moedas;
import org.projectocolibri.api.database.model.Unidadesmedida;
import org.projectocolibri.api.database.model.Utilizadores;
import org.projectocolibri.api.database.model.Utilizadoreslogs;
import org.projectocolibri.api.database.query.TransactionalQuery;
import org.projectocolibri.api.database.update.tables.AbstractUpdate;
import org.projectocolibri.xml.beans.ciuspt.UBL21Tables;

public final class Version142to150
extends AbstractUpdate {
    public Version142to150(DatabaseManager manager) {
        super(manager);
    }

    public void run(IProgressMonitor monitor) throws Exception {
        new TransactionalQuery<Unidadesmedida>(TABLES.unidadesmedida, this.manager){

            @Override
            public void process(Unidadesmedida model) throws Exception {
                if (model.getUnecerec20() == null) {
                    if (model.equals("KG")) {
                        model.setUnecerec20(UBL21Tables.UNECERec20.KILOGRAM);
                    } else if (model.equals("MT")) {
                        model.setUnecerec20(UBL21Tables.UNECERec20.METRE);
                    } else if (model.equals("LT")) {
                        model.setUnecerec20(UBL21Tables.UNECERec20.LITRE);
                    } else if (model.equals("M2")) {
                        model.setUnecerec20(UBL21Tables.UNECERec20.SQUARE_METRE);
                    } else if (model.equals("M3")) {
                        model.setUnecerec20(UBL21Tables.UNECERec20.CUBIC_METRE);
                    } else if (model.equals("HR")) {
                        model.setUnecerec20(UBL21Tables.UNECERec20.HOUR);
                    } else {
                        model.setUnecerec20(UBL21Tables.UNECERec20.UNIT);
                    }
                }
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Moedas>(TABLES.moedas, this.manager){

            @Override
            public void process(Moedas model) throws Exception {
                if (model.getUnidadeprincipal() == null) {
                    model.setUnidadeprincipal(model.getInteiroplural());
                }
                if (model.getUnidadefraccionaria() == null) {
                    model.setUnidadefraccionaria(model.getDecimaisplural());
                }
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Campos>(TABLES.campos, this.manager){

            @Override
            public void process(Campos model) throws Exception {
                if (model.getCiusid() == null) {
                    model.setCiusid(0);
                    model.setCiusname("");
                }
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Documentosseries>(TABLES.documentosseries, this.manager){

            @Override
            public void process(Documentosseries model) throws Exception {
                if (model.getCodigovalidacao() == null) {
                    model.setCodigovalidacao("");
                }
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Utilizadoreslogs>(TABLES.utilizadoreslogs, this.manager){

            @Override
            public void process(Utilizadoreslogs model) throws Exception {
                Utilizadores.COMMANDS command = Utilizadores.COMMANDS.get(model.getDescricao());
                if (command != null) {
                    model.setDescricao(null);
                    model.setComando(command);
                }
                this.store(model);
            }
        }.execute();
        for (Documentostipos tipodocumento : this.manager.getDocumentostiposCollection(1)) {
            if (!tipodocumento.isTipodocumento(2)) continue;
            TransactionalQuery<Entidadesdocumentoslinhas> query = new TransactionalQuery<Entidadesdocumentoslinhas>(TABLES.entidadesdocumentoslinhas, this.manager){

                @Override
                public void process(Entidadesdocumentoslinhas model) throws Exception {
                    if (model.getMovimentoorigem() != null) {
                        model.setTipo(1);
                    }
                    this.store(model);
                }
            };
            query.addRule(new FilterMapRule(FIELDS.entidadesdocumentoslinhas_key).startsWith(tipodocumento.getCodigo()));
            query.execute();
        }
    }
}

