/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.update.tables;

import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.filter.FilterMapRule;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.mapper.TableFieldKey;
import org.projectocolibri.api.database.mapper.TableLayout;
import org.projectocolibri.api.database.model.Artigosmovimentos;
import org.projectocolibri.api.database.model.Entidadesartigos;
import org.projectocolibri.api.database.model.Entidadesdocumentos;
import org.projectocolibri.api.database.model.Entidadesdocumentoslinhas;
import org.projectocolibri.api.database.model.Layouts;
import org.projectocolibri.api.database.model.Pesquisas;
import org.projectocolibri.api.database.model.Templates;
import org.projectocolibri.api.database.query.TransactionalQuery;
import org.projectocolibri.api.database.update.tables.AbstractUpdate;

public final class Version141to142
extends AbstractUpdate {
    public Version141to142(DatabaseManager manager) {
        super(manager);
    }

    public void run(IProgressMonitor monitor) throws Exception {
        TransactionalQuery query = new TransactionalQuery<Layouts>(TABLES.layouts, this.manager){

            @Override
            public void process(Layouts model) throws Exception {
                Layouts.RECORDS record = Layouts.RECORDS.get(model.getCodigo());
                if (record != null) {
                    model.setLayout(record.array);
                }
                this.store(model);
            }
        };
        query.addRule(new FilterMapRule(FIELDS.layouts_tabela).equal(1));
        query.execute();
        query = new TransactionalQuery<Pesquisas>(TABLES.pesquisas, this.manager){

            @Override
            public void process(Pesquisas model) throws Exception {
                Pesquisas.RECORDS record = Pesquisas.RECORDS.get(model.getCodigo());
                if (record != null) {
                    model.setFiltro(record.filterMap);
                }
                this.store(model);
            }
        };
        query.addRule(new FilterMapRule(FIELDS.pesquisas_tabela).equal(1));
        query.execute();
        new TransactionalQuery<Templates>(TABLES.templates, this.manager){

            @Override
            public void process(Templates model) throws Exception {
                if (model.isTabela(1) && model.getTipo() == 2) {
                    ArrayList<TableFieldKey> list = new ArrayList<TableFieldKey>(model.getLayoutArray());
                    list.add(0, new TableFieldKey(FIELDS.artigosmovimentos_datadocumento));
                    model.setLayout(new TableLayout(TABLES.artigosmovimentos, list));
                }
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Artigosmovimentos>(TABLES.artigosmovimentos, this.manager){

            @Override
            public void process(Artigosmovimentos model) throws Exception {
                if (model.getDatadocumento() == null) {
                    if (model.getLinhaorigem() != null) {
                        Entidadesdocumentos documento = model.getLinhaorigem().getDocumento();
                        documento.setManager(this.manager);
                        model.setDatadocumento(new Date(documento.getDatadocumento().getTime()));
                    } else {
                        model.setDatadocumento(new Date(model.getDatacriacao().getTime()));
                    }
                }
                model.clearDeprecated();
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Entidadesartigos>(TABLES.entidadesartigos, this.manager){

            @Override
            public void process(Entidadesartigos model) throws Exception {
                if (model.getDatadocumento() == null) {
                    model.setDatadocumento(new Date(model.getDatacriacao().getTime()));
                }
                model.clearDeprecated();
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Entidadesdocumentoslinhas>(TABLES.entidadesdocumentoslinhas, this.manager){

            @Override
            public void process(Entidadesdocumentoslinhas model) throws Exception {
                if (model.getMovimentoorigem() != null) {
                    Entidadesdocumentos documento = model.getMovimentoorigem().getDocumento();
                    documento.setManager(this.manager);
                    model.setDatadocumento(new Date(documento.getDatadocumento().getTime()));
                } else if (model.getMovimentoorigem2() != null) {
                    model.setDatadocumento(new Date(model.getMovimentoorigem2().getDatadocumento().getTime()));
                }
                this.store(model);
            }
        }.execute();
    }
}

