/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.update.tables;

import org.eclipse.core.runtime.IProgressMonitor;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.mapper.TableLayout;
import org.projectocolibri.api.database.model.Campos;
import org.projectocolibri.api.database.model.Documentostipos;
import org.projectocolibri.api.database.model.Entidadesdocumentoslinhas;
import org.projectocolibri.api.database.model.Parametros;
import org.projectocolibri.api.database.model.Parametrospos;
import org.projectocolibri.api.database.model.Templates;
import org.projectocolibri.api.database.query.TransactionalQuery;
import org.projectocolibri.api.database.update.tables.AbstractUpdate;

public final class Version113to120
extends AbstractUpdate {
    public Version113to120(DatabaseManager manager) {
        super(manager);
    }

    public void run(IProgressMonitor monitor) throws Exception {
        new TransactionalQuery<Campos>(TABLES.campos, this.manager){

            @Override
            public void process(Campos model) throws Exception {
                Campos clone = model.cloneCopy();
                if (model.getCodigo().startsWith("DL")) {
                    clone = new Campos(this.manager, model.getDescricao(), 5, Integer.valueOf(model.getCodigo().substring(2)));
                } else if (model.getCodigo().startsWith("D")) {
                    clone = new Campos(this.manager, model.getDescricao(), 4, Integer.valueOf(model.getCodigo().substring(1)));
                } else if (model.getCodigo().startsWith("E")) {
                    clone = new Campos(this.manager, model.getDescricao(), 3, Integer.valueOf(model.getCodigo().substring(1)));
                } else if (model.getCodigo().startsWith("A")) {
                    clone = new Campos(this.manager, model.getDescricao(), 0, Integer.valueOf(model.getCodigo().substring(1)));
                }
                if (!model.equals(clone)) {
                    this.delete(model);
                    this.store(clone);
                }
            }
        }.execute();
        new TransactionalQuery<Templates>(TABLES.templates, this.manager){

            @Override
            public void process(Templates model) throws Exception {
                model.setLayout(new TableLayout(model));
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Documentostipos>(TABLES.documentostipos, this.manager){

            @Override
            public void process(Documentostipos model) throws Exception {
                if (model.getCodigo().equals("CND") || model.getCodigo().equals("CNC") || model.getCodigo().equals("FND") || model.getCodigo().equals("FNC") || model.isTipodocumentosaft(4) || model.isTipodocumentosaft(5)) {
                    model.setTipodocumento(4);
                }
                switch (model.getTipodocumentosaft()) {
                    case 16: {
                        model.setTipodocumentosaft(24);
                        break;
                    }
                    case 17: {
                        model.setTipodocumentosaft(25);
                        break;
                    }
                    case 18: {
                        model.setTipodocumentosaft(26);
                    }
                }
                if (model.getCodigo().equals("CEN")) {
                    model.setTipodocumentosaft(20);
                }
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Parametros>(TABLES.parametros, this.manager){

            @Override
            public void process(Parametros model) throws Exception {
                model.setDecimaisprecos(6);
                if (model.getMbchavebackoffice() == null) {
                    model.setMbchavebackoffice("0000-0000-0000-0000");
                    if (model.getAtwebservice() == 1) {
                        model.setAtwebservice(2);
                    } else if (model.getAtwebservice() == 2) {
                        model.setAtwebservice(1);
                    }
                }
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Parametrospos>(TABLES.parametrospos, this.manager){

            @Override
            public void process(Parametrospos model) throws Exception {
                model.setBotao1parametro1(500);
                model.setBotao2parametro1(1000);
                model.setBotao3parametro1(1000);
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Entidadesdocumentoslinhas>(TABLES.entidadesdocumentoslinhas, this.manager){

            @Override
            public void process(Entidadesdocumentoslinhas model) throws Exception {
                if (model.getLinhaorigem() != null && model.getLinhaorigem().getMovimentoartigos() != null) {
                    model.setMovimentoorigem2(model.getLinhaorigem().getMovimentoartigos());
                }
                this.store(model);
            }
        }.execute();
    }
}

