/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.update.tables;

import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.Artigosmovimentos;
import org.projectocolibri.api.database.model.Entidadesdocumentos;
import org.projectocolibri.api.database.model.Entidadesdocumentosentregas;
import org.projectocolibri.api.database.model.Entidadesdocumentoslinhas;
import org.projectocolibri.api.database.model.Parametros;
import org.projectocolibri.api.database.query.TransactionalQuery;
import org.projectocolibri.api.database.update.tables.AbstractUpdate;

public final class Version102to110
extends AbstractUpdate {
    public Version102to110(DatabaseManager manager) {
        super(manager);
    }

    public void run(IProgressMonitor monitor) throws Exception {
        new TransactionalQuery<Parametros>(TABLES.parametros, this.manager){

            @Override
            public void process(Parametros model) throws Exception {
                if (model.getMetodopagamento() == null) {
                    model.setMetodopagamento(this.manager.loadMetodospagamento());
                }
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Artigosmovimentos>(TABLES.artigosmovimentos, this.manager){

            @Override
            public void process(Artigosmovimentos model) throws Exception {
                if (model.getNumeroauxiliar() == null) {
                    model.setNumeroauxiliar("");
                }
                if (model.getLinhaorigem() == null) {
                    Entidadesdocumentoslinhas linha = (Entidadesdocumentoslinhas)TABLES.entidadesdocumentoslinhas.getObjectOrNull(this.pm, Entidadesdocumentoslinhas.generateKey(Entidadesdocumentos.generateKey(model.getTipodocumento().getCodigo(), model.getSeriedocumento().getSerie(), model.getNumerodocumento()), model.getNumerolinha()));
                    model.setLinhaorigem(linha);
                }
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Entidadesdocumentos>(TABLES.entidadesdocumentos, this.manager){

            @Override
            public void process(Entidadesdocumentos model) throws Exception {
                if (model.getEntregaspagamento().isEmpty() && !model.getTipodocumento().isMovimentabancos(0)) {
                    model.addEntregaspagamento();
                }
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Entidadesdocumentosentregas>(TABLES.entidadesdocumentosentregas, this.manager){

            @Override
            public void process(Entidadesdocumentosentregas model) throws Exception {
                if (model.getContabancaria() == null) {
                    model.setContabancaria(this.manager.getParametros().getContabancaria());
                }
                if (model.getDataprocessamento() == null) {
                    model.setDataprocessamento(new Date(model.getDocumento().getDatacriacao().getTime()));
                }
                if (model.getMovimentabanco() == null) {
                    model.setMovimentabanco(model.getDocumento().getTipodocumento().getMovimentabancos());
                }
                if (model.getEstadoprocessamento() == null) {
                    model.setEstadoprocessamento(0);
                }
                this.store(model);
            }
        }.execute();
    }
}

