/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.query.builder;

import java.util.ArrayList;
import org.projectocolibri.api.database.filter.FilterFieldMap;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.mapper.TableFieldKey;
import org.projectocolibri.api.database.query.builder.QueryFieldMap;
import org.projectocolibri.api.database.query.builder.QueryParametersMap;

public class QuerySetTableMap
extends ArrayList<QueryFieldMap> {
    private static final long serialVersionUID = 1L;
    private final QueryParametersMap parametersMap = new QueryParametersMap();
    private final TABLES table;
    private final String varName;
    private final String condition;

    public QueryParametersMap getParametersMap() {
        return this.parametersMap;
    }

    public QuerySetTableMap(TABLES table, TableFieldKey fieldKey) {
        this.table = table;
        TABLES rootTable = table.map.get((TableFieldKey)fieldKey.root()).field.childTable;
        this.varName = String.valueOf(rootTable.varName()) + "_" + (String)fieldKey.get(1);
        this.parametersMap.addVariable(table.map.get((TableFieldKey)fieldKey.parent()).field.childTable.klass, this.varName);
        this.condition = String.valueOf(rootTable.varName()) + "." + (String)fieldKey.get(1) + "==" + this.varName;
    }

    public void add(FilterFieldMap fieldMap, TableFieldKey fieldKey) {
        String fieldName = String.valueOf(this.varName) + "." + fieldKey.field();
        this.add(new QueryFieldMap(this.table, fieldMap, fieldKey, fieldName));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.condition);
        for (QueryFieldMap map : this) {
            if (sb.length() > 0) {
                sb.append(" && ");
            }
            sb.append(map.toString());
            this.parametersMap.add(map.getParametersMap());
        }
        return sb.toString();
    }
}

