/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.query.builder;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.jdo.Query;
import org.dma.java.util.StringList;
import org.projectocolibri.api.database.mapper.FIELDS;

public class QueryParametersMap
extends LinkedHashMap<String, Object> {
    private static final long serialVersionUID = 1L;
    private final Collection<String> imports = new LinkedHashSet<String>();
    private final Collection<String> variables = new LinkedHashSet<String>();
    private final Collection<String> parameters = new LinkedHashSet<String>();

    public void add(QueryParametersMap parametersMap) {
        this.imports.addAll(parametersMap.imports);
        this.variables.addAll(parametersMap.variables);
        this.parameters.addAll(parametersMap.parameters);
        this.putAll(parametersMap);
    }

    public Object execute(Query query) {
        query.declareImports(new StringList(this.imports).concat(";"));
        query.declareVariables(new StringList(this.variables).concat(";"));
        query.declareParameters(new StringList(this.parameters).concat(","));
        return query.executeWithMap((Map)this);
    }

    private QueryParametersMap addImport(Class klass) {
        this.imports.add("import " + klass.getName());
        return this;
    }

    public QueryParametersMap addVariable(Class klass, String name) {
        this.variables.add(String.valueOf(klass.getName()) + " " + name);
        return this.addImport(klass);
    }

    public QueryParametersMap addParameter(FIELDS.TYPES type, String name, Object value) {
        this.put(name, value);
        this.parameters.add(String.valueOf(type.type.klass.getName()) + " " + name);
        return this.addImport(type.type.klass);
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [size=" + this.size() + ", values=" + this.values() + ", imports=" + this.imports + ", variables=" + this.variables + ", parameters=" + this.parameters + "]";
    }
}

