/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.query.builder;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import org.dma.java.util.StringUtils;
import org.projectocolibri.api.database.filter.FilterOperandMap;
import org.projectocolibri.api.database.filter.OPERANDS;
import org.projectocolibri.api.database.filter.OPERATORS;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.query.builder.QueryParametersMap;
import org.projectocolibri.core.support.DiacriticalMap;

public class QueryConditionMap
extends LinkedHashSet<String> {
    private static final long serialVersionUID = 1L;
    private final QueryParametersMap parametersMap = new QueryParametersMap();
    private final FilterOperandMap operand;
    private final String fieldName;

    public QueryParametersMap getParametersMap() {
        return this.parametersMap;
    }

    private void add(FIELDS.TYPES type, String name, Object value) {
        this.parametersMap.addParameter(type, name, value);
        this.add(name);
    }

    private void add(FilterOperandMap operand) {
        StringBuilder sb = new StringBuilder(operand.getValue());
        Iterator iterator = operand.iterator();
        while (iterator.hasNext()) {
            OPERANDS.METHODS method = (OPERANDS.METHODS)((Object)iterator.next());
            switch (method) {
                case UNACCENT: {
                    sb.append(this.unaccent());
                    break;
                }
                case COMPACT: {
                    sb.append(".replaceAll(\" \",\"\")");
                    break;
                }
                case LOWERCASE: {
                    sb.append(".toLowerCase()");
                    break;
                }
                case TRIM: {
                    sb.append(".trim()");
                }
            }
        }
        this.add(sb.toString());
    }

    private String unaccent() {
        StringBuilder sb = new StringBuilder();
        String value = this.operand.getType() == OPERANDS.TYPES.FIELD ? "abcdefghijklmnopqrstuvwxyz" : this.operand.getStringValue();
        for (Map.Entry entry : DiacriticalMap.getInstance().entrySet()) {
            if (!value.contains((CharSequence)entry.getKey())) continue;
            String[] stringArray = (String[])entry.getValue();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String c = stringArray[n2];
                sb.append(".replaceAll(" + StringUtils.quote((String)c, (char[])new char[0]) + "," + StringUtils.quote((String)((String)entry.getKey()), (char[])new char[0]) + ")");
                ++n2;
            }
        }
        return sb.toString();
    }

    public QueryConditionMap(FIELDS.TYPES type, FilterOperandMap operand, String fieldName, String parameterName) {
        this.operand = operand;
        this.fieldName = fieldName;
        block0 : switch (type) {
            default: {
                this.add(operand.getValue());
                break;
            }
            case TIME: {
                operand.clear();
                switch (operand.getType()) {
                    case VALUE: 
                    case VAR: {
                        this.add(FIELDS.TYPES.TIME, parameterName, operand.getConverted());
                        break;
                    }
                    case FIELD: {
                        this.add(operand.getValue());
                    }
                }
                break;
            }
            case DATE: {
                operand.clear();
                switch (operand.getType()) {
                    case VALUE: 
                    case VAR: {
                        this.add(FIELDS.TYPES.DATE, parameterName, operand.getConverted());
                        break;
                    }
                    case FIELD: {
                        this.add(operand.getValue());
                    }
                }
                break;
            }
            case STRING: 
            case LONGSTRING: {
                operand.add(0, (Object)OPERANDS.METHODS.LOWERCASE);
                block15 : switch (operand.getOperator()) {
                    case CONTAINS: {
                        switch (operand.getType()) {
                            case VALUE: {
                                for (String value : StringUtils.split((String)operand.getStringValue(), (String)OPERATORS.LOGICAL.AND.symbol)) {
                                    this.add(StringUtils.quote((String)value, (char[])new char[0]));
                                }
                                break block0;
                            }
                            case VAR: {
                                this.add(StringUtils.quote((String)operand.getStringValue(), (char[])new char[0]));
                                break;
                            }
                            case FIELD: {
                                this.add(operand);
                            }
                        }
                        break block0;
                    }
                    case STARTS_WITH: 
                    case ENDS_WITH: 
                    case EQUAL: 
                    case NOT_EQUAL: {
                        switch (operand.getType()) {
                            case VALUE: 
                            case VAR: {
                                this.add(StringUtils.quote((String)operand.getStringValue(), (char[])new char[0]));
                                break block15;
                            }
                            case FIELD: {
                                this.add(operand);
                            }
                        }
                        break;
                    }
                    case BIGGER_EQUAL: 
                    case SMALLER_EQUAL: 
                    case BIGGER_THAN: 
                    case SMALLER_THAN: {
                        switch (operand.getType()) {
                            case VALUE: 
                            case VAR: {
                                this.add(FIELDS.TYPES.STRING, parameterName, operand.getStringValue());
                                break block15;
                            }
                            case FIELD: {
                                this.add(operand);
                            }
                        }
                    }
                }
                break;
            }
            case BOOLEAN: {
                operand.clear();
                switch (operand.getType()) {
                    case VALUE: {
                        this.add(operand.getConverted().toString());
                        break;
                    }
                    case VAR: {
                        throw new UnsupportedOperationException();
                    }
                    case FIELD: {
                        this.add(operand.getValue());
                    }
                }
                break;
            }
            case BINARY: {
                operand.clear();
                switch (operand.getType()) {
                    case VALUE: {
                        this.add(operand.getValue());
                        break block0;
                    }
                    case VAR: {
                        throw new UnsupportedOperationException();
                    }
                    case FIELD: {
                        this.add(operand.getValue());
                    }
                }
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String value : this) {
            if (sb.length() > 0) {
                sb.append(" && ");
            }
            sb.append(this.fieldName);
            Iterator iterator = this.operand.iterator();
            while (iterator.hasNext()) {
                OPERANDS.METHODS method = (OPERANDS.METHODS)((Object)iterator.next());
                switch (method) {
                    case UNACCENT: {
                        sb.append(this.unaccent());
                        break;
                    }
                    case COMPACT: {
                        sb.append(".replaceAll(\" \",\"\")");
                        break;
                    }
                    case LOWERCASE: {
                        sb.append(".toLowerCase()");
                        break;
                    }
                    case TRIM: {
                        sb.append(".trim()");
                    }
                }
            }
            switch (this.operand.getOperator()) {
                case CONTAINS: {
                    sb.append(".indexOf(" + value + ")!=-1");
                    break;
                }
                case STARTS_WITH: {
                    sb.append(".startsWith(" + value + ")");
                    break;
                }
                case ENDS_WITH: {
                    sb.append(".endsWith(" + value + ")");
                    break;
                }
                case EQUAL: {
                    sb.append(StringUtils.isQuoted((String)value, (char[])new char[0]) ? ".equals(" + value + ")" : "==" + value);
                    break;
                }
                case NOT_EQUAL: 
                case BIGGER_EQUAL: 
                case SMALLER_EQUAL: 
                case BIGGER_THAN: 
                case SMALLER_THAN: {
                    sb.append(String.valueOf(this.operand.getOperator().symbol) + value);
                }
            }
        }
        return sb.toString();
    }
}

