/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.query;

import java.util.Collection;
import javax.jdo.PersistenceManager;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.SerializedTransaction;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.AbstractModel;
import org.projectocolibri.api.database.query.QueryDefinition;
import org.projectocolibri.api.database.query.QueryOrdering;

public abstract class TransactionalQuery<T extends AbstractModel>
extends QueryDefinition<T> {
    public final DatabaseManager manager;
    public final PersistenceManager pm;

    public abstract void process(T var1) throws Exception;

    public void store(T model) {
        this.pm.makePersistent(model);
    }

    public void delete(T model) {
        this.pm.deletePersistent(model);
    }

    public void delete(Collection col) {
        this.pm.deletePersistentAll(col);
    }

    @Override
    public void close() {
        super.close();
        this.pm.close();
    }

    public TransactionalQuery(TABLES table, DatabaseManager manager) {
        this(table, manager, manager.getPersistenceManager());
    }

    public TransactionalQuery(TABLES table, DatabaseManager manager, PersistenceManager pm) {
        super(table, QueryOrdering.DIRECTION.ASCENDING);
        this.manager = manager;
        this.pm = pm;
    }

    public void execute() throws Exception {
        this.execute(false);
    }

    public void executeTryCatch() throws Exception {
        this.execute(true);
    }

    private void execute(boolean tryCatch) throws Exception {
        for (AbstractModel model : this.execute(this.pm)) {
            try {
                model.setManager(this.manager);
                SerializedTransaction tx = new SerializedTransaction(this.pm);
                try {
                    tx.begin();
                    model.setCascade(false);
                    this.process(model);
                    tx.commit();
                }
                finally {
                    if (tx.isActive()) {
                        tx.rollback();
                    }
                }
            }
            catch (Exception e) {
                if (tryCatch) continue;
                throw e;
            }
        }
        this.close();
        this.manager.refresh(this.table);
    }
}

