/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.jdo.FetchGroup;
import javax.jdo.FetchPlan;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import org.dma.java.util.StringList;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.mapper.TableFieldKey;
import org.projectocolibri.api.database.query.QueryFetchplan;

public final class QueryFetchplanMap
extends HashMap<Class<?>, Set<String>> {
    private static final long serialVersionUID = 1L;
    private final int fetchDepth;

    public void add(Class<?> klass) {
        if (!this.containsKey(klass)) {
            this.put(klass, new LinkedHashSet());
        }
    }

    public boolean add(Class<?> klass, String fieldName) {
        this.add(klass);
        return ((Set)this.get(klass)).add(fieldName);
    }

    public QueryFetchplanMap(TABLES table, QueryFetchplan fetchplan) {
        QueryFetchplan copy = new QueryFetchplan(new TableFieldKey[0]);
        for (TableFieldKey fieldKey : fetchplan) {
            FIELDS field = table.map.get((TableFieldKey)fieldKey).field;
            if (field.format.isVirtual()) {
                copy.addAll(field.fetchplan);
                continue;
            }
            copy.add(fieldKey);
        }
        this.fetchDepth = copy.getDepth();
        this.add(table.klass, table.map.getKey().name);
        for (TableFieldKey fieldKey : copy) {
            this.create(table, fieldKey);
        }
    }

    private void create(TABLES table, TableFieldKey fieldKey) {
        this.add(table.klass, fieldKey.root().name());
        if (fieldKey.size() > 1) {
            FIELDS rootField = table.map.get((TableFieldKey)fieldKey.root()).field;
            if (rootField.type == FIELDS.TYPES.SET) {
                Class rootTableClass = rootField.childTable.klass;
                this.add(rootTableClass);
                FIELDS tableIndex = rootField.childTable.map.getIndex();
                if (tableIndex != null) {
                    this.add(rootTableClass, tableIndex.name);
                }
            }
            if (rootField.childTable != null) {
                this.create(rootField.childTable, fieldKey.child());
            }
        }
    }

    private Collection<String> createFetchGroups(PersistenceManagerFactory factory) {
        ArrayList<String> fetchGroupNames = new ArrayList<String>(this.size());
        for (Class tableClass : this.keySet()) {
            Collection tableMembers = (Collection)this.get(tableClass);
            String fetchGroupName = String.valueOf(tableClass.getName()) + ":" + tableMembers.hashCode();
            FetchGroup fetchGroup = factory.getFetchGroup(tableClass, fetchGroupName);
            fetchGroup.addMembers(new StringList(tableMembers).toArray());
            fetchGroupNames.add(fetchGroupName);
        }
        return fetchGroupNames;
    }

    public void addTo(PersistenceManager pm) {
        FetchPlan fetchPlan = pm.getFetchPlan();
        fetchPlan.clearGroups();
        fetchPlan.setGroups(this.createFetchGroups(pm.getPersistenceManagerFactory()));
        fetchPlan.setMaxFetchDepth(this.fetchDepth);
        fetchPlan.setFetchSize(0);
    }
}

