/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.query;

import java.util.Collection;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import org.dma.java.time.Chronograph;
import org.projectocolibri.api.database.IDatabaseModel;
import org.projectocolibri.api.database.filter.FilterMap;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.mapper.TableFieldKey;
import org.projectocolibri.api.database.mapper.TableLayoutArray;
import org.projectocolibri.api.database.query.QueryFetchplan;
import org.projectocolibri.api.database.query.QueryOrdering;
import org.projectocolibri.api.database.query.QueryRange;
import org.projectocolibri.api.database.query.builder.QueryTableMap;

public class QueryDefinition<T extends IDatabaseModel>
extends FilterMap {
    private static final long serialVersionUID = 1L;
    private final int id = System.identityHashCode(this);
    private Query JDOQuery;
    private final QueryFetchplan fetchplan = new QueryFetchplan(new TableFieldKey[0]);
    private final QueryOrdering ordering;
    private final QueryRange range;

    public QueryFetchplan fetchplan() {
        return this.fetchplan;
    }

    public QueryOrdering ordering() {
        return this.ordering;
    }

    public QueryRange range() {
        return this.range;
    }

    public QueryDefinition(FilterMap filterMap, QueryOrdering.DIRECTION direction) {
        this(filterMap, direction, new QueryRange());
    }

    public QueryDefinition(FilterMap filterMap, QueryOrdering.DIRECTION direction, QueryRange range) {
        this(filterMap, new QueryOrdering(direction, new TableFieldKey[0]), range);
    }

    public QueryDefinition(FilterMap filterMap, QueryOrdering ordering) {
        this(filterMap, ordering, new QueryRange());
    }

    public QueryDefinition(FilterMap filterMap, QueryOrdering ordering, QueryRange range) {
        this(filterMap.table, ordering, range);
        this.putAll(filterMap.cleanCopy());
    }

    public QueryDefinition(TABLES table, QueryOrdering.DIRECTION direction) {
        this(table, direction, new QueryRange());
    }

    public QueryDefinition(TABLES table, QueryOrdering.DIRECTION direction, QueryRange range) {
        this(table, new QueryOrdering(direction, new TableFieldKey[0]), range);
    }

    public QueryDefinition(TABLES table, QueryOrdering ordering) {
        this(table, ordering, new QueryRange());
    }

    public QueryDefinition(TABLES table, QueryOrdering ordering, QueryRange range) {
        super(table);
        this.ordering = ordering;
        this.range = range;
    }

    @Override
    public QueryDefinition cloneCopy() {
        QueryDefinition<T> clone = new QueryDefinition<T>(this.table, this.ordering.direction, this.range);
        clone.fetchplan.addAll(this.fetchplan);
        clone.ordering.addAll(this.ordering);
        clone.putAll(this);
        return clone;
    }

    public synchronized Collection<T> execute(PersistenceManager pm) {
        if (this.JDOQuery != null) {
            throw new UnsupportedOperationException("Query is active!");
        }
        QueryTableMap map = new QueryTableMap(this);
        this.JDOQuery = this.table.newQuery(pm, this.fetchplan);
        this.JDOQuery.setFilter(map.toString());
        QueryOrdering ordering = this.ordering.cleanCopy(this.table);
        if (!ordering.isEmpty()) {
            this.JDOQuery.setOrdering(ordering.toString());
        }
        if (!this.range.isEmpty()) {
            this.JDOQuery.setRange(this.range.topIndex, this.range.bottomIndex);
        }
        Chronograph time = new Chronograph().start();
        Collection col = (Collection)map.getParametersMap().execute(this.JDOQuery);
        System.out.println("QUERY " + this.id + " [" + map + "] FOUND [" + col.size() + " record(s) in " + time.stop() + "]");
        return col;
    }

    public synchronized void close() {
        if (this.JDOQuery != null) {
            try {
                this.JDOQuery.closeAll();
                this.JDOQuery = null;
                System.out.println("QUERY " + this.id + " CLOSED");
            }
            catch (Exception e) {
                System.err.println("QUERY " + this.id + " NOT CLOSED!");
            }
        }
    }

    public QueryDefinition addFetchplan(TableFieldKey ... fetchplan) {
        return this.addFetchplan(new TableLayoutArray(fetchplan));
    }

    public QueryDefinition addFetchplan(TableLayoutArray fetchplan) {
        this.fetchplan().addAll(fetchplan);
        return this;
    }

    public QueryDefinition addOrdering(TableFieldKey ... ordering) {
        return this.addOrdering(new TableLayoutArray(ordering));
    }

    public QueryDefinition addOrdering(TableLayoutArray ordering) {
        this.ordering().addAll(ordering);
        return this;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [table=" + (Object)((Object)this.table) + ", filter=" + super.toString() + ", fetchplan=" + this.fetchplan + ", ordering=" + this.ordering + ", range=" + this.range + "]";
    }
}

