/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.model.persistence;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import javax.jdo.PersistenceManager;
import org.dma.java.math.SIGNUM;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.Artigosmovimentos;
import org.projectocolibri.api.database.model.Entidades;
import org.projectocolibri.api.database.model.Entidadesartigos;
import org.projectocolibri.api.database.model.Entidadesdocumentos;
import org.projectocolibri.api.database.model.Entidadesdocumentoslinhas;
import org.projectocolibri.api.database.model.Entidadesmovimentos;

public class EntidadesPersistence {
    private final PersistenceManager pm;

    public EntidadesPersistence(PersistenceManager pm) {
        this.pm = pm;
    }

    public void store(Entidadesdocumentos documento, Collection<Entidadesmovimentos> col) {
        this.relations(documento.getLinhasdocumento(), SIGNUM.MINUS_ONE);
        for (Entidadesmovimentos movimento : col) {
            Entidades entidade = documento.getEntidade();
            entidade.addAcumulados(movimento.getValordebito(), movimento.getValorcredito(), movimento.getTiposaldo(), SIGNUM.ONE);
        }
    }

    public void delete(Entidadesdocumentos documento, Collection<Entidadesmovimentos> col) {
        this.relations(documento.getLinhasdocumento(), SIGNUM.ONE);
        for (Entidadesmovimentos movimento : col) {
            Entidades entidade = documento.getEntidade();
            entidade.addAcumulados(movimento.getValordebito(), movimento.getValorcredito(), movimento.getTiposaldo(), SIGNUM.MINUS_ONE);
        }
    }

    public Collection<Entidadesartigos> store(Entidades entidade, Collection<Artigosmovimentos> col) {
        LinkedHashSet<Entidadesartigos> set = new LinkedHashSet<Entidadesartigos>();
        for (Artigosmovimentos movimento : col) {
            Entidadesartigos artigo = (Entidadesartigos)TABLES.entidadesartigos.getObjectOrNull(this.pm, Entidadesartigos.generateKey(entidade.getKey(), movimento.getArtigo().getCodigo(), movimento.getUnidademedida().getCodigo()));
            if (artigo == null) {
                set.add(new Entidadesartigos(movimento));
                continue;
            }
            Entidadesartigos artigo2 = new Entidadesartigos(movimento);
            artigo.setUnidademedida(artigo2.getUnidademedida());
            artigo.setDatadocumento(new Date(artigo2.getDatadocumento().getTime()));
            artigo.setQuantidade(artigo2.getQuantidade());
            artigo.setPreco(artigo2.getPreco());
            artigo.setPercdesconto(artigo2.getPercdesconto());
            artigo.setPercdesconto2(artigo2.getPercdesconto2());
            set.add(artigo);
        }
        return set;
    }

    private void relations(Collection<Entidadesdocumentoslinhas> col, SIGNUM sinal) {
        for (Entidadesdocumentoslinhas linha : col) {
            if (linha.getMovimentoorigem() == null) continue;
            Entidadesmovimentos movimentoorigem = (Entidadesmovimentos)TABLES.entidadesmovimentos.getObject(this.pm, linha.getMovimentoorigem().getKey());
            BigDecimal valoriliquido = linha.getLinhaorigem() == null ? BigDecimal.ZERO : linha.getQuantidade().multiply(linha.getLinhaorigem().getPreco());
            Entidades entidade = movimentoorigem.getEntidade();
            switch (movimentoorigem.getTipodocumento().getMovimentaentidades()) {
                case 1: {
                    entidade.addAcumulados(valoriliquido, BigDecimal.ZERO, movimentoorigem.getTiposaldo(), sinal);
                    break;
                }
                case 2: {
                    entidade.addAcumulados(BigDecimal.ZERO, valoriliquido, movimentoorigem.getTiposaldo(), sinal);
                    break;
                }
                case 3: {
                    entidade.addAcumulados(valoriliquido, valoriliquido, movimentoorigem.getTiposaldo(), sinal);
                }
            }
        }
    }
}

